/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.InvocableDataSource;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.component.WorkflowComponentRegistry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class DataSourceFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(DataSourceFormatter.class);
    private final String idKey = "id";
    private final String typeKey = "type";
    private final String operationKey = "operation";
    private final String categoryKey = "category";
    private final String nameKey = "name";
    private final String descriptionKey = "description";
    private final String replaceSemicolonsKey = "replaceSemicolons";
    private final String cacheKey = "cache";
    private final String cacheExpirationKey = "cacheExpiration";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String type = map.get("type");
            String operation = map.get("operation");
            String category = map.get("category");
            String name = map.get("name");
            String description = map.get("description");
            String replaceSemicolons = map.get("replaceSemicolons");
            String cache = map.get("cache");
            String cacheExpiration = map.get("cacheExpiration");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)type)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_TYPE.name(), this.formatTextValueChange(type, this::translateDateSourceType));
            }
            if (StringUtils.isNotBlank((CharSequence)operation)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_OPERATION.name(), this.formatTextValueChange(operation, this::translateDataSourceOperation));
            }
            if (StringUtils.isNotBlank((CharSequence)category)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_CATEGORY.name(), this.formatTextValueChange(category));
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_NAME.name(), this.formatTextValueChange(name));
            }
            if (StringUtils.isNotBlank((CharSequence)description)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_DESCRIPTION.name(), this.formatTextValueChange(description));
            }
            if (StringUtils.isNotBlank((CharSequence)replaceSemicolons)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_REPLACE_SEMICOLONS.name(), this.formatTextValueChange(replaceSemicolons));
            }
            if (StringUtils.isNotBlank((CharSequence)cache)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_CACHE.name(), this.translateBooleanValue(cache, locale));
            }
            if (StringUtils.isNotBlank((CharSequence)cacheExpiration)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_CACHE_EXPIRATION.name(), this.formatTextValueChange(cacheExpiration));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String translateDateSourceType(String type) {
        WorkflowComponentRegistry registry = (WorkflowComponentRegistry)SpringContext.getBean(WorkflowComponentRegistry.class);
        InvocableDataSource dataSource = registry.getDataSource(type);
        return dataSource != null ? dataSource.getName() : type;
    }

    private String translateDataSourceOperation(String operation) {
        try {
            DataSourceOperation dataSourceOperation = DataSourceOperation.valueOf((String)operation);
            return switch (dataSourceOperation) {
                default -> throw new IncompatibleClassChangeError();
                case DataSourceOperation.READ -> MessageHelper.getMessage((String)"Odczyt");
                case DataSourceOperation.UPDATE -> MessageHelper.getMessage((String)"Aktualizacja");
                case DataSourceOperation.INSERT -> MessageHelper.getMessage((String)"Wstawienie");
                case DataSourceOperation.DELETE -> MessageHelper.getMessage((String)"Usuniecie");
                case DataSourceOperation.FILE -> MessageHelper.getMessage((String)"Pobranie_pliku");
            };
        }
        catch (Exception e) {
            return operation;
        }
    }
}

