/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarResourceShareFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceShareFormatter.class);
    private final String idKey = "id";
    private final String usernameKey = "username";
    private final String groupKey = "group";
    private final String resourceIdKey = "resourceId";
    private final String resourceGroupIdKey = "resourceGroupId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String username = map.get("username");
            String group = map.get("group");
            String resourceId = map.get("resourceId");
            String resourceGroupId = map.get("resourceGroupId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_SHARE_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)username)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_SHARE_USERNAME.name(), this.formatTextValueChange(username));
            }
            if (StringUtils.isNotBlank((CharSequence)group)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_SHARE_GROUP.name(), this.formatTextValueChange(group));
            }
            if (StringUtils.isNotBlank((CharSequence)resourceId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_SHARE_RESOURCE_ID.name(), this.formatTextValueChange(resourceId));
            }
            if (StringUtils.isNotBlank((CharSequence)resourceGroupId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_SHARE_RESOURCE_GROUP_ID.name(), this.formatTextValueChange(resourceGroupId));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

