/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.struts.form.ProcessHistoryForm;
import com.plusmpm.util.HistoryVariable;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.bpmn.BPMNController;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.section.SectionHolder;
import com.suncode.pwfl.workflow.CheckProcessAccess;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ForwardingActionForward;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.Activity;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.transaction.TransactionStatus;

public class ShowProcessHistoryAction
extends Action {
    public static Logger log = Logger.getLogger(ShowProcessHistoryAction.class);
    private static SectionHolder sectionHolder = (SectionHolder)SpringContext.getBean(SectionHolder.class);
    private static WebFragmentsManager webFragmentsManager = (WebFragmentsManager)SpringContext.getBean(WebFragmentsManager.class);
    private static CheckProcessAccess checkProcess = (CheckProcessAccess)SpringContext.getBean(CheckProcessAccess.class);
    public String m_sProcessId = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, final HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<HistoryVariable> nonRouteActivities;
        log.info((Object)"******************************ShowProcessHistoryAction********************");
        ProcessHistoryForm processHistoryForm = (ProcessHistoryForm)form;
        HttpSession session = request.getSession(false);
        request.setAttribute("activeTab", (Object)"WorkflowViews.do");
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        String refresh = "";
        refresh = request.getParameter("srt");
        if (refresh == null) {
            refresh = "0";
        }
        log.info((Object)("Sort:" + refresh));
        if (refresh.compareToIgnoreCase("1") == 0) {
            HistoryVariable[] aViewList1 = (HistoryVariable[])session.getAttribute("activitiesHistory");
            if (aViewList1 != null) {
                log.info((Object)("activitiesHistory not null:" + aViewList1));
                return mapping.findForward("showProcessHistory");
            }
            log.info((Object)("viewList null:" + aViewList1));
        }
        String procId = request.getParameter("ProcessId");
        String tasks = request.getParameter("tasks");
        if (processHistoryForm != null) {
            if (tasks == null) {
                tasks = processHistoryForm.getTasks();
            }
            if (procId == null) {
                procId = processHistoryForm.getProcessId();
            }
        }
        if (StringUtils.isEmpty((CharSequence)procId) && StringUtils.isNotEmpty((CharSequence)this.m_sProcessId)) {
            log.info((Object)("Pobieram zewn\u0119trzne id procesu:" + this.m_sProcessId));
            procId = this.m_sProcessId;
        }
        log.info((Object)(" procId: " + procId));
        String userName = (String)session.getAttribute("username");
        if (!checkProcess.validateIfUserAllowedToViewProcessHistoryAndSetErrorMessage(request, userName, procId)) {
            return mapping.findForward("showErrorMessage");
        }
        HistoryVariable[] activitiesHistory = HistoryVariable.getProcessHistory((String)procId);
        boolean showOnlyLatestActivityDetails = "true".equals(request.getParameter("onlyLatestActivityDetails"));
        if (showOnlyLatestActivityDetails && !(nonRouteActivities = Arrays.stream(activitiesHistory).filter(this::activityIsNotRoute).toList()).isEmpty()) {
            HistoryVariable historyVariable = nonRouteActivities.stream().max(Comparator.comparing(HistoryVariable::getActstarttime)).get();
            String activityHistoryUrl = this.buildActivityHistoryUrl(historyVariable);
            ForwardingActionForward forwardingActionForward = new ForwardingActionForward(activityHistoryUrl);
            forwardingActionForward.setRedirect(true);
            return forwardingActionForward;
        }
        String processName = null;
        final String processId = procId;
        SharkTransactionTemplate tx = new SharkTransactionTemplate();
        tx.setReadOnly(true);
        processName = (String)tx.execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

            public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                ExecutionAdministration ea = SharkFunctions.getExecutionAdministration((SharkTransaction)transaction);
                WfProcess proc = ea.getProcess(transaction, processId);
                request.setAttribute("menu", ShowProcessHistoryAction.this.generateMenu(proc, transaction));
                return LanguageUtils.getProcessName((String)proc.name(transaction), (String)SharkFunctions.getProcessDefId((SharkTransaction)transaction, (String)processId));
            }
        });
        Locale locale = LocaleContextHolder.getLocale();
        if (tasks != null && tasks.compareToIgnoreCase("TRUE") == 0) {
            request.setAttribute("viewtasks", (Object)MessageHelper.getMessage((String)"Zadan", (Locale)locale, (Object[])new Object[0]));
        } else {
            request.setAttribute("viewtasks", (Object)MessageHelper.getMessage((String)"Uzytkownikow", (Locale)locale, (Object[])new Object[0]));
        }
        int uriLenght = request.getRequestURI().length();
        int urlLenght = request.getRequestURL().length();
        String contextPath = request.getRequestURL().toString().substring(0, urlLenght - uriLenght) + request.getContextPath();
        AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
        String processDefId = adminMisc.getProcessDefinitionId(procId);
        session.setAttribute("activitiesHistory", (Object)activitiesHistory);
        session.setAttribute("procName", (Object)processName);
        request.setAttribute("contextPath", (Object)contextPath);
        request.setAttribute("contextPath1", (Object)contextPath);
        request.setAttribute("processDefId", (Object)processDefId);
        request.setAttribute("processId", (Object)procId);
        String key = request.getParameter("key");
        if (StringUtils.isNotBlank((CharSequence)key)) {
            request.setAttribute("key", (Object)key);
        }
        request.setAttribute("tasks", (Object)tasks);
        request.setAttribute("simulationAvailable", (Object)BPMNController.isProcessSimulationAvailable());
        request.setAttribute("actionName", (Object)"SimulateProcess");
        request.setAttribute("auditSuccess", (Object)true);
        return mapping.findForward("showProcessHistory");
    }

    private String buildActivityHistoryUrl(HistoryVariable historyVariable) throws BaseException {
        ShaKey key = (ShaKey)SpringContext.getBean(ShaKey.class);
        return "/ShowDetailHistory.do?histActivityId=" + historyVariable.getActivityKey() + "&ProcessId=" + historyVariable.getProcessKey() + "&key=" + key.get(historyVariable.getActivityKey());
    }

    private boolean activityIsNotRoute(HistoryVariable activityHistory) {
        Activity activityDef = SharkFunctions.getActivityDefinition((String)activityHistory.getProcid(), (String)activityHistory.getActid());
        return activityDef.getActivityType() != 0;
    }

    private List<MenuItem> generateMenu(WfProcess proc, SharkTransaction transaction) throws BaseException {
        String id = proc.key(transaction);
        String type = SharkFunctions.getProcessDefId((SharkTransaction)transaction, (String)id);
        String name = LanguageUtils.getProcessName((String)proc.name(transaction), (String)type);
        String state = proc.state(transaction);
        ProcessHistoryActionSection section = new ProcessHistoryActionSection(id, type, name, state);
        sectionHolder.save(section);
        return webFragmentsManager.getMenu("system.process.history.menu").applyConditions((Section)section).getItems();
    }

    public static class ProcessHistoryActionSection
    extends Section {
        public static final String KEY = "system.process.history.menu";
        private String processId;
        private String processType;
        private String processName;
        private ProcessState processState;

        public ProcessHistoryActionSection(String id, String type, String name, String state) {
            super(KEY);
            this.processId = id;
            this.processType = type;
            this.processName = name;
            this.processState = ProcessState.getState((String)state);
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getProcessName() {
            return this.processName;
        }

        public String getProcessType() {
            return this.processType;
        }

        public ProcessState getProcessState() {
            return this.processState;
        }
    }
}

