

create table Counters
(
/* class Counter*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    name VARCHAR (100) NOT NULL ,
    the_number DECIMAL (19,0) NOT NULL
);


CREATE UNIQUE INDEX Counters_I1 ON Counters (name);

create table objectid
(
    next DECIMAL (19,0) NOT NULL PRIMARY KEY
);

create table LockTable
(
/* class LockEntry*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    EngineName VARCHAR (100) NOT NULL ,
    Id VARCHAR (100) NOT NULL
);


CREATE UNIQUE INDEX LockTable_I1 ON LockTable (Id);
CREATE UNIQUE INDEX LockTable_I2 ON LockTable (Id, EngineName);

create table EventTypes
(
/* class EventType*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    KeyValue VARCHAR (30) NOT NULL ,
    Name VARCHAR (50) NOT NULL
);


CREATE UNIQUE INDEX EventTypes_I1 ON EventTypes (KeyValue);
CREATE UNIQUE INDEX EventTypes_I2 ON EventTypes (Name);

create table ActivityStateEventAudits
(
/* class ActivityStateEventAudit*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    KeyValue VARCHAR (30) NOT NULL ,
    Name VARCHAR (50) NOT NULL
);


CREATE UNIQUE INDEX ActivityStateEventAudits_I1 ON ActivityStateEventAudits (KeyValue);
CREATE UNIQUE INDEX ActivityStateEventAudits_I2 ON ActivityStateEventAudits (Name);




create table AssignmentEventAudits
(
/* class AssignmentEventAudit*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    UTCTime VARCHAR (254) NOT NULL ,
    TheType DECIMAL (19,0) NOT NULL ,
    ActivityId VARCHAR (100) NOT NULL ,
    ActivityName VARCHAR (254) ,
    ProcessId VARCHAR (100) NOT NULL ,
    ProcessName VARCHAR (254) ,
    ProcessDefinitionName VARCHAR (200) NOT NULL ,
    ProcessDefinitionVersion VARCHAR (20) NOT NULL ,
    ActivityDefinitionId VARCHAR (90) NOT NULL ,
    ActivitySetDefinitionId VARCHAR (90) ,
    ProcessDefinitionId VARCHAR (90) NOT NULL ,
    PackageId VARCHAR (90) NOT NULL ,
    OldResourceUsername VARCHAR (100) ,
    OldResourceName VARCHAR (100) ,
    NewResourceUsername VARCHAR (100) NOT NULL ,
    NewResourceName VARCHAR (100) ,
    IsAccepted BOOLEAN NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT AssignmentEventAudits_TheType FOREIGN KEY (TheType) REFERENCES EventTypes (oid)
);


CREATE UNIQUE INDEX AssignmentEventAudits_I1 ON AssignmentEventAudits (CNT);




create table CreateProcessEventAudits
(
/* class CreateProcessEventAudit*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    UTCTime VARCHAR (254) NOT NULL ,
    TheType DECIMAL (19,0) NOT NULL ,
    ProcessId VARCHAR (100) NOT NULL ,
    ProcessName VARCHAR (254) ,
    ProcessDefinitionName VARCHAR (200) NOT NULL ,
    ProcessDefinitionVersion VARCHAR (20) NOT NULL ,
    ProcessDefinitionId VARCHAR (90) NOT NULL ,
    PackageId VARCHAR (90) NOT NULL ,
    PActivityId VARCHAR (100) ,
    PProcessId VARCHAR (100) ,
    PProcessName VARCHAR (254) ,
    PProcessDefinitionName VARCHAR (200) ,
    PProcessDefinitionVersion VARCHAR (20) ,
    PActivityDefinitionId VARCHAR (90) ,
    PActivitySetDefinitionId VARCHAR (90) ,
    PProcessDefinitionId VARCHAR (90) ,
    PPackageId VARCHAR (90) ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT CreateProcessEventAudits_TheType FOREIGN KEY (TheType) REFERENCES EventTypes (oid)
);


CREATE UNIQUE INDEX CreateProcessEventAudits_I1 ON CreateProcessEventAudits (CNT);




create table DataEventAudits
(
/* class DataEventAudit*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    UTCTime VARCHAR (254) NOT NULL ,
    TheType DECIMAL (19,0) NOT NULL ,
    ActivityId VARCHAR (100) ,
    ActivityName VARCHAR (254) ,
    ProcessId VARCHAR (100) NOT NULL ,
    ProcessName VARCHAR (254) ,
    ProcessDefinitionName VARCHAR (200) NOT NULL ,
    ProcessDefinitionVersion VARCHAR (20) NOT NULL ,
    ActivityDefinitionId VARCHAR (90) ,
    ActivitySetDefinitionId VARCHAR (90) ,
    ProcessDefinitionId VARCHAR (90) NOT NULL ,
    PackageId VARCHAR (90) NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT DataEventAudits_TheType FOREIGN KEY (TheType) REFERENCES EventTypes (oid)
);


CREATE UNIQUE INDEX DataEventAudits_I1 ON DataEventAudits (CNT);

create table NewEventAuditDataWOB
(
/* class NewEventAuditDataWOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    DataEventAudit DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL FLOAT ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    CONSTRAINT NewEventAuditDataWOB_DataEventAudit FOREIGN KEY (DataEventAudit) REFERENCES DataEventAudits (oid)
);

CREATE UNIQUE INDEX NewEventAuditDataWOB_I1 ON NewEventAuditDataWOB (DataEventAudit, VariableDefinitionId);

create table NewEventAuditData
(
/* class NewEventAuditData*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    DataEventAudit DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValue VARBINARY ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL FLOAT ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    CONSTRAINT NewEventAuditData_DataEventAudit FOREIGN KEY (DataEventAudit) REFERENCES DataEventAudits (oid)
);


CREATE UNIQUE INDEX NewEventAuditData_I1 ON NewEventAuditData (DataEventAudit, VariableDefinitionId);




create table NewEventAuditDataBLOBs
(
/* class NewEventAuditDataBLOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    NewEventAuditDataWOB DECIMAL (19,0) NOT NULL ,
    VariableValue VARBINARY ,
    CONSTRAINT NewEventAuditDataBLOBs_NewEventAuditDataWOB FOREIGN KEY (NewEventAuditDataWOB) REFERENCES NewEventAuditDataWOB (oid)
);


CREATE UNIQUE INDEX NewEventAuditDataBLOBs_I1 ON NewEventAuditDataBLOBs (NewEventAuditDataWOB);

create table OldEventAuditData
(
/* class OldEventAuditData*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    DataEventAudit DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValue VARBINARY ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL FLOAT ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    CONSTRAINT OldEventAuditData_DataEventAudit FOREIGN KEY (DataEventAudit) REFERENCES DataEventAudits (oid)
);


CREATE UNIQUE INDEX OldEventAuditData_I1 ON OldEventAuditData (DataEventAudit, VariableDefinitionId);

create table OldEventAuditDataWOB
(
/* class OldEventAuditDataWOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    DataEventAudit DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL FLOAT ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    CONSTRAINT OldEventAuditDataWOB_DataEventAudit FOREIGN KEY (DataEventAudit) REFERENCES DataEventAudits (oid)
);

CREATE UNIQUE INDEX OldEventAuditDataWOB_I1 ON OldEventAuditDataWOB (DataEventAudit, VariableDefinitionId);

create table OldEventAuditDataBLOBs
(
/* class OldEventAuditDataBLOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    OldEventAuditDataWOB DECIMAL (19,0) NOT NULL ,
    VariableValue VARBINARY ,
    CONSTRAINT OldEventAuditDataBLOBs_OldEventAuditDataWOB FOREIGN KEY (OldEventAuditDataWOB) REFERENCES OldEventAuditDataWOB (oid)
);

CREATE UNIQUE INDEX OldEventAuditDataBLOBs_I1 ON OldEventAuditDataBLOBs (OldEventAuditDataWOB);

create table ProcessStateEventAudits
(
/* class ProcessStateEventAudit*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    KeyValue VARCHAR (30) NOT NULL ,
    Name VARCHAR (50) NOT NULL
);


CREATE UNIQUE INDEX ProcessStateEventAudits_I1 ON ProcessStateEventAudits (KeyValue);
CREATE UNIQUE INDEX ProcessStateEventAudits_I2 ON ProcessStateEventAudits (Name);




create table StateEventAudits
(
/* class StateEventAudit*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    UTCTime VARCHAR (254) NOT NULL ,
    TheType DECIMAL (19,0) NOT NULL ,
    ActivityId VARCHAR (100) ,
    ActivityName VARCHAR (254) ,
    ProcessId VARCHAR (100) NOT NULL ,
    ProcessName VARCHAR (254) ,
    ProcessDefinitionName VARCHAR (200) NOT NULL ,
    ProcessDefinitionVersion VARCHAR (20) NOT NULL ,
    ActivityDefinitionId VARCHAR (90) ,
    ActivitySetDefinitionId VARCHAR (90) ,
    ProcessDefinitionId VARCHAR (90) NOT NULL ,
    PackageId VARCHAR (90) NOT NULL ,
    OldProcessState DECIMAL (19,0) ,
    NewProcessState DECIMAL (19,0) ,
    OldActivityState DECIMAL (19,0) ,
    NewActivityState DECIMAL (19,0) ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT StateEventAudits_TheType FOREIGN KEY (TheType) REFERENCES EventTypes (oid) ,
    CONSTRAINT StateEventAudits_OldProcessState FOREIGN KEY (OldProcessState) REFERENCES ProcessStateEventAudits (oid) ,
    CONSTRAINT StateEventAudits_NewProcessState FOREIGN KEY (NewProcessState) REFERENCES ProcessStateEventAudits (oid) ,
    CONSTRAINT StateEventAudits_OldActivityState FOREIGN KEY (OldActivityState) REFERENCES ActivityStateEventAudits (oid) ,
    CONSTRAINT StateEventAudits_NewActivityState FOREIGN KEY (NewActivityState) REFERENCES ActivityStateEventAudits (oid)
);


CREATE UNIQUE INDEX StateEventAudits_I1 ON StateEventAudits (CNT);



create table GroupTable
(
/* class Group*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    groupid VARCHAR (100) NOT NULL ,
    description VARCHAR (254)
);


CREATE UNIQUE INDEX GroupTable_I1 ON GroupTable (groupid);




create table GroupGroupTable
(
/* class GroupLink*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    sub_gid DECIMAL (19,0) NOT NULL ,
    groupid DECIMAL (19,0) NOT NULL ,
    CONSTRAINT GroupGroupTable_sub_gid FOREIGN KEY (sub_gid) REFERENCES GroupTable (oid) ,
    CONSTRAINT GroupGroupTable_groupid FOREIGN KEY (groupid) REFERENCES GroupTable (oid)
);


CREATE UNIQUE INDEX GroupGroupTable_I1 ON GroupGroupTable (sub_gid, groupid);
CREATE INDEX GroupGroupTable_I2 ON GroupGroupTable (groupid);




create table UserTable
(
/* class User*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    userid VARCHAR (100) NOT NULL ,
    firstname VARCHAR (50) ,
    lastname VARCHAR (50) ,
    passwd VARCHAR (50) NOT NULL ,
    email VARCHAR (254),
    active BOOLEAN DEFAULT true,
    number VARCHAR (255)
);


CREATE UNIQUE INDEX UserTable_I1 ON UserTable (userid);




create table UserGroupTable
(
/* class UserLink*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    userid DECIMAL (19,0) NOT NULL ,
    groupid DECIMAL (19,0) NOT NULL ,
    CONSTRAINT UserGroupTable_userid FOREIGN KEY (userid) REFERENCES UserTable (oid) ,
    CONSTRAINT UserGroupTable_groupid FOREIGN KEY (groupid) REFERENCES GroupTable (oid)
);


CREATE UNIQUE INDEX UserGroupTable_I1 ON UserGroupTable (userid, groupid);

create table ProcessDefinitions
(
/* class ProcessDefinition*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Name VARCHAR (200) NOT NULL ,
    PackageId VARCHAR (90) NOT NULL ,
    ProcessDefinitionId VARCHAR (90) NOT NULL ,
    ProcessDefinitionCreated BIGINT NOT NULL ,
    ProcessDefinitionVersion VARCHAR (20) NOT NULL ,
    State INTEGER NOT NULL
);

CREATE UNIQUE INDEX ProcessDefinitions_I1 ON ProcessDefinitions (Name);

create table ProcessStates
(
/* class ProcessState*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    KeyValue VARCHAR (30) NOT NULL ,
    Name VARCHAR (50) NOT NULL
);


CREATE UNIQUE INDEX ProcessStates_I1 ON ProcessStates (KeyValue);
CREATE UNIQUE INDEX ProcessStates_I2 ON ProcessStates (Name);

create table Processes
(
/* class Process*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Id VARCHAR (100) NOT NULL ,
    ProcessDefinition DECIMAL (19,0) NOT NULL ,
    PDefName VARCHAR (200) NOT NULL ,
    ActivityRequesterId VARCHAR (100) ,
    ActivityRequesterProcessId VARCHAR (100) ,
    ResourceRequesterId VARCHAR (100) NOT NULL ,
    ExternalRequesterClassName VARCHAR (254) ,
    State DECIMAL (19,0) NOT NULL ,
    Priority INTEGER ,
    Name VARCHAR (254) ,
    Created BIGINT NOT NULL ,
    Started BIGINT ,
    LastStateTime BIGINT NOT NULL ,
    LimitTime BIGINT NOT NULL ,
    Description VARCHAR (254) ,
    CONSTRAINT Processes_ProcessDefinition FOREIGN KEY (ProcessDefinition) REFERENCES ProcessDefinitions (oid) ,
    CONSTRAINT Processes_State FOREIGN KEY (State) REFERENCES ProcessStates (oid)
);


CREATE UNIQUE INDEX Processes_I1 ON Processes (Id);
CREATE INDEX Processes_I2 ON Processes (ProcessDefinition);
CREATE INDEX Processes_I3 ON Processes (State);
CREATE INDEX Processes_I4 ON Processes (ActivityRequesterId);
CREATE INDEX Processes_I5 ON Processes (ResourceRequesterId);




create table ProcessData
(
/* class ProcessData*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Process DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValue VARBINARY ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL DOUBLE PRECISION ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    CONSTRAINT ProcessData_Process FOREIGN KEY (Process) REFERENCES Processes (oid)
);


CREATE UNIQUE INDEX ProcessData_I1 ON ProcessData (Process, VariableDefinitionId);

create table ProcessDataWOB
(
/* class ProcessDataWOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Process DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL DOUBLE PRECISION ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    CONSTRAINT ProcessDataWOB_Process FOREIGN KEY (Process) REFERENCES Processes (oid)
);


CREATE UNIQUE INDEX ProcessDataWOB_I1 ON ProcessDataWOB (Process, VariableDefinitionId);

create table ProcessDataBLOBs
(
/* class ProcessDataBLOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    ProcessDataWOB DECIMAL (19,0) NOT NULL ,
    VariableValue VARBINARY ,
    CONSTRAINT ProcessDataBLOBs_ProcessDataWOB FOREIGN KEY (ProcessDataWOB) REFERENCES ProcessDataWOB (oid)
);

CREATE UNIQUE INDEX ProcessDataBLOBs_I1 ON ProcessDataBLOBs (ProcessDataWOB);

create table ResourcesTable
(
/* class Resource*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Username VARCHAR (100) NOT NULL ,
    Name VARCHAR (100)
);


CREATE UNIQUE INDEX ResourcesTable_I1 ON ResourcesTable (Username);

create table ActivityStates
(
/* class ActivityState*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    KeyValue VARCHAR (30) NOT NULL ,
    Name VARCHAR (50) NOT NULL
);


CREATE UNIQUE INDEX ActivityStates_I1 ON ActivityStates (KeyValue);
CREATE UNIQUE INDEX ActivityStates_I2 ON ActivityStates (Name);

create table Activities
(
/* class Activity*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Id VARCHAR (100) NOT NULL ,
    ActivitySetDefinitionId VARCHAR (90) ,
    ActivityDefinitionId VARCHAR (90) NOT NULL ,
    Process DECIMAL (19,0) NOT NULL ,
    TheResource DECIMAL (19,0) ,
    PDefName VARCHAR (200) NOT NULL ,
    ProcessId VARCHAR (200) NOT NULL ,
    ResourceId VARCHAR (100) ,
    State DECIMAL (19,0) NOT NULL ,
    BlockActivityId VARCHAR (100) ,
    Performer VARCHAR (100) ,
    IsPerformerAsynchronous BOOLEAN ,
    Priority INTEGER ,
    Name VARCHAR (254) ,
    Activated BIGINT NOT NULL ,
    Accepted BIGINT ,
    LastStateTime BIGINT NOT NULL ,
    LimitTime BIGINT NOT NULL ,
    Description VARCHAR (254) ,
    CONSTRAINT Activities_Process FOREIGN KEY (Process) REFERENCES Processes (oid) ,
    CONSTRAINT Activities_TheResource FOREIGN KEY (TheResource) REFERENCES ResourcesTable (oid) ,
    CONSTRAINT Activities_State FOREIGN KEY (State) REFERENCES ActivityStates (oid)
);


CREATE UNIQUE INDEX Activities_I1 ON Activities (Id);
CREATE INDEX Activities_I2 ON Activities (Process, ActivitySetDefinitionId, ActivityDefinitionId);
CREATE INDEX Activities_I3 ON Activities (Process, State);




create table ActivityData
(
/* class ActivityData*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Activity DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValue VARBINARY ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL DOUBLE PRECISION ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    IsResult BOOLEAN NOT NULL ,
    CONSTRAINT ActivityData_Activity FOREIGN KEY (Activity) REFERENCES Activities (oid)
);


CREATE UNIQUE INDEX ActivityData_I1 ON ActivityData (Activity, VariableDefinitionId);

create table ActivityDataWOB
(
/* class ActivityDataWOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Activity DECIMAL (19,0) NOT NULL ,
    VariableDefinitionId VARCHAR (100) NOT NULL ,
    VariableType INTEGER NOT NULL ,
    VariableValueVCHAR VARCHAR (4000) ,
    VariableValueDBL DOUBLE PRECISION ,
    VariableValueLONG BIGINT ,
    VariableValueDATE TIMESTAMP ,
    VariableValueBOOL BOOLEAN ,
    IsResult BOOLEAN NOT NULL ,
    CONSTRAINT ActivityDataWOB_Activity FOREIGN KEY (Activity) REFERENCES Activities (oid)
);

CREATE UNIQUE INDEX ActivityDataWOB_I1 ON ActivityDataWOB (Activity, VariableDefinitionId);

create table ActivityDataBLOBs
(
/* class ActivityDataBLOB*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    ActivityDataWOB DECIMAL (19,0) NOT NULL ,
    VariableValue VARBINARY ,
    CONSTRAINT ActivityDataBLOBs_ActivityDataWOB FOREIGN KEY (ActivityDataWOB) REFERENCES ActivityDataWOB (oid)
);


CREATE UNIQUE INDEX ActivityDataBLOBs_I1 ON ActivityDataBLOBs (ActivityDataWOB);

create table AndJoinTable
(
/* class AndJoinEntry*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Process DECIMAL (19,0) NOT NULL ,
    ActivitySetDefinitionId VARCHAR (90) ,
    ActivityDefinitionId VARCHAR (90) NOT NULL ,
    Activity DECIMAL (19,0) NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT AndJoinTable_Process FOREIGN KEY (Process) REFERENCES Processes (oid) ,
    CONSTRAINT AndJoinTable_Activity FOREIGN KEY (Activity) REFERENCES Activities (oid)
);


CREATE UNIQUE INDEX AndJoinTable_I1 ON AndJoinTable (CNT);
CREATE INDEX AndJoinTable_I2 ON AndJoinTable (Process, ActivitySetDefinitionId, ActivityDefinitionId);
CREATE INDEX AndJoinTable_I3 ON AndJoinTable (Activity);




create table AssignmentsTable
(
/* class Assignment*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Activity DECIMAL (19,0) NOT NULL ,
    TheResource DECIMAL (19,0) NOT NULL ,
    ActivityId VARCHAR (100) NOT NULL ,
    ActivityProcessId VARCHAR (100) NOT NULL ,
    ActivityProcessDefName VARCHAR (200) NOT NULL ,
    ResourceId VARCHAR (100) NOT NULL ,
    IsAccepted BOOLEAN NOT NULL ,
    IsValid BOOLEAN NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT AssignmentsTable_Activity FOREIGN KEY (Activity) REFERENCES Activities (oid) ,
    CONSTRAINT AssignmentsTable_TheResource FOREIGN KEY (TheResource) REFERENCES ResourcesTable (oid)
);


CREATE UNIQUE INDEX AssignmentsTable_I1 ON AssignmentsTable (CNT);
CREATE UNIQUE INDEX AssignmentsTable_I2 ON AssignmentsTable (Activity, TheResource);
CREATE INDEX AssignmentsTable_I3 ON AssignmentsTable (TheResource, IsValid);
CREATE INDEX AssignmentsTable_I4 ON AssignmentsTable (ActivityId);
CREATE INDEX AssignmentsTable_I5 ON AssignmentsTable (ResourceId);




create table Deadlines
(
/* class Deadline*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Process DECIMAL (19,0) NOT NULL ,
    Activity DECIMAL (19,0) NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    TimeLimit BIGINT NOT NULL ,
    ExceptionName VARCHAR (100) NOT NULL ,
    IsSynchronous BOOLEAN NOT NULL ,
    IsExecuted BOOLEAN NOT NULL ,
    CONSTRAINT Deadlines_Process FOREIGN KEY (Process) REFERENCES Processes (oid) ,
    CONSTRAINT Deadlines_Activity FOREIGN KEY (Activity) REFERENCES Activities (oid)
);


CREATE UNIQUE INDEX Deadlines_I1 ON Deadlines (CNT);
CREATE INDEX Deadlines_I2 ON Deadlines (Process, TimeLimit);
CREATE INDEX Deadlines_I3 ON Deadlines (Activity, TimeLimit);

create table ProcessRequesters
(
/* class ProcessRequester*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    Id VARCHAR (100) NOT NULL ,
    ActivityRequester DECIMAL (19,0) ,
    ResourceRequester DECIMAL (19,0) ,
    CONSTRAINT ProcessRequesters_ActivityRequester FOREIGN KEY (ActivityRequester) REFERENCES Activities (oid) ,
    CONSTRAINT ProcessRequesters_ResourceRequester FOREIGN KEY (ResourceRequester) REFERENCES ResourcesTable (oid)
);


CREATE UNIQUE INDEX ProcessRequesters_I1 ON ProcessRequesters (Id);
CREATE INDEX ProcessRequesters_I2 ON ProcessRequesters (ActivityRequester);
CREATE INDEX ProcessRequesters_I3 ON ProcessRequesters (ResourceRequester);

create table GroupUser
(
/* class GroupUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    USERNAME VARCHAR (100) NOT NULL
);


CREATE UNIQUE INDEX GroupUser_I1 ON GroupUser (USERNAME);

create table XPDLParticipantPackage
(
/* class XPDLParticipantPackage*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PACKAGE_ID VARCHAR (90) NOT NULL
);


CREATE UNIQUE INDEX XPDLParticipantPackage_I1 ON XPDLParticipantPackage (PACKAGE_ID);

create table PackLevelParticipant
(
/* class PackLevelParticipant*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PARTICIPANT_ID VARCHAR (90) NOT NULL ,
    PACKAGEOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT PackLevelParticipant_PACKAGEOID FOREIGN KEY (PACKAGEOID) REFERENCES XPDLParticipantPackage (oid)
);


CREATE UNIQUE INDEX PackLevelParticipant_I1 ON PackLevelParticipant (PARTICIPANT_ID, PACKAGEOID);

create table GroupUserPackLevelParticipant
(
/* class GroupUserPackLevelParticipant*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PARTICIPANTOID DECIMAL (19,0) NOT NULL ,
    USEROID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT GroupUserPackLevelParticipant_PARTICIPANTOID FOREIGN KEY (PARTICIPANTOID) REFERENCES PackLevelParticipant (oid) ,
    CONSTRAINT GroupUserPackLevelParticipant_USEROID FOREIGN KEY (USEROID) REFERENCES GroupUser (oid)
);


CREATE UNIQUE INDEX GroupUserPackLevelParticipant_I1 ON GroupUserPackLevelParticipant (PARTICIPANTOID, USEROID);

create table XPDLParticipantProcess
(
/* class XPDLParticipantProcess*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PROCESS_ID VARCHAR (90) NOT NULL ,
    PACKAGEOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT XPDLParticipantProcess_PACKAGEOID FOREIGN KEY (PACKAGEOID) REFERENCES XPDLParticipantPackage (oid)
);

CREATE UNIQUE INDEX XPDLParticipantProcess_I1 ON XPDLParticipantProcess (PROCESS_ID, PACKAGEOID);

create table ProcLevelParticipant
(
/* class ProcLevelParticipant*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PARTICIPANT_ID VARCHAR (90) NOT NULL ,
    PROCESSOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ProcLevelParticipant_PROCESSOID FOREIGN KEY (PROCESSOID) REFERENCES XPDLParticipantProcess (oid)
);


CREATE UNIQUE INDEX ProcLevelParticipant_I1 ON ProcLevelParticipant (PARTICIPANT_ID, PROCESSOID);

create table GroupUserProcLevelParticipant
(
/* class GroupUserProcLevelParticipant*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PARTICIPANTOID DECIMAL (19,0) NOT NULL ,
    USEROID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT GroupUserProcLevelParticipant_PARTICIPANTOID FOREIGN KEY (PARTICIPANTOID) REFERENCES ProcLevelParticipant (oid) ,
    CONSTRAINT GroupUserProcLevelParticipant_USEROID FOREIGN KEY (USEROID) REFERENCES GroupUser (oid)
);


CREATE UNIQUE INDEX GroupUserProcLevelParticipant_I1 ON GroupUserProcLevelParticipant (PARTICIPANTOID, USEROID);




create table NormalUser
(
/* class NormalUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    USERNAME VARCHAR (100) NOT NULL
);


CREATE UNIQUE INDEX NormalUser_I1 ON NormalUser (USERNAME);

create table UserPackLevelParticipant
(
/* class UserPackLevelParticipant*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PARTICIPANTOID DECIMAL (19,0) NOT NULL ,
    USEROID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT UserPackLevelParticipant_PARTICIPANTOID FOREIGN KEY (PARTICIPANTOID) REFERENCES PackLevelParticipant (oid) ,
    CONSTRAINT UserPackLevelParticipant_USEROID FOREIGN KEY (USEROID) REFERENCES NormalUser (oid)
);


CREATE UNIQUE INDEX UserPackLevelParticipant_I1 ON UserPackLevelParticipant (PARTICIPANTOID, USEROID);




create table UserProcLevelParticipant
(
/* class UserProcLevelParticipant*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PARTICIPANTOID DECIMAL (19,0) NOT NULL ,
    USEROID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT UserProcLevelParticipant_PARTICIPANTOID FOREIGN KEY (PARTICIPANTOID) REFERENCES ProcLevelParticipant (oid) ,
    CONSTRAINT UserProcLevelParticipant_USEROID FOREIGN KEY (USEROID) REFERENCES NormalUser (oid)
);


CREATE UNIQUE INDEX UserProcLevelParticipant_I1 ON UserProcLevelParticipant (PARTICIPANTOID, USEROID);

create table XPDLApplicationPackage
(
/* class XPDLApplicationPackage*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PACKAGE_ID VARCHAR (90) NOT NULL
);


CREATE UNIQUE INDEX XPDLApplicationPackage_I1 ON XPDLApplicationPackage (PACKAGE_ID);

create table PackLevelXPDLApp
(
/* class PackLevelXPDLApp*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    APPLICATION_ID VARCHAR (90) NOT NULL ,
    PACKAGEOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT PackLevelXPDLApp_PACKAGEOID FOREIGN KEY (PACKAGEOID) REFERENCES XPDLApplicationPackage (oid)
);


CREATE UNIQUE INDEX PackLevelXPDLApp_I1 ON PackLevelXPDLApp (APPLICATION_ID, PACKAGEOID);

create table ToolAgentApp
(
/* class ToolAgentApp*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    TOOL_AGENT_NAME VARCHAR (250) NOT NULL ,
    APP_NAME VARCHAR (90) NOT NULL
);


CREATE UNIQUE INDEX ToolAgentApp_I1 ON ToolAgentApp (TOOL_AGENT_NAME, APP_NAME);

create table ToolAgentAppDetail
(
/* class ToolAgentAppDetail*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    APP_MODE DECIMAL (10,0) NOT NULL ,
    TOOLAGENT_APPOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ToolAgentAppDetail_TOOLAGENT_APPOID FOREIGN KEY (TOOLAGENT_APPOID) REFERENCES ToolAgentApp (oid)
);

CREATE UNIQUE INDEX ToolAgentAppDetail_I1 ON ToolAgentAppDetail (APP_MODE, TOOLAGENT_APPOID);

create table ToolAgentUser
(
/* class ToolAgentUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    USERNAME VARCHAR (100) NOT NULL ,
    PWD VARCHAR (100)
);

CREATE UNIQUE INDEX ToolAgentUser_I1 ON ToolAgentUser (USERNAME);

create table ToolAgentAppDetailUser
(
/* class ToolAgentAppDetailUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    TOOLAGENT_APPOID DECIMAL (19,0) NOT NULL ,
    USEROID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ToolAgentAppDetailUser_TOOLAGENT_APPOID FOREIGN KEY (TOOLAGENT_APPOID) REFERENCES ToolAgentAppDetail (oid) ,
    CONSTRAINT ToolAgentAppDetailUser_USEROID FOREIGN KEY (USEROID) REFERENCES ToolAgentUser (oid)
);

CREATE UNIQUE INDEX ToolAgentAppDetailUser_I1 ON ToolAgentAppDetailUser (TOOLAGENT_APPOID, USEROID);

create table PackLevelXPDLAppTAAppDetail
(
/* class PackLevelXPDLAppTAAppDetail*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT PackLevelXPDLAppTAAppDetail_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES PackLevelXPDLApp (oid) ,
    CONSTRAINT PackLevelXPDLAppTAAppDetail_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentAppDetail (oid)
);


CREATE UNIQUE INDEX PackLevelXPDLAppTAAppDetail_I1 ON PackLevelXPDLAppTAAppDetail (XPDL_APPOID, TOOLAGENTOID);




create table PackLevelXPDLAppTAAppDetailUsr
(
/* class PackLevelXPDLAppTAAppDetailUsr*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT PackLevelXPDLAppTAAppDetailUsr_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES PackLevelXPDLApp (oid) ,
    CONSTRAINT PackLevelXPDLAppTAAppDetailUsr_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentAppDetailUser (oid)
);


CREATE UNIQUE INDEX PackLevelXPDLAppTAAppDetailUsr_I1 ON PackLevelXPDLAppTAAppDetailUsr (XPDL_APPOID, TOOLAGENTOID);

create table ToolAgentAppUser
(
/* class ToolAgentAppUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    TOOLAGENT_APPOID DECIMAL (19,0) NOT NULL ,
    USEROID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ToolAgentAppUser_TOOLAGENT_APPOID FOREIGN KEY (TOOLAGENT_APPOID) REFERENCES ToolAgentApp (oid) ,
    CONSTRAINT ToolAgentAppUser_USEROID FOREIGN KEY (USEROID) REFERENCES ToolAgentUser (oid)
);


CREATE UNIQUE INDEX ToolAgentAppUser_I1 ON ToolAgentAppUser (TOOLAGENT_APPOID, USEROID);

create table PackLevelXPDLAppTAAppUser
(
/* class PackLevelXPDLAppTAAppUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT PackLevelXPDLAppTAAppUser_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES PackLevelXPDLApp (oid) ,
    CONSTRAINT PackLevelXPDLAppTAAppUser_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentAppUser (oid)
);


CREATE UNIQUE INDEX PackLevelXPDLAppTAAppUser_I1 ON PackLevelXPDLAppTAAppUser (XPDL_APPOID, TOOLAGENTOID);




create table PackLevelXPDLAppToolAgentApp
(
/* class PackLevelXPDLAppToolAgentApp*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT PackLevelXPDLAppToolAgentApp_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES PackLevelXPDLApp (oid) ,
    CONSTRAINT PackLevelXPDLAppToolAgentApp_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentApp (oid)
);


CREATE UNIQUE INDEX PackLevelXPDLAppToolAgentApp_I1 ON PackLevelXPDLAppToolAgentApp (XPDL_APPOID, TOOLAGENTOID);

create table XPDLApplicationProcess
(
/* class XPDLApplicationProcess*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    PROCESS_ID VARCHAR (90) NOT NULL ,
    PACKAGEOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT XPDLApplicationProcess_PACKAGEOID FOREIGN KEY (PACKAGEOID) REFERENCES XPDLApplicationPackage (oid)
);


CREATE UNIQUE INDEX XPDLApplicationProcess_I1 ON XPDLApplicationProcess (PROCESS_ID, PACKAGEOID);

create table ProcLevelXPDLApp
(
/* class ProcLevelXPDLApp*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    APPLICATION_ID VARCHAR (90) NOT NULL ,
    PROCESSOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ProcLevelXPDLApp_PROCESSOID FOREIGN KEY (PROCESSOID) REFERENCES XPDLApplicationProcess (oid)
);


CREATE UNIQUE INDEX ProcLevelXPDLApp_I1 ON ProcLevelXPDLApp (APPLICATION_ID, PROCESSOID);




create table ProcLevelXPDLAppTAAppDetail
(
/* class ProcLevelXPDLAppTAAppDetail*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ProcLevelXPDLAppTAAppDetail_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES ProcLevelXPDLApp (oid) ,
    CONSTRAINT ProcLevelXPDLAppTAAppDetail_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentAppDetail (oid)
);


CREATE UNIQUE INDEX ProcLevelXPDLAppTAAppDetail_I1 ON ProcLevelXPDLAppTAAppDetail (XPDL_APPOID, TOOLAGENTOID);




create table ProcLevelXPDLAppTAAppDetailUsr
(
/* class ProcLevelXPDLAppTAAppDetailUsr*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ProcLevelXPDLAppTAAppDetailUsr_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES ProcLevelXPDLApp (oid) ,
    CONSTRAINT ProcLevelXPDLAppTAAppDetailUsr_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentAppDetailUser (oid)
);


CREATE UNIQUE INDEX ProcLevelXPDLAppTAAppDetailUsr_I1 ON ProcLevelXPDLAppTAAppDetailUsr (XPDL_APPOID, TOOLAGENTOID);

create table ProcLevelXPDLAppTAAppUser
(
/* class ProcLevelXPDLAppTAAppUser*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ProcLevelXPDLAppTAAppUser_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES ProcLevelXPDLApp (oid) ,
    CONSTRAINT ProcLevelXPDLAppTAAppUser_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentAppUser (oid)
);


CREATE UNIQUE INDEX ProcLevelXPDLAppTAAppUser_I1 ON ProcLevelXPDLAppTAAppUser (XPDL_APPOID, TOOLAGENTOID);




create table ProcLevelXPDLAppToolAgentApp
(
/* class ProcLevelXPDLAppToolAgentApp*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDL_APPOID DECIMAL (19,0) NOT NULL ,
    TOOLAGENTOID DECIMAL (19,0) NOT NULL ,
    CONSTRAINT ProcLevelXPDLAppToolAgentApp_XPDL_APPOID FOREIGN KEY (XPDL_APPOID) REFERENCES ProcLevelXPDLApp (oid) ,
    CONSTRAINT ProcLevelXPDLAppToolAgentApp_TOOLAGENTOID FOREIGN KEY (TOOLAGENTOID) REFERENCES ToolAgentApp (oid)
);


CREATE UNIQUE INDEX ProcLevelXPDLAppToolAgentApp_I1 ON ProcLevelXPDLAppToolAgentApp (XPDL_APPOID, TOOLAGENTOID);

create table NextXPDLVersions
(
/* class NextXPDLVersion*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDLId VARCHAR (90) NOT NULL ,
    NextVersion VARCHAR (20) NOT NULL
);


CREATE UNIQUE INDEX NextXPDLVersions_I1 ON NextXPDLVersions (XPDLId, NextVersion);




create table XPDLS
(
/* class XPDL*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDLId VARCHAR (90) NOT NULL ,
    XPDLVersion VARCHAR (20) NOT NULL ,
    XPDLClassVersion BIGINT NOT NULL ,
    XPDLUploadTime TIMESTAMP NOT NULL
);


CREATE UNIQUE INDEX XPDLS_I1 ON XPDLS (XPDLId, XPDLVersion);




create table XPDLData
(
/* class XPDLData*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDLContent VARBINARY NOT NULL ,
    XPDLClassContent VARBINARY NOT NULL ,
    XPDL DECIMAL (19,0) NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT XPDLData_XPDL FOREIGN KEY (XPDL) REFERENCES XPDLS (oid)
);


CREATE UNIQUE INDEX XPDLData_I1 ON XPDLData (CNT);
CREATE UNIQUE INDEX XPDLData_I2 ON XPDLData (XPDL);




create table XPDLHistory
(
/* class XPDLHistory*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDLId VARCHAR (90) NOT NULL ,
    XPDLVersion VARCHAR (20) NOT NULL ,
    XPDLClassVersion BIGINT NOT NULL ,
    XPDLUploadTime TIMESTAMP NOT NULL ,
    XPDLHistoryUploadTime TIMESTAMP NOT NULL
);


CREATE UNIQUE INDEX XPDLHistory_I1 ON XPDLHistory (XPDLId, XPDLVersion);




create table XPDLHistoryData
(
/* class XPDLHistoryData*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    XPDLContent VARBINARY NOT NULL ,
    XPDLClassContent VARBINARY NOT NULL ,
    XPDLHistory DECIMAL (19,0) NOT NULL ,
    CNT DECIMAL (19,0) NOT NULL ,
    CONSTRAINT XPDLHistoryData_XPDLHistory FOREIGN KEY (XPDLHistory) REFERENCES XPDLHistory (oid)
);


CREATE UNIQUE INDEX XPDLHistoryData_I1 ON XPDLHistoryData (CNT);




create table XPDLReferences
(
/* class XPDLReference*/
    oid DECIMAL (19,0) NOT NULL PRIMARY KEY ,
    version INTEGER  NOT NULL  ,
    ReferredXPDLId VARCHAR (90) NOT NULL ,
    ReferringXPDL DECIMAL (19,0) NOT NULL ,
    ReferredXPDLNumber INTEGER NOT NULL ,
    CONSTRAINT XPDLReferences_ReferringXPDL FOREIGN KEY (ReferringXPDL) REFERENCES XPDLS (oid)
);


CREATE UNIQUE INDEX XPDLReferences_I1 ON XPDLReferences (ReferredXPDLId, ReferringXPDL);

INSERT INTO activitystates VALUES (1000001, 0, 'open.running', 'open.running');
INSERT INTO activitystates VALUES (1000003, 0, 'open.not_running.not_started', 'open.not_running.not_started');
INSERT INTO activitystates VALUES (1000005, 0, 'open.not_running.suspended', 'open.not_running.suspended');
INSERT INTO activitystates VALUES (1000007, 0, 'closed.completed', 'closed.completed');
INSERT INTO activitystates VALUES (1000009, 0, 'closed.terminated', 'closed.terminated');
INSERT INTO activitystates VALUES (1000011, 0, 'closed.aborted', 'closed.aborted');

INSERT INTO grouptable VALUES (1000012, 0, 'Administrators', '');

INSERT INTO objectid VALUES (1000600);

INSERT INTO processstates VALUES (1000000, 0, 'open.running', 'open.running');
INSERT INTO processstates VALUES (1000002, 0, 'open.not_running.not_started', 'open.not_running.not_started');
INSERT INTO processstates VALUES (1000004, 0, 'open.not_running.suspended', 'open.not_running.suspended');
INSERT INTO processstates VALUES (1000006, 0, 'closed.completed', 'closed.completed');
INSERT INTO processstates VALUES (1000008, 0, 'closed.terminated', 'closed.terminated');
INSERT INTO processstates VALUES (1000010, 0, 'closed.aborted', 'closed.aborted');

INSERT INTO resourcestable VALUES (1000015, 0, 'admin', NULL);

INSERT INTO usertable VALUES (1000013, 0, 'admin', 'Administrator', 'PlusWorkflow', '73d7665487f88c55adb98e90a84f579728032f46', '', true, NULL);

INSERT INTO usergrouptable VALUES (1000014, 0, 1000013, 1000012);
