/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.tomcat.proxy;

import com.suncode.pwfl.webapp.tomcat.proxy.RoutingContext;
import lombok.NonNull;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.commons.lang3.StringUtils;

public record RequestContext(@NonNull Request request, @NonNull Response response, @NonNull RoutingContext routingContext) {
    public RequestContext(@NonNull Request request, @NonNull Response response, @NonNull RoutingContext routingContext) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (routingContext == null) {
            throw new NullPointerException("routingContext is marked non-null but is null");
        }
    }

    public String requestUriWithinApplication() {
        return StringUtils.removeStart((String)this.request.getRequestURI(), (String)this.routingContext.contextPath());
    }
}

