/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.tomcat.proxy;

import com.suncode.pwfl.webapp.maintenance.Page;
import com.suncode.pwfl.webapp.tomcat.proxy.ProxyRegistration;
import com.suncode.pwfl.webapp.tomcat.proxy.RequestContext;
import com.suncode.pwfl.webapp.tomcat.proxy.RequestHandler;
import com.suncode.pwfl.webapp.tomcat.proxy.RequestPredicates;
import com.suncode.pwfl.webapp.tomcat.proxy.RoutingContext;
import com.suncode.pwfl.webapp.tomcat.proxy.StaticResourceHandler;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.catalina.Context;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class ProxyValve
extends ValveBase {
    private static final Logger log = LoggerFactory.getLogger(ProxyValve.class);
    private final RoutingContext routingContext;
    private final List<Route> routes;
    private final RequestHandler defaultRoute;
    private final Predicate<RoutingContext> proxyPredicate;

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (!this.proxyPredicate.test(this.routingContext)) {
            this.invokeNext(request, response);
            return;
        }
        if (!request.getRequestURI().startsWith(this.routingContext.contextPath())) {
            this.invokeNext(request, response);
            return;
        }
        RequestContext requestContext = new RequestContext(request, response, this.routingContext);
        RequestHandler requestHandler = this.findRequestHandler(requestContext);
        if (requestHandler != null) {
            requestHandler.handle(requestContext);
        } else {
            log.debug("No proxy route matches request {}: {}", (Object)request.getMethod(), (Object)request.getRequestURI());
            this.invokeNext(request, response);
        }
    }

    private void invokeNext(Request request, Response response) {
        this.getNext().invoke(request, response);
    }

    private RequestHandler findRequestHandler(RequestContext request) {
        for (Route route : this.routes) {
            if (!route.test(request)) continue;
            return route;
        }
        return this.defaultRoute;
    }

    public static ProxyBuilder builder() {
        return new ProxyBuilder();
    }

    @ConstructorProperties(value={"routingContext", "routes", "defaultRoute", "proxyPredicate"})
    private ProxyValve(RoutingContext routingContext, List<Route> routes, RequestHandler defaultRoute, Predicate<RoutingContext> proxyPredicate) {
        this.routingContext = routingContext;
        this.routes = routes;
        this.defaultRoute = defaultRoute;
        this.proxyPredicate = proxyPredicate;
    }

    private record Route(Predicate<RequestContext> predicate, RequestHandler handler) implements RequestHandler
    {
        @Override
        public void handle(RequestContext requestContext) throws IOException {
            try {
                this.handler.handle(requestContext);
            }
            catch (Exception e) {
                log.error("Error during proxy route [{}] handling by {}", new Object[]{requestContext.request().getRequestURI(), this.handler, e});
                throw e;
            }
        }

        boolean test(RequestContext request) {
            return this.predicate.test(request);
        }
    }

    public static class ProxyBuilder {
        private final List<Function<RoutingContext, Route>> routes = new ArrayList<Function<RoutingContext, Route>>();
        private RequestHandler fallback;
        private Predicate<RoutingContext> proxyPredicate;

        public ProxyBuilder proxyIf(Predicate<RoutingContext> predicate) {
            this.proxyPredicate = predicate;
            return this;
        }

        public ProxyBuilder resources(String pathPattern) {
            return this.add(routingContext -> new Route(ProxyBuilder.GET(pathPattern), new StaticResourceHandler(routingContext.appContext())));
        }

        public <M> ProxyBuilder GET(String pathPattern, Page<M> page, int status, Function<RequestContext, M> model) {
            return this.add(routingContext -> new Route(ProxyBuilder.GET(pathPattern), requestContext -> {
                Response response = requestContext.response();
                page.render(model.apply(requestContext), response.getResponse());
                response.setStatus(status);
            }));
        }

        public ProxyBuilder otherwise(RequestHandler requestHandler) {
            this.fallback = requestHandler;
            return this;
        }

        private ProxyBuilder add(Function<RoutingContext, Route> route) {
            this.routes.add(route);
            return this;
        }

        @NonNull
        private static Predicate<RequestContext> GET(String pathPattern) {
            return RequestPredicates.path(pathPattern).and(RequestPredicates.httpMethod(HttpMethod.GET));
        }

        public Optional<ProxyRegistration> attach(@NonNull ServletContext servletContext) {
            if (servletContext == null) {
                throw new NullPointerException("servletContext is marked non-null but is null");
            }
            try {
                RoutingContext routingContext = new RoutingContext(ProxyBuilder.resolveTomcatContextViaReflection(servletContext));
                Predicate<RoutingContext> predicate = this.proxyPredicate;
                ProxyValve valve = new ProxyValve(routingContext, this.buildRoutes(routingContext), this.fallback, predicate != null ? request -> predicate.test(routingContext) : request -> true);
                Pipeline pipeline = routingContext.host().getPipeline();
                pipeline.addValve((Valve)valve);
                return Optional.of(() -> pipeline.removeValve((Valve)valve));
            }
            catch (Exception e) {
                log.error("Failed to attach tomcat proxy", (Throwable)e);
                return Optional.empty();
            }
        }

        @NonNull
        private List<Route> buildRoutes(RoutingContext routingContext) {
            return this.routes.stream().map(route -> (Route)route.apply(routingContext)).toList();
        }

        private static Context resolveTomcatContextViaReflection(@NonNull ServletContext servletContext) {
            if (servletContext == null) {
                throw new NullPointerException("servletContext is marked non-null but is null");
            }
            Field appContextField = servletContext.getClass().getDeclaredField("context");
            appContextField.setAccessible(true);
            Object appContext = appContextField.get(servletContext);
            Field tomcatContextField = appContext.getClass().getDeclaredField("context");
            tomcatContextField.setAccessible(true);
            return (Context)tomcatContextField.get(appContext);
        }
    }
}

