/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.maintenance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.maintenance.MaintenanceMode;
import com.suncode.pwfl.web.util.PlusworkflowObjectMapper;
import com.suncode.pwfl.webapp.maintenance.MaintenancePage;
import com.suncode.pwfl.webapp.maintenance.MaintenanceStatus;
import com.suncode.pwfl.webapp.maintenance.Templates;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.MimeTypeUtils;

public class MaintenanceFilter
extends HttpFilter {
    private PlusworkflowObjectMapper objectMapper;
    private MaintenancePage maintenancePageTemplate;
    private final Cache<String, Boolean> usersWithAdminRightsCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(5L)).build();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.objectMapper = new PlusworkflowObjectMapper();
        this.maintenancePageTemplate = Templates.getInstance(filterConfig.getServletContext()).maintenancePage();
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        MaintenanceMode.Status status = MaintenanceMode.status();
        if (status == MaintenanceMode.Status.DISABLED) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getAttribute("PWFL.LOGIN_REQUIRED_RESOURCE") != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (UserContext.isActive()) {
            if (status == MaintenanceMode.Status.ENABLED_SOFT) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (this.isAdmin(UserContext.current().getUser())) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            request.getSession(false).invalidate();
        }
        this.sendMaintenanceStatus(request, response, new MaintenanceStatus(MessageHelper.getMessage((String)"system_maintenance")));
    }

    private boolean isAdmin(UserInfo user) {
        String username = user.getUserName();
        return (Boolean)this.usersWithAdminRightsCache.get((Object)username, () -> Authorization.checkIsUserAdmin((String)username));
    }

    private void sendMaintenanceStatus(HttpServletRequest request, HttpServletResponse response, MaintenanceStatus status) throws IOException {
        response.setStatus(503);
        MediaType mediaType = MaintenanceFilter.determineResultingMediaType(request, MediaType.TEXT_HTML, MediaType.APPLICATION_JSON).orElse(MediaType.TEXT_HTML);
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON)) {
            response.setContentType("application/json");
            response.getWriter().write(this.objectMapper.writeValueAsString((Object)status));
        } else {
            this.maintenancePageTemplate.render(status, response);
        }
    }

    private static Optional<MediaType> determineResultingMediaType(HttpServletRequest request, MediaType ... supportedMediaTypes) {
        String acceptHeader = request.getHeader("Accept");
        try {
            List acceptable = MediaType.parseMediaTypes((String)acceptHeader);
            MimeTypeUtils.sortBySpecificity((List)acceptable);
            return acceptable.stream().flatMap(wanted -> Arrays.stream(supportedMediaTypes).filter(arg_0 -> ((MediaType)wanted).isCompatibleWith(arg_0))).findFirst();
        }
        catch (InvalidMediaTypeException e) {
            return Optional.empty();
        }
    }
}

