/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers.simulation;

import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.workflow.simulation.SimulationService;
import com.suncode.pwfl.workflow.simulation.delegated.SimulationProxy;
import com.suncode.pwfl.workflow.simulation.delegated.exceptions.SimulationProxyException;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SimulationProxyPageController {
    private final SimulationService simulationService;
    private final Experimental experimental;

    @GetMapping(value={"ProcessActivitySimulation.do"})
    public String showActivitySimulation(HttpServletRequest request, @RequestParam String simulationId, @RequestParam String processId, @RequestParam String activityId) {
        if (!this.experimental.hasFeature(ExperimentalFeature.SHARK_SIMULATION)) {
            throw new SimulationProxyException("Simulation is not allowed on this system");
        }
        SimulationProxy simulation = (SimulationProxy)this.simulationService.findActiveById(simulationId).orElseThrow();
        simulation.getContext().getFormService().decorateRequestWithForm(request, processId, activityId);
        return "/task/task.jsp";
    }

    @GetMapping(value={"ProcessHistorySimulation.do"})
    public String showActivityDetailsSimulation(HttpServletRequest request, @RequestParam String simulationId, @RequestParam String processId) {
        if (!this.experimental.hasFeature(ExperimentalFeature.SHARK_SIMULATION)) {
            throw new SimulationProxyException("Simulation is not allowed on this system");
        }
        SimulationProxy simulation = (SimulationProxy)this.simulationService.findActiveById(simulationId).orElseThrow();
        simulation.getContext().getFormService().decorateRequestWithProcessHistory(request, processId);
        return "/searchProcess/ProcessHistory.jsp";
    }

    @GetMapping(value={"ActivityDetailsSimulation.do"})
    public String showActivityDetailsSimulation(HttpServletRequest request, @RequestParam String simulationId, @RequestParam String processId, @RequestParam String activityId) {
        if (!this.experimental.hasFeature(ExperimentalFeature.SHARK_SIMULATION)) {
            throw new SimulationProxyException("Simulation is not allowed on this system");
        }
        SimulationProxy simulation = (SimulationProxy)this.simulationService.findActiveById(simulationId).orElseThrow();
        simulation.getContext().getFormService().decorateRequestWithActivityDetails(request, processId, activityId);
        return "/history/taskhistory.jsp";
    }

    @ConstructorProperties(value={"simulationService", "experimental"})
    @Autowired
    public SimulationProxyPageController(SimulationService simulationService, Experimental experimental) {
        this.simulationService = simulationService;
        this.experimental = experimental;
    }
}

