/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.calendar.user.UserCalendarEventParticipant;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CalendarEventInvitationController {
    private static final Logger log = LoggerFactory.getLogger(CalendarEventInvitationController.class);
    private final UserService userService;
    private final UserCalendarService userCalendarService;

    @RequestMapping(value={"/calendar/invitation/{id}/accept.do"})
    public String acceptInvitation(@PathVariable Long id, HttpServletRequest request) {
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.userCalendarService.acceptUserCalendarEventInvitation(new UserCalendarEventParticipant(id), user);
            return "redirect:/Calendar.do";
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
            request.setAttribute("message", (Object)e.getMessage());
            return "/userViews/userviewserror.jsp";
        }
    }

    @RequestMapping(value={"/calendar/invitation/{id}/decline.do"})
    public String declineInvitation(@PathVariable Long id, HttpServletRequest request) {
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.userCalendarService.declineUserCalendarEventInvitation(new UserCalendarEventParticipant(id), user);
            return "redirect:/Calendar.do";
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
            request.setAttribute("message", (Object)e.getMessage());
            return "/userViews/userviewserror.jsp";
        }
    }

    @ConstructorProperties(value={"userService", "userCalendarService"})
    @Autowired
    public CalendarEventInvitationController(UserService userService, UserCalendarService userCalendarService) {
        this.userService = userService;
        this.userCalendarService = userCalendarService;
    }
}

