/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerResponse;

public final class Routes {
    public static HandlerFunction<ServerResponse> view(@NonNull String viewName) {
        if (viewName == null) {
            throw new NullPointerException("viewName is marked non-null but is null");
        }
        return request -> ServerResponse.ok().render(viewName, new Object[0]);
    }

    public static HandlerFunction<ServerResponse> pathRedirect(@NonNull String redirectPath) {
        if (redirectPath == null) {
            throw new NullPointerException("redirectPath is marked non-null but is null");
        }
        return request -> ServerResponse.permanentRedirect((URI)request.uriBuilder().replacePath(request.requestPath().contextPath() + redirectPath).replaceQuery(URLDecoder.decode(request.servletRequest().getQueryString(), StandardCharsets.UTF_8)).build(new Object[0])).build();
    }

    private Routes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

