/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.workflow.process.map;

import com.suncode.pwfl.web.dto.workflow.process.map.ActivityDto;
import com.suncode.pwfl.web.dto.workflow.process.map.ButtonDto;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import com.suncode.pwfl.web.dto.workflow.process.map.TransitionDto;
import com.suncode.pwfl.web.dto.workflow.process.map.VariableDto;
import com.suncode.pwfl.web.dto.workflow.process.map.VariableRefDto;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Button;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Transition;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ProcessMapper {
    public ProcessDto toDto(Process process) {
        List<ActivityDto> activities = Optional.ofNullable(process.getActivities()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        List<TransitionDto> transitions = Optional.ofNullable(process.getTransitions()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        List<VariableDto> variables = Optional.ofNullable(process.getVariables()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        return ProcessDto.builder().id(process.getId()).name(process.getName()).activities(activities).transitions(transitions).variables(variables).build();
    }

    private ActivityDto toDto(Activity activity) {
        List<VariableRefDto> variableRefs = Optional.ofNullable(activity.getVariableRefs()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        List<ButtonDto> buttons = Optional.ofNullable(activity.getButtons()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        return ActivityDto.builder().id(activity.getId()).name(activity.getName()).transitionType(activity.getTransitionType()).variableRefs(variableRefs).buttons(buttons).build();
    }

    private TransitionDto toDto(Transition transition) {
        return TransitionDto.builder().id(transition.getId()).fromActivityId(transition.getFromActivityId()).toActivityId(transition.getToActivityId()).build();
    }

    private VariableDto toDto(Variable variable) {
        return VariableDto.builder().id(variable.getId()).name(variable.getName()).type(variable.getType()).build();
    }

    private VariableRefDto toDto(VariableRef variableRef) {
        return VariableRefDto.builder().id(variableRef.getId()).visible(variableRef.isVisible()).editable(variableRef.isEditable()).position(variableRef.getPosition()).build();
    }

    private ButtonDto toDto(Button button) {
        return ButtonDto.builder().actionName(button.getActionName()).buttonName(button.getButtonName()).transitionId(button.getTransitionId()).build();
    }

    public Process toProcess(ProcessDto processDto) {
        Process process = new Process(processDto.getId(), processDto.getName());
        List<Variable> variables = processDto.getVariables().stream().map(this::toVariable).toList();
        process.getVariables().addAll(variables);
        List<Activity> activities = processDto.getActivities().stream().map(this::toActivity).toList();
        process.getActivities().addAll(activities);
        List<Transition> transitions = processDto.getTransitions().stream().map(this::toTransition).toList();
        process.getTransitions().addAll(transitions);
        return process;
    }

    private Variable toVariable(VariableDto variableDto) {
        return new Variable(variableDto.getType(), variableDto.getId(), variableDto.getName());
    }

    private Activity toActivity(ActivityDto activityDto) {
        Activity activity = new Activity(activityDto.getId(), activityDto.getName(), activityDto.getTransitionType());
        List<VariableRef> variableRefs = activityDto.getVariableRefs().stream().map(this::toVariableRef).toList();
        activity.getVariableRefs().addAll(variableRefs);
        List<Button> buttons = activityDto.getButtons().stream().map(this::toButton).toList();
        activity.getButtons().addAll(buttons);
        return activity;
    }

    private VariableRef toVariableRef(VariableRefDto variableRefDto) {
        return new VariableRef(variableRefDto.getId(), variableRefDto.isVisible(), variableRefDto.isEditable(), variableRefDto.getPosition());
    }

    private Button toButton(ButtonDto buttonDto) {
        return new Button(buttonDto.getActionName(), buttonDto.getButtonName(), buttonDto.getTransitionId());
    }

    private Transition toTransition(TransitionDto transitionDto) {
        return new Transition(transitionDto.getId(), transitionDto.getFromActivityId(), transitionDto.getToActivityId());
    }
}

