/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.struts;

import com.suncode.pwfl.util.Maps;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.ServletException;
import lombok.NonNull;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class ServletMultipartRequestHandler
implements MultipartRequestHandler {
    private final StandardServletMultipartResolver multipartResolver = new StandardServletMultipartResolver();
    private ActionServlet servlet;
    private ActionMapping mapping;
    private Hashtable fileElements;
    private Hashtable textElements;
    private Hashtable allElements;
    private MultipartHttpServletRequest multipartRequest;

    public void handleRequest(javax.servlet.http.HttpServletRequest request) throws ServletException {
        this.multipartRequest = this.multipartResolver.resolveMultipart((HttpServletRequest)ServletMultipartRequestHandler.unwrapRequest(request));
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            this.multipartRequest.getParameterMap().forEach((name, values) -> {
                for (String value : values) {
                    wrapper.setParameter(name, value);
                }
            });
        }
        this.textElements = new Hashtable(this.multipartRequest.getParameterMap());
        this.fileElements = new Hashtable(Maps.mapValues((Map)this.multipartRequest.getFileMap(), ServletMultipartRequestHandler.adaptToFormFile()));
        this.allElements = new Hashtable();
        this.allElements.putAll(this.textElements);
        this.allElements.putAll(this.fileElements);
    }

    private static javax.servlet.http.HttpServletRequest unwrapRequest(javax.servlet.http.HttpServletRequest request) {
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            return wrapper.getRequest();
        }
        return request;
    }

    public void rollback() {
        this.multipartResolver.cleanupMultipart(this.multipartRequest);
    }

    public void finish() {
        this.rollback();
    }

    @NonNull
    private static BiFunction<String, MultipartFile, FormFileAdapter> adaptToFormFile() {
        return (name, multipartFile) -> new FormFileAdapter((MultipartFile)multipartFile);
    }

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    public Hashtable getFileElements() {
        return this.fileElements;
    }

    public Hashtable getTextElements() {
        return this.textElements;
    }

    public Hashtable getAllElements() {
        return this.allElements;
    }

    private static class FormFileAdapter
    implements FormFile {
        final MultipartFile multipartFile;

        public String getContentType() {
            return this.multipartFile.getContentType();
        }

        public int getFileSize() {
            return (int)this.multipartFile.getSize();
        }

        public String getFileName() {
            return this.multipartFile.getOriginalFilename();
        }

        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.multipartFile.getBytes();
        }

        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.multipartFile.getInputStream();
        }

        public void destroy() {
        }

        public void setContentType(String s) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        public void setFileSize(int i) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        public void setFileName(String s) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        @ConstructorProperties(value={"multipartFile"})
        public FormFileAdapter(MultipartFile multipartFile) {
            this.multipartFile = multipartFile;
        }
    }
}

