/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.plugin;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.config.PluginDetails;
import com.suncode.plugin.framework.license.LicenseService;
import com.suncode.plugin.framework.license.trial.TrialLicenseService;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.Date;

public class PluginInformation {
    private String key;
    private boolean running;
    private String name;
    private String version;
    private String description;
    private String author;
    private String license;
    private Date updated;
    private String systemStartupError;

    public static PluginInformation convertFrom(Plugin plugin, LicenseService licenseService, TrialLicenseService trialLicenseService) {
        PluginInformation information = new PluginInformation();
        information.setKey(plugin.getKey());
        information.setRunning(plugin.getState() == Plugin.PluginState.ACTIVE);
        information.setName(plugin.getName());
        information.setVersion(plugin.getVersion());
        information.setLicense(PluginInformation.resolveLicenseInfo(plugin, licenseService, trialLicenseService));
        information.setUpdated(plugin.getLastUpdateDate());
        information.setSystemStartupError(plugin.getSystemStartupErrorMessage());
        PluginDetails details = plugin.getPluginDescriptor().getDetails();
        information.setDescription(details.getDescription());
        information.setAuthor(details.getAuthor());
        return information;
    }

    private static String resolveLicenseInfo(Plugin plugin, LicenseService licenseService, TrialLicenseService trialLicenseService) {
        String licenseState = plugin.getRequirements().licenseState().name().toLowerCase();
        return MessageHelper.getMessage((String)("plugins.view.information.licenseState." + licenseState), (Object[])new Object[]{PluginInformation.getTrialDaysLeft(plugin.getKey(), licenseService, trialLicenseService)});
    }

    private static long getTrialDaysLeft(String pluginId, LicenseService licenseService, TrialLicenseService trialLicenseService) {
        if (licenseService.getLicenseState(pluginId) != null) {
            return licenseService.getTrialDaysLeft(pluginId);
        }
        return trialLicenseService.getTrialDaysLeft(pluginId);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLicense() {
        return this.license;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getSystemStartupError() {
        return this.systemStartupError;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public void setSystemStartupError(String systemStartupError) {
        this.systemStartupError = systemStartupError;
    }
}

