/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.CalendarType;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarId;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarSet;
import com.suncode.pwfl.calendar.calendarSet.domain.Calendars;
import com.suncode.pwfl.calendar.calendarSet.domain.Name;
import com.suncode.pwfl.calendar.calendarSet.domain.Owner;
import com.suncode.pwfl.calendar.calendarSet.domain.ShareLinkId;
import com.suncode.pwfl.calendar.calendarSet.domain.share.CalendarSetShare;
import com.suncode.pwfl.calendar.calendarSet.domain.share.Group;
import com.suncode.pwfl.calendar.calendarSet.domain.share.ShareTarget;
import com.suncode.pwfl.calendar.external.api.ExternalCalendarService;
import com.suncode.pwfl.calendar.process.api.ProcessCalendarService;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.calendar.view.api.ViewCalendarService;
import com.suncode.pwfl.web.dto.calendar.CalendarDto;
import com.suncode.pwfl.web.dto.calendar.calendarSet.CalendarSetDto;
import com.suncode.pwfl.web.dto.calendar.calendarSet.CalendarSetShareDto;
import com.suncode.pwfl.web.dto.calendar.calendarSet.UpsertCalendarSetDto;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class CalendarSetMapper {
    private static final Logger log = LoggerFactory.getLogger(CalendarSetMapper.class);
    private final UserCalendarService userCalendarService;
    private final ViewCalendarService viewCalendarService;
    private final ProcessCalendarService processCalendarService;
    private final ExternalCalendarService externalCalendarService;
    private final CalendarMapper calendarMapper;

    public CalendarSet toDomain(@RequestBody UpsertCalendarSetDto upsertCalendarSetDto, User user) {
        Name name = new Name(upsertCalendarSetDto.name());
        Owner owner = new Owner(user.getUserName());
        List<CalendarId> calendarIds = upsertCalendarSetDto.calendars().stream().map(calendarIdDto -> new CalendarId(calendarIdDto.id().longValue(), calendarIdDto.calendarType())).toList();
        Calendars calendars = new Calendars(calendarIds);
        return new CalendarSet(name, owner, calendars, Optional.empty());
    }

    public CalendarSetDto toDto(CalendarSet calendarSet, User user) {
        String shareLinkId = calendarSet.shareLinkId().map(ShareLinkId::shareLinkId).orElse(null);
        List<CalendarDto> calendars = calendarSet.calendars().calendars().stream().map(calendarId -> this.getCalendar((CalendarId)calendarId, user)).map(this.calendarMapper::toCalendarDto).toList();
        return new CalendarSetDto(calendarSet.id().id(), calendarSet.name().name(), calendarSet.owner().userId(), calendars, shareLinkId);
    }

    public CalendarSetShareDto toDto(CalendarSetShare calendarSetShare) {
        ShareTarget shareTarget = calendarSetShare.shareTarget();
        String userId = shareTarget instanceof com.suncode.pwfl.calendar.calendarSet.domain.share.User ? ((com.suncode.pwfl.calendar.calendarSet.domain.share.User)shareTarget).userId() : null;
        String groupId = shareTarget instanceof Group ? ((Group)shareTarget).groupId() : null;
        return new CalendarSetShareDto(calendarSetShare.id().id(), userId, groupId);
    }

    public Calendar getCalendar(CalendarId calendarId, User user) {
        return switch (calendarId.calendarType()) {
            case CalendarType.USER -> this.userCalendarService.getCalendar(Long.valueOf(calendarId.id()), user);
            case CalendarType.VIEW -> this.viewCalendarService.getCalendar(Long.valueOf(calendarId.id()), user);
            case CalendarType.PROCESS -> this.processCalendarService.getCalendar(Long.valueOf(calendarId.id()), user);
            case CalendarType.EXTERNAL -> this.externalCalendarService.getCalendar(Long.valueOf(calendarId.id()), user);
            default -> throw new IllegalStateException("Unexpected value: " + calendarId.calendarType());
        };
    }

    @ConstructorProperties(value={"userCalendarService", "viewCalendarService", "processCalendarService", "externalCalendarService", "calendarMapper"})
    @Autowired
    public CalendarSetMapper(UserCalendarService userCalendarService, ViewCalendarService viewCalendarService, ProcessCalendarService processCalendarService, ExternalCalendarService externalCalendarService, CalendarMapper calendarMapper) {
        this.userCalendarService = userCalendarService;
        this.viewCalendarService = viewCalendarService;
        this.processCalendarService = processCalendarService;
        this.externalCalendarService = externalCalendarService;
        this.calendarMapper = calendarMapper;
    }
}

