/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.calendar;

import com.plusmpm.database.UserSearchViewTable;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.DefaultCalendar;
import com.suncode.pwfl.calendar.ExternalCalendar;
import com.suncode.pwfl.calendar.ProcessCalendar;
import com.suncode.pwfl.calendar.UserCalendar;
import com.suncode.pwfl.calendar.ViewCalendar;
import com.suncode.pwfl.calendar.event.Event;
import com.suncode.pwfl.calendar.event.EventRruleHelper;
import com.suncode.pwfl.calendar.event.ExternalCalendarEvent;
import com.suncode.pwfl.calendar.event.ProcessCalendarEvent;
import com.suncode.pwfl.calendar.event.ProcessResourceReservationEvent;
import com.suncode.pwfl.calendar.event.RecurrenceDefinition;
import com.suncode.pwfl.calendar.event.RepeatUntilType;
import com.suncode.pwfl.calendar.event.RruleDetailsDto;
import com.suncode.pwfl.calendar.event.UserCalendarEvent;
import com.suncode.pwfl.calendar.event.UserCalendarEventInvitation;
import com.suncode.pwfl.calendar.event.ViewCalendarEvent;
import com.suncode.pwfl.calendar.external.ExternalCalendarShare;
import com.suncode.pwfl.calendar.external.api.ExternalCalendarService;
import com.suncode.pwfl.calendar.process.ProcessCalendarCriteria;
import com.suncode.pwfl.calendar.process.ProcessCalendarShare;
import com.suncode.pwfl.calendar.process.api.ProcessCalendarService;
import com.suncode.pwfl.calendar.support.CalendarDateConverter;
import com.suncode.pwfl.calendar.support.CalendarHelper;
import com.suncode.pwfl.calendar.user.UserCalendarEventParticipant;
import com.suncode.pwfl.calendar.user.UserCalendarShare;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.calendar.view.ViewCalendarShare;
import com.suncode.pwfl.calendar.view.api.ViewCalendarService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.web.dto.calendar.CalendarDto;
import com.suncode.pwfl.web.dto.calendar.DefaultCalendarDto;
import com.suncode.pwfl.web.dto.calendar.EventInvitationDto;
import com.suncode.pwfl.web.dto.calendar.EventParticipantDto;
import com.suncode.pwfl.web.dto.calendar.ExternalCalendarDto;
import com.suncode.pwfl.web.dto.calendar.ExternalCalendarShareDto;
import com.suncode.pwfl.web.dto.calendar.ProcessCalendarCriteriaDto;
import com.suncode.pwfl.web.dto.calendar.ProcessCalendarDto;
import com.suncode.pwfl.web.dto.calendar.ProcessCalendarShareDto;
import com.suncode.pwfl.web.dto.calendar.UserCalendarDto;
import com.suncode.pwfl.web.dto.calendar.UserCalendarShareDto;
import com.suncode.pwfl.web.dto.calendar.ViewCalendarDto;
import com.suncode.pwfl.web.dto.calendar.ViewCalendarShareDto;
import com.suncode.pwfl.web.dto.calendar.event.EventDto;
import com.suncode.pwfl.web.dto.calendar.event.EventStatus;
import com.suncode.pwfl.web.dto.calendar.event.ExternalCalendarEventDto;
import com.suncode.pwfl.web.dto.calendar.event.ProcessCalendarEventDto;
import com.suncode.pwfl.web.dto.calendar.event.ProcessResourceReservationEventDto;
import com.suncode.pwfl.web.dto.calendar.event.UserCalendarEventDto;
import com.suncode.pwfl.web.dto.calendar.event.ViewCalendarEventDto;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.dmfs.rfc5545.recur.InvalidRecurrenceRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarMapper {
    private static final Logger log = LoggerFactory.getLogger(CalendarMapper.class);
    private final UserService userService;
    private final MessageHelperBean messageHelper;
    private final EventRruleHelper eventRruleHelper;
    private final CalendarDateConverter calendarDateConverter;
    private final CalendarHelper calendarHelper;
    private final UserCalendarService userCalendarService;
    private final ViewCalendarService viewCalendarService;
    private final ProcessCalendarService processCalendarService;
    private final ExternalCalendarService externalCalendarService;

    public CalendarDto toCalendarDto(Calendar calendar) {
        if (calendar instanceof UserCalendar) {
            UserCalendar userCalendar = (UserCalendar)calendar;
            return this.toUserCalendarDto(userCalendar);
        }
        if (calendar instanceof ViewCalendar) {
            ViewCalendar viewCalendar = (ViewCalendar)calendar;
            return this.toViewCalendarDto(viewCalendar);
        }
        if (calendar instanceof DefaultCalendar) {
            DefaultCalendar defaultCalendar = (DefaultCalendar)calendar;
            return this.toDefaultCalendarDto(defaultCalendar);
        }
        if (calendar instanceof ProcessCalendar) {
            ProcessCalendar processCalendar = (ProcessCalendar)calendar;
            return this.toProcessCalendarDto(processCalendar);
        }
        if (calendar instanceof ExternalCalendar) {
            ExternalCalendar externalCalendar = (ExternalCalendar)calendar;
            return this.toExternalCalendarDto(externalCalendar);
        }
        throw new IllegalArgumentException("Calendar type not supported");
    }

    private UserCalendarDto toUserCalendarDto(UserCalendar userCalendar) {
        return ((UserCalendarDto.UserCalendarDtoBuilder)((UserCalendarDto.UserCalendarDtoBuilder)((CalendarDto.CalendarDtoBuilder)((UserCalendarDto.UserCalendarDtoBuilder)((UserCalendarDto.UserCalendarDtoBuilder)((UserCalendarDto.UserCalendarDtoBuilder)((UserCalendarDto.UserCalendarDtoBuilder)UserCalendarDto.builder().id(userCalendar.getId())).name(userCalendar.getName())).translatedName(this.userCalendarService.getCalendarTranslation(userCalendar.getId(), TranslatedFieldType.NAME))).ownerId(userCalendar.getOwner().getUserName())).resourceGroupsIds(userCalendar.getResourceGroupsIds())).color(userCalendar.getColor())).accessLevel(userCalendar.getAccessLevel())).build();
    }

    private ViewCalendarDto toViewCalendarDto(ViewCalendar viewCalendar) {
        return ((ViewCalendarDto.ViewCalendarDtoBuilder)((CalendarDto.CalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)((ViewCalendarDto.ViewCalendarDtoBuilder)ViewCalendarDto.builder().id(viewCalendar.getId())).name(viewCalendar.getName())).translatedName(this.viewCalendarService.getCalendarTranslation(viewCalendar.getId(), TranslatedFieldType.NAME))).ownerId(viewCalendar.getOwner().getUserName())).viewId(viewCalendar.getView().getId())).variableIdStartDateTime(viewCalendar.getVariableIdStartDateTime())).variableIdEndDateTime(viewCalendar.getVariableIdEndDateTime())).durationMinutes(viewCalendar.getDurationMinutes())).allDay(viewCalendar.isAllDay())).nameTemplate(viewCalendar.getNameTemplate())).nameTemplateMonth(viewCalendar.getNameTemplateMonth())).nameTemplateWeek(viewCalendar.getNameTemplateWeek())).nameTemplateDay(viewCalendar.getNameTemplateDay())).descriptionTemplate(viewCalendar.getDescriptionTemplate())).color(viewCalendar.getColor())).build();
    }

    private DefaultCalendarDto toDefaultCalendarDto(DefaultCalendar defaultCalendar) {
        return ((DefaultCalendarDto.DefaultCalendarDtoBuilder)((DefaultCalendarDto.DefaultCalendarDtoBuilder)((DefaultCalendarDto.DefaultCalendarDtoBuilder)((DefaultCalendarDto.DefaultCalendarDtoBuilder)((DefaultCalendarDto.DefaultCalendarDtoBuilder)DefaultCalendarDto.builder().id(defaultCalendar.getId())).name(defaultCalendar.getName())).translatedName(defaultCalendar.getName())).ownerId(defaultCalendar.getOwner().getUserName())).color(defaultCalendar.getColor())).build();
    }

    public ProcessCalendarDto toProcessCalendarDto(ProcessCalendar processCalendar) {
        List<ProcessCalendarCriteriaDto> criteriaDtos = processCalendar.getCriteria().stream().map(this::toProcessCalendarCriteriaDto).toList();
        return ((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((CalendarDto.CalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)((ProcessCalendarDto.ProcessCalendarDtoBuilder)ProcessCalendarDto.builder().id(processCalendar.getId())).name(processCalendar.getName())).translatedName(this.processCalendarService.getCalendarTranslation(processCalendar.getId(), TranslatedFieldType.NAME))).ownerId(processCalendar.getOwner().getUserName())).processDefId(processCalendar.getProcessDefId())).variableIdStartDateTime(processCalendar.getVariableIdStartDateTime())).variableIdEndDateTime(processCalendar.getVariableIdEndDateTime())).durationMinutes(processCalendar.getDurationMinutes())).allDay(processCalendar.isAllDay())).nameTemplate(processCalendar.getNameTemplate())).nameTemplateMonth(processCalendar.getNameTemplateMonth())).nameTemplateWeek(processCalendar.getNameTemplateWeek())).nameTemplateDay(processCalendar.getNameTemplateDay())).descriptionTemplate(processCalendar.getDescriptionTemplate())).color(processCalendar.getColor())).processCreateRestriction(processCalendar.getProcessCreateRestriction())).processCreateType(processCalendar.getProcessCreateType())).criteria(criteriaDtos)).build();
    }

    private ProcessCalendarCriteriaDto toProcessCalendarCriteriaDto(ProcessCalendarCriteria criteria) {
        return new ProcessCalendarCriteriaDto(criteria.getId(), criteria.getType(), criteria.getVariableId(), criteria.getOperator(), criteria.getValue());
    }

    private ProcessCalendarCriteria toProcessCalendarCriteria(ProcessCalendarCriteriaDto criteriaDto) {
        return ProcessCalendarCriteria.builder().id(criteriaDto.id()).type(criteriaDto.type()).variableId(criteriaDto.variableId()).operator(criteriaDto.operator()).value(criteriaDto.value()).build();
    }

    public ExternalCalendarDto toExternalCalendarDto(ExternalCalendar externalCalendar) {
        return ((ExternalCalendarDto.ExternalCalendarDtoBuilder)((ExternalCalendarDto.ExternalCalendarDtoBuilder)((ExternalCalendarDto.ExternalCalendarDtoBuilder)((ExternalCalendarDto.ExternalCalendarDtoBuilder)((ExternalCalendarDto.ExternalCalendarDtoBuilder)((ExternalCalendarDto.ExternalCalendarDtoBuilder)((ExternalCalendarDto.ExternalCalendarDtoBuilder)ExternalCalendarDto.builder().id(externalCalendar.getId())).name(externalCalendar.getName())).translatedName(this.externalCalendarService.getCalendarTranslation(externalCalendar.getId(), TranslatedFieldType.NAME))).color(externalCalendar.getColor())).ownerId(externalCalendar.getOwner().getUserName())).url(externalCalendar.getUrl())).syncIntervalMinutes(externalCalendar.getSyncIntervalMinutes())).build();
    }

    public Calendar toCalendar(CalendarDto calendarDto) {
        if (calendarDto instanceof UserCalendarDto) {
            UserCalendarDto userCalendarDto = (UserCalendarDto)calendarDto;
            return this.toUserCalendar(userCalendarDto);
        }
        if (calendarDto instanceof ViewCalendarDto) {
            ViewCalendarDto viewCalendarDto = (ViewCalendarDto)calendarDto;
            return this.toViewCalendar(viewCalendarDto);
        }
        if (calendarDto instanceof ProcessCalendarDto) {
            ProcessCalendarDto processCalendarDto = (ProcessCalendarDto)calendarDto;
            return this.toProcessCalendar(processCalendarDto);
        }
        if (calendarDto instanceof ExternalCalendarDto) {
            ExternalCalendarDto externalCalendarDto = (ExternalCalendarDto)calendarDto;
            return this.toExternalCalendar(externalCalendarDto);
        }
        throw new IllegalArgumentException("Calendar type not supported");
    }

    public UserCalendar toUserCalendar(UserCalendarDto userCalendarDto) {
        return ((UserCalendar.UserCalendarBuilder)((UserCalendar.UserCalendarBuilder)((UserCalendar.UserCalendarBuilder)UserCalendar.builder().id(userCalendarDto.getId())).name(userCalendarDto.getName())).resourceGroupsIds(userCalendarDto.getResourceGroupsIds()).color(userCalendarDto.getColor())).build();
    }

    public ViewCalendar toViewCalendar(ViewCalendarDto calendarDto) {
        String nameTemplate = StringUtils.isNotBlank((String)calendarDto.getNameTemplate()) ? calendarDto.getNameTemplate() : null;
        String nameTemplateMonth = StringUtils.isNotBlank((String)calendarDto.getNameTemplateMonth()) ? calendarDto.getNameTemplateMonth() : null;
        String nameTemplateWeek = StringUtils.isNotBlank((String)calendarDto.getNameTemplateWeek()) ? calendarDto.getNameTemplateWeek() : null;
        String nameTemplateDay = StringUtils.isNotBlank((String)calendarDto.getNameTemplateDay()) ? calendarDto.getNameTemplateDay() : null;
        return ((ViewCalendar.ViewCalendarBuilder)((ViewCalendar.ViewCalendarBuilder)((ViewCalendar.ViewCalendarBuilder)ViewCalendar.builder().id(calendarDto.getId())).name(calendarDto.getName())).view(new UserSearchViewTable(calendarDto.getViewId())).variableIdStartDateTime(calendarDto.getVariableIdStartDateTime()).variableIdEndDateTime(calendarDto.getVariableIdEndDateTime()).durationMinutes(calendarDto.getDurationMinutes()).allDay(calendarDto.isAllDay()).nameTemplate(nameTemplate).nameTemplateMonth(nameTemplateMonth).nameTemplateWeek(nameTemplateWeek).nameTemplateDay(nameTemplateDay).descriptionTemplate(calendarDto.getDescriptionTemplate()).color(calendarDto.getColor())).build();
    }

    public ExternalCalendar toExternalCalendar(ExternalCalendarDto externalCalendarDto) {
        return ((ExternalCalendar.ExternalCalendarBuilder)((ExternalCalendar.ExternalCalendarBuilder)((ExternalCalendar.ExternalCalendarBuilder)ExternalCalendar.builder().id(externalCalendarDto.getId())).name(externalCalendarDto.getName())).color(externalCalendarDto.getColor())).url(externalCalendarDto.getUrl()).syncIntervalMinutes(externalCalendarDto.getSyncIntervalMinutes()).build();
    }

    public EventParticipantDto toEventParticipantDto(UserCalendarEventParticipant participant) {
        return new EventParticipantDto(participant.getId(), participant.getUser().getUserName(), participant.getStatus());
    }

    private UserCalendarEventParticipant toUserCalendarEventParticipant(EventParticipantDto participantDto) {
        User user = Optional.ofNullable(this.userService.getUser(participantDto.userId(), new String[0])).orElseThrow(() -> new UserNotFoundException(this.messageHelper.getMessage("Nie_znaleziono_uzytkownika_o_loginie", new Object[]{participantDto.userId()})));
        return UserCalendarEventParticipant.builder().id(participantDto.id()).user(user).status(participantDto.status()).build();
    }

    public EventInvitationDto toEventInvitationDto(UserCalendarEventInvitation invitation, User user) {
        return new EventInvitationDto(invitation.getId(), invitation.getUser().getUserName(), this.toUserCalendarEventDto(invitation.getEvent(), user), invitation.getStatus());
    }

    public UserCalendarShareDto toUserCalendarShareDto(UserCalendarShare userCalendarShare) {
        return new UserCalendarShareDto(userCalendarShare.getId(), userCalendarShare.getUserName(), userCalendarShare.getGroupName(), userCalendarShare.getPermissionLevel());
    }

    public UserCalendarShare toUserCalendarShare(UserCalendarShareDto userCalendarShareDto) {
        return UserCalendarShare.builder().id(userCalendarShareDto.id()).userName(userCalendarShareDto.userName()).groupName(userCalendarShareDto.groupName()).permissionLevel(userCalendarShareDto.permissionLevel()).build();
    }

    public ViewCalendarShareDto toViewCalendarShareDto(ViewCalendarShare viewCalendarShare) {
        return new ViewCalendarShareDto(viewCalendarShare.getId(), viewCalendarShare.getUserName(), viewCalendarShare.getGroupName());
    }

    public ViewCalendarShare toViewCalendarShare(ViewCalendarShareDto viewCalendarShareDto) {
        return ViewCalendarShare.builder().id(viewCalendarShareDto.id()).userName(viewCalendarShareDto.userName()).groupName(viewCalendarShareDto.groupName()).build();
    }

    public ProcessCalendarShareDto toProcessCalendarShareDto(ProcessCalendarShare processCalendarShare) {
        return new ProcessCalendarShareDto(processCalendarShare.getId(), processCalendarShare.getUserName(), processCalendarShare.getGroupName());
    }

    public ProcessCalendarShare toProcessCalendarShare(ProcessCalendarShareDto processCalendarShareDto) {
        return ProcessCalendarShare.builder().id(processCalendarShareDto.id()).userName(processCalendarShareDto.userName()).groupName(processCalendarShareDto.groupName()).build();
    }

    public ExternalCalendarShareDto toExternalCalendarShareDto(ExternalCalendarShare externalCalendarShare) {
        return new ExternalCalendarShareDto(externalCalendarShare.getId(), externalCalendarShare.getUserName(), externalCalendarShare.getGroupName());
    }

    public ExternalCalendarShare toExternalCalendarShare(ExternalCalendarShareDto externalCalendarShareDto) {
        return ExternalCalendarShare.builder().id(externalCalendarShareDto.id()).userName(externalCalendarShareDto.userName()).groupName(externalCalendarShareDto.groupName()).build();
    }

    public EventDto toEventDto(Event event, User user) {
        if (event instanceof UserCalendarEvent) {
            UserCalendarEvent userCalendarEvent = (UserCalendarEvent)event;
            return this.toUserCalendarEventDto(userCalendarEvent, user);
        }
        if (event instanceof ViewCalendarEvent) {
            ViewCalendarEvent viewCalendarEvent = (ViewCalendarEvent)event;
            return this.toViewCalendarEventDto(viewCalendarEvent);
        }
        if (event instanceof ProcessCalendarEvent) {
            ProcessCalendarEvent processCalendarEvent = (ProcessCalendarEvent)event;
            return this.toProcessCalendarEventDto(processCalendarEvent);
        }
        if (event instanceof ExternalCalendarEvent) {
            ExternalCalendarEvent externalCalendarEvent = (ExternalCalendarEvent)event;
            return this.toExternalCalendarEventDto(externalCalendarEvent);
        }
        if (event instanceof ProcessResourceReservationEvent) {
            ProcessResourceReservationEvent processResourceReservationEvent = (ProcessResourceReservationEvent)event;
            return this.toProcessResourceReservationEventDto(processResourceReservationEvent);
        }
        throw new IllegalArgumentException("Event type not supported");
    }

    public UserCalendarEventDto toUserCalendarEventDto(UserCalendarEvent event, User user) {
        List<EventParticipantDto> participants = List.of();
        if (event.getParticipants() != null) {
            participants = event.getParticipants().stream().map(this::toEventParticipantDto).toList();
        }
        Calendar calendar = event.getCalendar() != null ? event.getCalendar() : new DefaultCalendar(event.getOwner());
        return ((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)((UserCalendarEventDto.UserCalendarEventDtoBuilder)UserCalendarEventDto.builder().id(event.getId())).calendar(this.toCalendarDto(calendar))).title(event.getTitle())).description(this.calendarHelper.sanitizeDescription(event.getDescription()))).allDay(event.isAllDay())).startDateTime(this.calendarDateConverter.formatDate(event.getStartDateTimeUTC(), event.isAllDay()))).endDateTime(this.calendarDateConverter.formatDate(event.getEndDateTimeUTC(), event.isAllDay()))).eventDisplay(event.getEventDisplay())).recurrence(event.getRecurrenceDefinition() != null)).rruleDetails(this.getRruleDetails(event))).ownerId(event.getOwner() != null ? event.getOwner().getUserName() : null)).participants(participants)).resourceIds(event.getResourceIds())).timeZone(event.getTimeZone())).status(this.resolveStatus(event, user))).build();
    }

    private EventStatus resolveStatus(UserCalendarEvent event, User user) {
        if (event.isCancelled()) {
            return EventStatus.CANCELLED;
        }
        if (user == null) {
            return EventStatus.UNKNOWN;
        }
        if (event.getOwner().equals((Object)user)) {
            return EventStatus.OWNED;
        }
        return Optional.ofNullable(event.getParticipants()).orElse(Set.of()).stream().filter(invitation -> invitation.getUser().equals((Object)user)).map(invitation -> EventStatus.fromEventInvitationStatus(invitation.getStatus())).findFirst().orElse(EventStatus.SHARED);
    }

    public ViewCalendarEventDto toViewCalendarEventDto(ViewCalendarEvent event) {
        return ((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)((ViewCalendarEventDto.ViewCalendarEventDtoBuilder)ViewCalendarEventDto.builder().id(event.getId())).calendar(this.toCalendarDto(event.getCalendar()))).title(event.getTitle())).description(this.calendarHelper.sanitizeDescription(event.getDescription()))).allDay(event.isAllDay())).startDateTime(this.calendarDateConverter.formatDate(event.getStartDateTimeUTC(), event.isAllDay()))).endDateTime(this.calendarDateConverter.formatDate(event.getEndDateTimeUTC(), event.isAllDay()))).eventDisplay(event.getEventDisplay())).processId(event.getProcessId())).activityId(event.getActivityId())).variables(event.getVariables())).titleMonth(event.getTitleMonth())).titleWeek(event.getTitleWeek())).titleDay(event.getTitleDay())).processKey(event.getProcessKey())).activityKey(event.getActivityKey())).canBeExecuted(event.isCanBeExecuted())).build();
    }

    public ProcessCalendarEventDto toProcessCalendarEventDto(ProcessCalendarEvent event) {
        return ((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)((ProcessCalendarEventDto.ProcessCalendarEventDtoBuilder)ProcessCalendarEventDto.builder().id(event.getId())).calendar(this.toCalendarDto(event.getCalendar()))).title(event.getTitle())).description(this.calendarHelper.sanitizeDescription(event.getDescription()))).allDay(event.isAllDay())).startDateTime(this.calendarDateConverter.formatDate(event.getStartDateTimeUTC(), event.isAllDay()))).endDateTime(this.calendarDateConverter.formatDate(event.getEndDateTimeUTC(), event.isAllDay()))).eventDisplay(event.getEventDisplay())).processId(event.getProcessId())).activityId(event.getActivityId())).performersIds(event.getPerformersIds())).variables(event.getVariables())).titleMonth(event.getTitleMonth())).titleWeek(event.getTitleWeek())).titleDay(event.getTitleDay())).activityState(event.getActivityState())).build();
    }

    public ExternalCalendarEventDto toExternalCalendarEventDto(ExternalCalendarEvent event) {
        return ((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)((ExternalCalendarEventDto.ExternalCalendarEventDtoBuilder)ExternalCalendarEventDto.builder().id(event.getId())).calendar(this.toCalendarDto(event.getCalendar()))).title(event.getTitle())).description(this.calendarHelper.sanitizeExternalEventDescription(event.getDescription()))).allDay(event.isAllDay())).startDateTime(this.calendarDateConverter.formatDate(event.getStartDateTimeUTC(), event.isAllDay()))).endDateTime(this.calendarDateConverter.formatDate(event.getEndDateTimeUTC(), event.isAllDay()))).eventDisplay(event.getEventDisplay())).build();
    }

    private ProcessResourceReservationEventDto toProcessResourceReservationEventDto(ProcessResourceReservationEvent event) {
        return ((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)((ProcessResourceReservationEventDto.ProcessResourceReservationEventDtoBuilder)ProcessResourceReservationEventDto.builder().id(event.getId())).title(event.getTitle())).allDay(event.isAllDay())).startDateTime(this.calendarDateConverter.formatDate(event.getStartDateTimeUTC(), event.isAllDay()))).endDateTime(this.calendarDateConverter.formatDate(event.getEndDateTimeUTC(), event.isAllDay()))).eventDisplay(event.getEventDisplay())).processId(event.getProcessId())).resourceIds(List.of(Long.valueOf(event.getResourceId())))).activityId(event.getActivityId())).build();
    }

    @Nullable
    private RruleDetailsDto getRruleDetails(UserCalendarEvent event) {
        if (event.getRecurrenceDefinition() == null) {
            return null;
        }
        try {
            return this.eventRruleHelper.getDtoFromRecurrenceDefinition(event.getRecurrenceDefinition());
        }
        catch (InvalidRecurrenceRuleException e) {
            log.info("Invalid RRule: " + event.getRecurrenceDefinition().recurrencePattern());
            return null;
        }
    }

    public Event toEvent(EventDto eventDto) throws InvalidRecurrenceRuleException {
        if (eventDto instanceof UserCalendarEventDto) {
            UserCalendarEventDto userCalendarEventdto = (UserCalendarEventDto)eventDto;
            return this.toUserCalendarEvent(userCalendarEventdto);
        }
        throw new IllegalArgumentException("Event type not supported");
    }

    public UserCalendarEvent toUserCalendarEvent(UserCalendarEventDto eventDto) throws InvalidRecurrenceRuleException, EmptyPropertyException, IllegalArgumentException {
        LocalDateTime startDate = this.calendarDateConverter.toLocalDateTime(eventDto.getStartDateTime(), eventDto.isAllDay());
        LocalDateTime endDate = this.calendarDateConverter.toLocalDateTime(eventDto.getEndDateTime(), eventDto.isAllDay());
        User owner = this.userService.getUser(eventDto.getOwnerId(), new String[0]);
        Set<Object> participants = Set.of();
        if (eventDto.getParticipants() != null) {
            participants = eventDto.getParticipants().stream().map(this::toUserCalendarEventParticipant).collect(Collectors.toSet());
        }
        RecurrenceDefinition recurrenceDefinition = this.resolveRecurrence(eventDto, startDate, endDate);
        Long calendarId = eventDto.getCalendar() != null ? eventDto.getCalendar().getId() : null;
        return ((UserCalendarEvent.UserCalendarEventBuilder)((UserCalendarEvent.UserCalendarEventBuilder)((UserCalendarEvent.UserCalendarEventBuilder)((UserCalendarEvent.UserCalendarEventBuilder)((UserCalendarEvent.UserCalendarEventBuilder)((UserCalendarEvent.UserCalendarEventBuilder)((UserCalendarEvent.UserCalendarEventBuilder)UserCalendarEvent.builder().id(eventDto.getId())).calendar((Calendar)new UserCalendar(calendarId))).title(eventDto.getTitle())).description(eventDto.getDescription())).allDay(eventDto.isAllDay())).startDateTimeUTC(startDate)).endDateTimeUTC(this.resolveEndDate(eventDto, startDate, endDate))).owner(owner).participants(participants).recurrenceDefinition(recurrenceDefinition).resourceIds(eventDto.getResourceIds()).timeZone(eventDto.getTimeZone()).build();
    }

    private RecurrenceDefinition resolveRecurrence(UserCalendarEventDto eventDto, LocalDateTime startDate, LocalDateTime endDate) throws InvalidRecurrenceRuleException, EmptyPropertyException, IllegalArgumentException {
        if (!eventDto.isRecurrence()) {
            return null;
        }
        this.validateRecurrence(eventDto.getRruleDetails());
        return this.eventRruleHelper.getRecurrenceDefinitionFromEventDto(eventDto.getRruleDetails(), startDate, endDate, null, false);
    }

    private void validateRecurrence(RruleDetailsDto rruleDetails) throws EmptyPropertyException, IllegalArgumentException {
        if (rruleDetails.repeatEveryNumber() == 0) {
            throw new EmptyPropertyException("repeatEveryNumber", this.messageHelper.getMessage("Nie_zdefiniowano_wymaganego_pola", new Object[]{this.messageHelper.getMessage("Powtarzaj_co_ile")}));
        }
        if (rruleDetails.repeatEveryType() == null) {
            throw new EmptyPropertyException("repeatEveryType", this.messageHelper.getMessage("Nie_zdefiniowano_wymaganego_pola", new Object[]{this.messageHelper.getMessage("Powtarzaj_co_typ")}));
        }
        if (rruleDetails.repeatEveryNumber() < 1) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Powtarzaj_co_ile_musi_byc_dodatnie"));
        }
        if (RepeatUntilType.UNTIL_AFTER.equals((Object)rruleDetails.repeatUntilType()) && rruleDetails.repeatUntilAfter() < 2) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Liczba_wystapien_wieksza_niz", new Object[]{1}));
        }
    }

    private LocalDateTime resolveEndDate(UserCalendarEventDto eventDto, LocalDateTime startDate, LocalDateTime endDate) throws InvalidRecurrenceRuleException {
        if (!eventDto.isRecurrence()) {
            return endDate;
        }
        if (eventDto.getRruleDetails().repeatUntilType().equals((Object)RepeatUntilType.NEVER)) {
            return endDate == null ? LocalDateTime.now().plusYears(100L) : endDate.plusYears(100L);
        }
        RecurrenceDefinition recurrenceDefinition = this.eventRruleHelper.getRecurrenceDefinitionFromEventDto(eventDto.getRruleDetails(), startDate, endDate, null, true);
        return this.eventRruleHelper.getLastInstanceDateOfRrule(recurrenceDefinition, startDate, eventDto.getRruleDetails().repeatUntilType().equals((Object)RepeatUntilType.UNTIL_DAY));
    }

    public ProcessCalendar toProcessCalendar(ProcessCalendarDto calendarDto) {
        Set<Object> criteria = Set.of();
        if (calendarDto.getCriteria() != null) {
            criteria = calendarDto.getCriteria().stream().map(this::toProcessCalendarCriteria).collect(Collectors.toSet());
        }
        return ((ProcessCalendar.ProcessCalendarBuilder)((ProcessCalendar.ProcessCalendarBuilder)((ProcessCalendar.ProcessCalendarBuilder)ProcessCalendar.builder().id(calendarDto.getId())).name(calendarDto.getName())).processDefId(calendarDto.getProcessDefId()).variableIdStartDateTime(calendarDto.getVariableIdStartDateTime()).variableIdEndDateTime(calendarDto.getVariableIdEndDateTime()).durationMinutes(calendarDto.getDurationMinutes()).allDay(calendarDto.isAllDay()).nameTemplate(calendarDto.getNameTemplate()).nameTemplateMonth(calendarDto.getNameTemplateMonth()).nameTemplateWeek(calendarDto.getNameTemplateWeek()).nameTemplateDay(calendarDto.getNameTemplateDay()).descriptionTemplate(calendarDto.getDescriptionTemplate()).color(calendarDto.getColor())).processCreateRestriction(calendarDto.getProcessCreateRestriction()).processCreateType(calendarDto.getProcessCreateType()).criteria(criteria).build();
    }

    @ConstructorProperties(value={"userService", "messageHelper", "eventRruleHelper", "calendarDateConverter", "calendarHelper", "userCalendarService", "viewCalendarService", "processCalendarService", "externalCalendarService"})
    @Autowired
    public CalendarMapper(UserService userService, MessageHelperBean messageHelper, EventRruleHelper eventRruleHelper, CalendarDateConverter calendarDateConverter, CalendarHelper calendarHelper, UserCalendarService userCalendarService, ViewCalendarService viewCalendarService, ProcessCalendarService processCalendarService, ExternalCalendarService externalCalendarService) {
        this.userService = userService;
        this.messageHelper = messageHelper;
        this.eventRruleHelper = eventRruleHelper;
        this.calendarDateConverter = calendarDateConverter;
        this.calendarHelper = calendarHelper;
        this.userCalendarService = userCalendarService;
        this.viewCalendarService = viewCalendarService;
        this.processCalendarService = processCalendarService;
        this.externalCalendarService = externalCalendarService;
    }
}

