/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import eu.bitwalker.useragentutils.Version;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentUtils {
    private static final Logger log = LoggerFactory.getLogger(UserAgentUtils.class);

    public static Map<String, Object> resolveUserAgentAuditParams(HttpServletRequest request) {
        String rawUserAgent = request.getHeader("User-Agent");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        try {
            UserAgent userAgent = UserAgent.parseUserAgentString((String)rawUserAgent);
            Browser browser = userAgent.getBrowser();
            Version browserVersion = userAgent.getBrowserVersion();
            OperatingSystem operatingSystem = userAgent.getOperatingSystem();
            params.put("operatingSystem", operatingSystem.getName());
            params.put("browser", browser.getName());
            params.put("browserVersion", browserVersion != null ? browserVersion.getVersion() : "Unknown");
        }
        catch (Exception ex) {
            log.warn("Cannot parse User-Agent", (Throwable)ex);
        }
        params.put("useragent", rawUserAgent);
        return params;
    }
}

