/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.administration.email.AddOrUpdateEmailConfigurationDto;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailConfigurationMapper {
    private final OAuth2ConnectionService oAuth2ConnectionService;
    private final MessageHelperBean messageHelperBean;

    public EmailConfiguration toEntity(AddOrUpdateEmailConfigurationDto addOrUpdateEmailConfigurationDto) {
        EmailConfiguration emailConfiguration = EmailConfiguration.builder().id(addOrUpdateEmailConfigurationDto.getId()).name(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getName())).email(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getEmail())).defaultConfiguration(Boolean.valueOf(addOrUpdateEmailConfigurationDto.isDefaultConfiguration())).mailServer(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getMailServer())).smtpMailServer(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getSmtpMailServer())).smtpPortNumber(Integer.valueOf(addOrUpdateEmailConfigurationDto.getSmtpPortNumber())).sourceAddress(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getSourceAddress())).timeout(Integer.valueOf(addOrUpdateEmailConfigurationDto.getTimeout())).mailUser(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getMailUser())).useSSL(Boolean.valueOf(addOrUpdateEmailConfigurationDto.isUseSSL())).useStartTLS(Boolean.valueOf(addOrUpdateEmailConfigurationDto.isUseStartTLS())).smtpUser(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getSmtpUser())).encryptedUserPassword(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getUserPassword())).debug(Boolean.valueOf(addOrUpdateEmailConfigurationDto.isDebug())).emailAuthenticationMethod(addOrUpdateEmailConfigurationDto.getEmailAuthenticationMethod()).bufferedSender(Boolean.valueOf(addOrUpdateEmailConfigurationDto.isBufferSender())).maxAttempts(Integer.valueOf(addOrUpdateEmailConfigurationDto.getMaxAttempts())).period(Integer.valueOf(addOrUpdateEmailConfigurationDto.getPeriod())).tryAfter(Integer.valueOf(addOrUpdateEmailConfigurationDto.getTryAfter())).sendCopy(Boolean.valueOf(addOrUpdateEmailConfigurationDto.isSendCopy())).sendCopyRecipients(StringUtils.trim((String)addOrUpdateEmailConfigurationDto.getEmail())).sendCopyRecipientsType(addOrUpdateEmailConfigurationDto.getSendCopyRecipientsType()).build();
        if (addOrUpdateEmailConfigurationDto.getOauth2Connection() != null) {
            OAuth2Connection oAuth2Connection = Optional.ofNullable((OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)addOrUpdateEmailConfigurationDto.getOauth2Connection())).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_polaczenia_OAuth_o_podanym_identyfikatorze", new Object[]{addOrUpdateEmailConfigurationDto.getOauth2Connection()})));
            emailConfiguration.setOauth2Connection(oAuth2Connection);
        }
        return emailConfiguration;
    }

    @ConstructorProperties(value={"oAuth2ConnectionService", "messageHelperBean"})
    @Autowired
    public EmailConfigurationMapper(OAuth2ConnectionService oAuth2ConnectionService, MessageHelperBean messageHelperBean) {
        this.oAuth2ConnectionService = oAuth2ConnectionService;
        this.messageHelperBean = messageHelperBean;
    }
}

