/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.google.common.base.Preconditions;
import com.plusmpm.listener.PlusWorkflowListener;
import com.suncode.pwfl.config.Config;
import com.suncode.pwfl.config.database.DatabaseConfig;
import com.suncode.pwfl.config.database.DatabaseProperties;
import com.suncode.pwfl.config.database.strategy.file.FileBasedDatabaseProperties;
import com.suncode.pwfl.config.properties.PropertiesStore;
import com.suncode.pwfl.core.RestartService;
import com.suncode.pwfl.database.support.DatabaseTester;
import com.suncode.pwfl.util.SpringContext;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class DatabaseSetupFilter
implements Filter {
    private static final String SETUP_COMPLETED = "embedded_db_setup_completed";
    private PropertiesStore propertiesStore;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.propertiesStore == null) {
            this.propertiesStore = (PropertiesStore)SpringContext.getBean(PropertiesStore.class);
        }
        if (!PlusWorkflowListener.embeddedDatabase.isPresent() || this.propertiesStore.contains(SETUP_COMPLETED)) {
            chain.doFilter(request, response);
        } else {
            request.getRequestDispatcher("/DatabaseConfig.do").forward(request, response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public static final class DatabaseValidation {
        private final boolean success;
        private final boolean restarting;

        public static DatabaseValidation invalid() {
            return new DatabaseValidation(false, false);
        }

        public static DatabaseValidation restarting() {
            return new DatabaseValidation(true, true);
        }

        public static DatabaseValidation notRestarting() {
            return new DatabaseValidation(true, false);
        }

        @ConstructorProperties(value={"success", "restarting"})
        public DatabaseValidation(boolean success, boolean restarting) {
            this.success = success;
            this.restarting = restarting;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isRestarting() {
            return this.restarting;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseValidation)) {
                return false;
            }
            DatabaseValidation other = (DatabaseValidation)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            return this.isRestarting() == other.isRestarting();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + (this.isRestarting() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "DatabaseSetupFilter.DatabaseValidation(success=" + this.isSuccess() + ", restarting=" + this.isRestarting() + ")";
        }
    }

    @Controller
    @RequestMapping(value={"init/database"}, method={RequestMethod.POST})
    public static class InitDatabaseController {
        private final Config config;
        private final RestartService restartService;
        private final PropertiesStore propertiesStore;

        @RequestMapping(value={"embedded"})
        @ResponseBody
        public void useEmbedded() {
            this.markSetupCompleted();
        }

        @RequestMapping(value={"standalone"})
        @ResponseBody
        public DatabaseValidation useStandalone(@RequestBody DatabaseConfig.Connection connection) {
            Preconditions.checkState((boolean)PlusWorkflowListener.embeddedDatabase.isPresent());
            Preconditions.checkState((!this.propertiesStore.contains(DatabaseSetupFilter.SETUP_COMPLETED) ? 1 : 0) != 0);
            if (!DatabaseTester.testDatabaseConnection((DatabaseConfig.Connection)connection)) {
                return DatabaseValidation.invalid();
            }
            DatabaseProperties properties = this.config.getDatabaseProperties();
            Preconditions.checkState((boolean)(properties instanceof FileBasedDatabaseProperties));
            FileBasedDatabaseProperties fileBasedDatabaseProperties = (FileBasedDatabaseProperties)properties;
            fileBasedDatabaseProperties.updateConfig(config -> config.withConnection(connection));
            this.markSetupCompleted();
            if (this.restartService.isRestartSupported()) {
                this.restartService.restartAsync();
                return DatabaseValidation.restarting();
            }
            return DatabaseValidation.notRestarting();
        }

        private void markSetupCompleted() {
            this.propertiesStore.set(DatabaseSetupFilter.SETUP_COMPLETED, "true");
        }

        @ConstructorProperties(value={"config", "restartService", "propertiesStore"})
        @Autowired
        public InitDatabaseController(Config config, RestartService restartService, PropertiesStore propertiesStore) {
            this.config = config;
            this.restartService = restartService;
            this.propertiesStore = propertiesStore;
        }
    }
}

