/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.userdeactivation;

import com.suncode.pwfl.administration.user.Deactivation;
import com.suncode.pwfl.administration.user.DeactivationActivity;
import com.suncode.pwfl.administration.user.DeactivationParticipant;
import com.suncode.pwfl.administration.user.DeactivationProcess;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.deactivation.DeactivationParamDto;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.dto.userdeactivation.ActivityTypeDto;
import com.suncode.pwfl.web.dto.userdeactivation.ExtraTransferDto;
import com.suncode.pwfl.web.dto.userdeactivation.ParticipantDto;
import com.suncode.pwfl.web.dto.userdeactivation.ProcessTypeDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.support.TransactionTemplate;

public class DeactivationDto {
    private String userName;
    private String delegationUser;
    private String viewUser;
    private String reportUser;
    private String notificationUser;
    private String otherAcitivitiesUser;
    private String favouriteSetsUser;
    private Boolean skipSubstitutions;
    private Boolean skipNotifications;
    private Boolean performConcurrently = false;
    private List<ExtraTransferDto> extraTransfers;
    private List<ProcessTypeDto> processes;
    private Boolean runInBackground;
    private Boolean runInScheduledTask = false;

    public static Deactivation convertToDeactivation(DeactivationDto deactivationDto) {
        TransactionTemplate template = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        return (Deactivation)template.execute(status -> {
            HashMap<String, User> cachedUsers = new HashMap<String, User>();
            HashMap<String, UserGroup> cachedGroups = new HashMap<String, UserGroup>();
            ArrayList<DeactivationProcess> processes = new ArrayList<DeactivationProcess>();
            List<ProcessTypeDto> processesDto = deactivationDto.getProcesses();
            for (ProcessTypeDto processDto : processesDto) {
                ArrayList<DeactivationParticipant> participants = new ArrayList<DeactivationParticipant>();
                List<ParticipantDto> participantsDto = processDto.getChildren();
                for (ParticipantDto participantDto : participantsDto) {
                    ArrayList<DeactivationActivity> activities = new ArrayList<DeactivationActivity>();
                    List<ActivityTypeDto> activitiesDto = participantDto.getChildren();
                    for (ActivityTypeDto activityTypeDto : activitiesDto) {
                        activities.add(DeactivationDto.getActivity(activityTypeDto, cachedUsers, cachedGroups));
                    }
                    participants.add(new DeactivationParticipant(participantDto.getId(), participantDto.getName(), activities));
                }
                processes.add(new DeactivationProcess(processDto.getName(), processDto.getProcessDefId(), processDto.getDescription(), processDto.getPackageId(), participants));
            }
            UserService userService = ServiceFactory.getUserService();
            Deactivation deactivation = Deactivation.create((String)deactivationDto.getUserName(), processes);
            deactivation.setSubstitutionUser(userService.getUser(deactivationDto.getDelegationUser(), new String[0]));
            deactivation.setNotificationUser(userService.getUser(deactivationDto.getNotificationUser(), new String[0]));
            deactivation.setReportUser(userService.getUser(deactivationDto.getReportUser(), new String[0]));
            deactivation.setViewUser(userService.getUser(deactivationDto.getViewUser(), new String[0]));
            deactivation.setOtherAcitivitiesUser(userService.getUser(deactivationDto.getOtherAcitivitiesUser(), new String[0]));
            deactivation.setFavouriteSetsUser(userService.getUser(deactivationDto.getFavouriteSetsUser(), new String[0]));
            deactivation.setSkipSubstitutions(deactivationDto.getSkipSubstitutions().booleanValue());
            deactivation.setSkipNotifications(deactivationDto.getSkipNotifications().booleanValue());
            deactivation.setPerformConcurrently(deactivationDto.getPerformConcurrently().booleanValue());
            deactivation.setExtraTransfers(deactivationDto.extraTransfers.stream().collect(Collectors.toMap(item -> item.getId(), item -> userService.getUser(item.getValue(), new String[0]))));
            deactivation.setRunInBackground(deactivationDto.getRunInBackground());
            return deactivation;
        });
    }

    public static DeactivationParamDto convertToDeactivationParamDto(DeactivationDto deactivationDto) {
        DeactivationParamDto deactivationParamDto = new DeactivationParamDto();
        deactivationParamDto.setUserName(deactivationDto.getUserName());
        deactivationParamDto.setProcesses(deactivationDto.getProcesses().stream().map(ProcessTypeDto::toParamDto).collect(Collectors.toList()));
        deactivationParamDto.setDelegationUser(deactivationDto.getDelegationUser());
        deactivationParamDto.setNotificationUser(deactivationDto.getNotificationUser());
        deactivationParamDto.setReportUser(deactivationDto.getReportUser());
        deactivationParamDto.setViewUser(deactivationDto.getViewUser());
        deactivationParamDto.setOtherActivitiesUser(deactivationDto.getOtherAcitivitiesUser());
        deactivationParamDto.setFavouriteSetsUser(deactivationDto.getFavouriteSetsUser());
        deactivationParamDto.setSkipSubstitutions(deactivationDto.getSkipSubstitutions());
        deactivationParamDto.setSkipNotifications(deactivationDto.getSkipNotifications());
        deactivationParamDto.setPerformConcurrently(deactivationDto.getPerformConcurrently());
        deactivationParamDto.setExtraTransfers(deactivationDto.getExtraTransfers().stream().map(ExtraTransferDto::toParamDto).collect(Collectors.toList()));
        return deactivationParamDto;
    }

    private static DeactivationActivity getActivity(ActivityTypeDto activityTypeDto, Map<String, User> cachedUsers, Map<String, UserGroup> cachedGroups) {
        UserService userService = ServiceFactory.getUserService();
        UserGroupFinder userGroupFinder = FinderFactory.getUserGroupFinder();
        DeactivationActivity activity = new DeactivationActivity(activityTypeDto.getName(), activityTypeDto.getActivityDefId(), activityTypeDto.isAssigned());
        if (activityTypeDto.isGroup()) {
            for (String groupName : activityTypeDto.getAssignments()) {
                UserGroup group = cachedGroups.get(groupName);
                if (group == null) {
                    group = (UserGroup)userGroupFinder.findOneByProperty("name", (Object)groupName, new String[0]);
                    if (group == null) continue;
                    cachedGroups.put(group.getName(), group);
                }
                activity.addGroup(group);
            }
        } else {
            for (String username : activityTypeDto.getAssignments()) {
                User user = cachedUsers.get(username);
                if (user == null) {
                    user = userService.getUser(username, new String[0]);
                    if (user == null) continue;
                    cachedUsers.put(user.getUserName(), user);
                }
                activity.addUser(user);
            }
        }
        return activity;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDelegationUser() {
        return this.delegationUser;
    }

    public String getViewUser() {
        return this.viewUser;
    }

    public String getReportUser() {
        return this.reportUser;
    }

    public String getNotificationUser() {
        return this.notificationUser;
    }

    public String getOtherAcitivitiesUser() {
        return this.otherAcitivitiesUser;
    }

    public String getFavouriteSetsUser() {
        return this.favouriteSetsUser;
    }

    public Boolean getSkipSubstitutions() {
        return this.skipSubstitutions;
    }

    public Boolean getSkipNotifications() {
        return this.skipNotifications;
    }

    public Boolean getPerformConcurrently() {
        return this.performConcurrently;
    }

    public List<ExtraTransferDto> getExtraTransfers() {
        return this.extraTransfers;
    }

    public List<ProcessTypeDto> getProcesses() {
        return this.processes;
    }

    public Boolean getRunInBackground() {
        return this.runInBackground;
    }

    public Boolean getRunInScheduledTask() {
        return this.runInScheduledTask;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setDelegationUser(String delegationUser) {
        this.delegationUser = delegationUser;
    }

    public void setViewUser(String viewUser) {
        this.viewUser = viewUser;
    }

    public void setReportUser(String reportUser) {
        this.reportUser = reportUser;
    }

    public void setNotificationUser(String notificationUser) {
        this.notificationUser = notificationUser;
    }

    public void setOtherAcitivitiesUser(String otherAcitivitiesUser) {
        this.otherAcitivitiesUser = otherAcitivitiesUser;
    }

    public void setFavouriteSetsUser(String favouriteSetsUser) {
        this.favouriteSetsUser = favouriteSetsUser;
    }

    public void setSkipSubstitutions(Boolean skipSubstitutions) {
        this.skipSubstitutions = skipSubstitutions;
    }

    public void setSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
    }

    public void setPerformConcurrently(Boolean performConcurrently) {
        this.performConcurrently = performConcurrently;
    }

    public void setExtraTransfers(List<ExtraTransferDto> extraTransfers) {
        this.extraTransfers = extraTransfers;
    }

    public void setProcesses(List<ProcessTypeDto> processes) {
        this.processes = processes;
    }

    public void setRunInBackground(Boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    public void setRunInScheduledTask(Boolean runInScheduledTask) {
        this.runInScheduledTask = runInScheduledTask;
    }
}

