/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive.search;

import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.web.dto.archive.search.IndexComboValueModel;
import com.suncode.pwfl.web.dto.archive.search.IndexValueModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public final class IndexModelDto {
    private final String id;
    private final String name;
    private final String translatedName;
    private final IndexValueModel value;

    public static IndexModelDto fromDocumentClassIndexEntity(DocumentClassIndex documentClassIndex) {
        IndexComboValueModel[] comboValues = StringUtils.isNotBlank((String)documentClassIndex.getValues()) ? (IndexComboValueModel[])Arrays.stream(documentClassIndex.getValues().split("\\n")).map(value -> new IndexComboValueModel((String)value, (String)value)).toArray(IndexComboValueModel[]::new) : new IndexComboValueModel[]{};
        IndexType indexType = documentClassIndex.getType();
        IndexValueModel build = IndexValueModel.builder().comboValues(comboValues).type(documentClassIndex.getType().toString().toUpperCase()).isRangeActive(indexType == IndexType.DOUBLE || indexType == IndexType.LONG || indexType == IndexType.DATE || indexType == IndexType.DATETIME).build();
        return IndexModelDto.builder().id(documentClassIndex.getId().toString()).name(documentClassIndex.getName()).translatedName(documentClassIndex.getTranslatedName()).value(build).build();
    }

    public static IndexModelDto fromDocumentLinkIndexEntity(LinkIndex linkIndex) {
        IndexComboValueModel[] comboValues = StringUtils.isNotBlank((String)linkIndex.getValues()) ? (IndexComboValueModel[])Arrays.stream(linkIndex.getValues().split("\\n")).map(value -> new IndexComboValueModel((String)value, (String)value)).toArray(IndexComboValueModel[]::new) : new IndexComboValueModel[]{};
        String indexType = linkIndex.getType();
        IndexValueModel build = IndexValueModel.builder().comboValues(comboValues).type(linkIndex.getType().toUpperCase()).isRangeActive(indexType.equalsIgnoreCase(IndexType.DOUBLE.toString()) || indexType.equalsIgnoreCase(IndexType.LONG.toString()) || indexType.equalsIgnoreCase(IndexType.DATE.toString()) || indexType.equalsIgnoreCase(IndexType.DATETIME.toString())).build();
        return IndexModelDto.builder().id(linkIndex.getId().toString()).name(linkIndex.getName()).translatedName(linkIndex.getTranslatedName()).value(build).build();
    }

    @ConstructorProperties(value={"id", "name", "translatedName", "value"})
    IndexModelDto(String id, String name, String translatedName, IndexValueModel value) {
        this.id = id;
        this.name = name;
        this.translatedName = translatedName;
        this.value = value;
    }

    public static IndexModelDtoBuilder builder() {
        return new IndexModelDtoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public IndexValueModel getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexModelDto)) {
            return false;
        }
        IndexModelDto other = (IndexModelDto)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$translatedName = this.getTranslatedName();
        String other$translatedName = other.getTranslatedName();
        if (this$translatedName == null ? other$translatedName != null : !this$translatedName.equals(other$translatedName)) {
            return false;
        }
        IndexValueModel this$value = this.getValue();
        IndexValueModel other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $translatedName = this.getTranslatedName();
        result = result * 59 + ($translatedName == null ? 43 : $translatedName.hashCode());
        IndexValueModel $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public String toString() {
        return "IndexModelDto(id=" + this.getId() + ", name=" + this.getName() + ", translatedName=" + this.getTranslatedName() + ", value=" + this.getValue() + ")";
    }

    public static class IndexModelDtoBuilder {
        private String id;
        private String name;
        private String translatedName;
        private IndexValueModel value;

        IndexModelDtoBuilder() {
        }

        public IndexModelDtoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public IndexModelDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public IndexModelDtoBuilder translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public IndexModelDtoBuilder value(IndexValueModel value) {
            this.value = value;
            return this;
        }

        public IndexModelDto build() {
            return new IndexModelDto(this.id, this.name, this.translatedName, this.value);
        }

        public String toString() {
            return "IndexModelDto.IndexModelDtoBuilder(id=" + this.id + ", name=" + this.name + ", translatedName=" + this.translatedName + ", value=" + this.value + ")";
        }
    }
}

