/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.AdvanceSearchResult;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.InMemoryCacheConfig;
import com.suncode.pwfl.distinction.DistinctionMapper;
import com.suncode.pwfl.distinction.dto.DistinctionBase64;
import com.suncode.pwfl.distinction.dto.DistinctionDto;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.stream.StreamExportColumn;
import com.suncode.pwfl.export.model.stream.StreamExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.AdvanceProcessSearchDBHelper;
import com.suncode.pwfl.search.AdvanceProcessSearchHelper;
import com.suncode.pwfl.search.AdvanceProcessSearchService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SearchFormModelBuilder;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.ViewVariablesToSearchModelMapper;
import com.suncode.pwfl.search.results.AdvanceProcessSearchResultConverter;
import com.suncode.pwfl.search.results.AdvanceProcessSearchResults;
import com.suncode.pwfl.search.results.AdvanceProcessSearchResultsRow;
import com.suncode.pwfl.util.Exceptions;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.view.exception.NoPermissionToProcessException;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import com.suncode.pwfl.web.controller.api.workflow.search.AdvanceProcessSearchGroupOperationsHelper;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.SearchResultMeta;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.SearchResultMetaCache;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.exception.SearchCriteriaNotCachedException;
import com.suncode.pwfl.web.dto.workflow.search.AdvanceSearchResultColumnDto;
import com.suncode.pwfl.web.dto.workflow.search.AdvanceSearchResultContext;
import com.suncode.pwfl.web.dto.workflow.search.ExportDtoToSearchResultsRowMapper;
import com.suncode.pwfl.web.dto.workflow.search.ExtrasSearchModelToExtrasMapper;
import com.suncode.pwfl.web.dto.workflow.search.GroupAcceptanceButtons;
import com.suncode.pwfl.web.dto.workflow.search.GroupAcceptanceContextDto;
import com.suncode.pwfl.web.dto.workflow.search.SearchModelToColumnMapper;
import com.suncode.pwfl.web.dto.workflow.search.SearchResultsRowExportDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.ajax.ResponseMessageLevel;
import com.suncode.pwfl.web.support.ajax.RestResponse;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.distinction.DistinctionUtil;
import com.suncode.pwfl.web.support.form.cache.MissingSearchCriteriaException;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.support.form.cache.SearchFormCachedItem;
import com.suncode.pwfl.web.support.form.cache.SearchResultActions;
import com.suncode.pwfl.web.ui.section.SectionHolder;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityCache;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityProvider;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheKeyId;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheSourceType;
import com.suncode.pwfl.workflow.activity.sequential.cache.view.SequentialActivityViewMapper;
import com.suncode.pwfl.workflow.activity.sequential.cache.view.SequentialCacheKeyViewId;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.search.ActivitySearchQuery;
import com.suncode.pwfl.workflow.search.ProcessSearchQuery;
import com.suncode.pwfl.workflow.search.SearchQuery;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.naming.NoPermissionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"search/advance"})
public class AdvanceProcessSearchController {
    private static final Logger log = LoggerFactory.getLogger(AdvanceProcessSearchController.class);
    @Autowired
    private SearchFormCache searchFormCache;
    @Autowired
    private SearchModelToColumnMapper searchModelToColumnMapper;
    @Autowired
    private AdvanceProcessSearchService advanceProcessSearchService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private AdvanceProcessSearchHelper advanceProcessSearchHelper;
    @Autowired
    private SequentialActivityCache sequentialActivityCache;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private WebFragmentsManager webFragmentsManager;
    @Autowired
    private SectionHolder sectionHolder;
    @Autowired
    private AdvanceProcessSearchResultConverter advanceProcessSearchResultConverter;
    @Autowired
    private SearchResultMetaCache searchResultMetaCache;
    @Autowired
    private AdvanceProcessSearchGroupOperationsHelper advanceProcessSearchGroupOperationsHelper;
    @Autowired
    private ExtrasSearchModelToExtrasMapper extrasSearchModelToExtrasMapper;
    @Autowired
    private ExportDtoToSearchResultsRowMapper exportDtoToSearchResultsRowMapper;
    @Autowired
    private SequentialActivityViewMapper sequentialActivityViewMapper;
    @Autowired
    private DistinctionMapper distinctionMapper;
    @Autowired
    private SearchFormModelBuilder searchFormBuilder;
    @Autowired
    private AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper;
    @Autowired
    private ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper;
    @Autowired
    private Experimental experimental;
    @Autowired
    private CacheFactory cacheFactory;
    private Map<UUID, List<AdvanceProcessSearchResultsRow>> exportCache = new HashMap<UUID, List<AdvanceProcessSearchResultsRow>>();
    private PlusWorkflowCache<PrefetchingPageKey, CountedResult<AdvanceSearchResult>> prefetchingCache;

    @PostConstruct
    private void initCache() {
        InMemoryCacheConfig cacheConfig = InMemoryCacheConfig.builder().expireAfterWrite(Duration.ofMinutes(5L)).expireAfterRead(Duration.ofSeconds(10L)).build();
        this.prefetchingCache = this.cacheFactory.createInMemoryCache(SystemCacheId.SEARCH_PREFETCHING_CACHE, cacheConfig);
    }

    @ResponseBody
    @RequestMapping(value={"{searchId}/context"}, method={RequestMethod.GET})
    public AdvanceSearchResultContext getAdvanceSearchResultsContext(@PathVariable String searchId, @RequestParam(required=false) Long viewId) throws MissingSearchCriteriaException {
        SearchFormModelDto searchForm = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        SearchResultActions searchResultActions = this.searchFormCache.getSearchResultActionsFromCache(searchId);
        String userName = SessionUtils.getLoggedUserName();
        List<AdvanceSearchResultColumnDto> advanceSearchResultColumnDto = this.searchModelToColumnMapper.map(searchForm);
        GroupAcceptanceContextDto groupAcceptanceContextDto = searchResultActions.groupAcceptance() ? this.advanceProcessSearchGroupOperationsHelper.getGroupAcceptanceContextDto(searchForm, viewId, searchResultActions.groupAcceptance()) : new GroupAcceptanceContextDto(false, null);
        return AdvanceSearchResultContext.builder().advanceSearchResultColumns(advanceSearchResultColumnDto).advanceProcessSearchExtras(this.extrasSearchModelToExtrasMapper.map(searchForm.getExtrasSearchModel())).isActivitySearch(this.advanceProcessSearchHelper.isActivitySearch(searchForm)).isAdminMode(this.advanceProcessSearchHelper.canExecuteAdminActionsOnResults(searchForm, userName)).isCaptchaConfirmation(SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.ADDITIONAL_CAPTCHA_CONFIRMATION)).showSearchResultOnResult(this.advanceProcessSearchHelper.getShowSearchResultOnResult(viewId)).groupAcceptanceContext(groupAcceptanceContextDto).showOnlyLatestActivityDetails(searchResultActions.showOnlyLatestActivityDetails()).build();
    }

    @ResponseBody
    @RequestMapping(value={"{searchId}/context/groupAcceptance/processDefinitionId/{processDefinitionId}/activityDefinitionId/{activityDefinitionId}"}, method={RequestMethod.GET})
    public GroupAcceptanceButtons getAdvanceSearchResultsGroupAcceptanceButtons(@PathVariable String searchId, @PathVariable String processDefinitionId, @PathVariable String activityDefinitionId) {
        SearchFormModelDto searchFormModel = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        return this.advanceProcessSearchGroupOperationsHelper.getGroupAcceptanceButtons(processDefinitionId, activityDefinitionId, searchFormModel.getActivityDetailsSearchModel().getName());
    }

    @ResponseBody
    @RequestMapping(value={"{searchId}"}, method={RequestMethod.GET})
    public AdvanceProcessSearchResults getAdvanceSearchResult(HttpServletRequest request, @PathVariable String searchId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false, defaultValue="false") boolean appendWizards) throws IOException {
        String userName = SessionUtils.getLoggedUserName();
        SearchFormModelDto searchFormModel = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        boolean isActivitySearch = this.advanceProcessSearchHelper.isActivitySearch(searchFormModel);
        this.invalidateOnSortingChange(searchId, sortBy, sortDirection);
        int page = start / limit;
        PrefetchingPageKey prefetchingPageKey = new PrefetchingPageKey(searchId, page, sortBy, sortDirection);
        CountedResult<AdvanceSearchResult> searchResults = (CountedResult<AdvanceSearchResult>)this.prefetchingCache.getIfPresent((Object)prefetchingPageKey);
        if (searchResults == null) {
            CountedResult extendedSearchResults = this.advanceProcessSearchService.search(searchFormModel, userName, start, Integer.valueOf(limit * 4), sortBy, sortDirection, false);
            searchResults = this.getResultsFromCache(searchId, start, limit, sortBy, sortDirection, (CountedResult<AdvanceSearchResult>)extendedSearchResults);
        }
        if (searchResults == null) {
            AdvanceProcessSearchResults advanceProcessSearchResults = new AdvanceProcessSearchResults();
            advanceProcessSearchResults.setData(Collections.emptyList());
            advanceProcessSearchResults.setTotal(0L);
            return advanceProcessSearchResults;
        }
        try {
            List distinctions = this.searchFormCache.getDistinctionsFromCache(searchId).stream().map(arg_0 -> ((DistinctionMapper)this.distinctionMapper).toDistinctionDto(arg_0)).collect(Collectors.toList());
            DistinctionUtil.distinguishValues((List)searchResults.getData(), distinctions);
        }
        catch (Exception e) {
            log.error("B\u0142\u0105d podczas wyr\u00f3\u017cniania warto\u015bci", (Throwable)e);
        }
        AdvanceProcessSearchResults searchResultsDto = this.advanceProcessSearchResultConverter.convert((CountedResult)searchResults);
        this.sequentialActivityCache.invalidate(request.getSession(false).getId());
        if (appendWizards) {
            AdvanceVariableForm[] searchVariables = this.searchFormCache.getSearchVariablesFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
            int resultCount = (int)searchResults.getTotal();
            List<MenuItem> menuItems = this.generateMenu(userName, null, searchVariables, resultCount, isActivitySearch, searchId, sortBy, sortDirection);
            searchResultsDto.setMenuItems(menuItems);
        }
        return searchResultsDto;
    }

    private void invalidateOnSortingChange(String searchId, String sortBy, SortDirection sortDirection) {
        this.prefetchingCache.asMap().keySet().stream().filter(pageKey -> pageKey.getSearchId().equals(searchId) && (ObjectUtils.notEqual((Object)pageKey.getSortBy(), (Object)sortBy) || ObjectUtils.notEqual((Object)pageKey.getSortDirection(), (Object)sortDirection))).forEach(arg_0 -> this.prefetchingCache.invalidate(arg_0));
    }

    @ResponseBody
    @RequestMapping(value={"{searchId}/view/{viewId}"})
    public AdvanceProcessSearchResults getAdvanceSearchResultFromView(HttpServletRequest request, @PathVariable String searchId, @PathVariable Long viewId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false, defaultValue="false") boolean appendWizards) throws NoPermissionToProcessException, NoPermissionException, ViewDoesNotExistException, IOException {
        String userName = SessionUtils.getLoggedUserName();
        SearchFormModelDto searchFormModel = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        this.invalidateOnSortingChange(searchId, sortBy, sortDirection);
        int page = start / limit;
        PrefetchingPageKey prefetchingPageKey = new PrefetchingPageKey(searchId, page, sortBy, sortDirection);
        CountedResult<AdvanceSearchResult> searchResults = (CountedResult<AdvanceSearchResult>)this.prefetchingCache.getIfPresent((Object)prefetchingPageKey);
        if (searchResults == null) {
            CountedResult extendedSearchResults = this.advanceProcessSearchService.searchView(searchFormModel, viewId, userName, start, Integer.valueOf(limit * 4), sortBy, sortDirection, false);
            searchResults = this.getResultsFromCache(searchId, start, limit, sortBy, sortDirection, (CountedResult<AdvanceSearchResult>)extendedSearchResults);
        }
        AdvanceProcessSearchResults searchResultDto = new AdvanceProcessSearchResults();
        if (searchResults == null) {
            searchResultDto.setData(Collections.emptyList());
            searchResultDto.setTotal(0L);
            return searchResultDto;
        }
        try {
            List<DistinctionDto> distinctions = this.getDistinctionsFromSearchIdOrView(searchId, viewId);
            DistinctionUtil.distinguishValues((List)searchResults.getData(), distinctions);
        }
        catch (Exception e) {
            log.error("B\u0142\u0105d podczas wyr\u00f3\u017cniania warto\u015bci", (Throwable)e);
        }
        searchResultDto = this.advanceProcessSearchResultConverter.convert((CountedResult)searchResults);
        if (!searchResultDto.getData().isEmpty()) {
            SequentialCacheKeyViewId sequentialCacheKeyViewId = new SequentialCacheKeyViewId(request.getSession(false).getId(), Long.valueOf(Long.parseLong(viewId.toString())));
            SequentialActivityProvider sequentialActivityProvider = (begin, end) -> this.sequentialActivityViewMapper.map((List)Exceptions.sneakyThrows(() -> this.advanceProcessSearchService.searchView(searchFormModel, viewId, userName, begin, end, sortBy, sortDirection, false).getData()));
            this.sequentialActivityCache.cacheResults((SequentialCacheKeyId)sequentialCacheKeyViewId, SequentialCacheSourceType.VIEW, sequentialActivityProvider, start.intValue(), limit.intValue(), this.sequentialActivityViewMapper.map(searchResults.getData()));
        }
        if (appendWizards) {
            AdvanceVariableForm[] searchVariables = this.searchFormCache.getSearchVariablesFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
            int resultCount = (int)searchResults.getTotal();
            boolean shouldSearchActivities = this.advanceProcessSearchHelper.isActivitySearch(searchFormModel);
            List<MenuItem> menuItems = this.generateMenu(userName, String.valueOf(viewId), searchVariables, resultCount, shouldSearchActivities, searchId, sortBy, sortDirection);
            searchResultDto.setMenuItems(menuItems);
        }
        return searchResultDto;
    }

    private CountedResult<AdvanceSearchResult> getResultsFromCache(String searchId, Integer start, Integer limit, String sortBy, SortDirection sortDirection, CountedResult<AdvanceSearchResult> extendedSearchResults) {
        List data = extendedSearchResults.getData();
        CountedResult searchResults = null;
        if (extendedSearchResults.getTotal() == 0L) {
            return new CountedResult(0L, new ArrayList());
        }
        int resultListStart = 0;
        for (int i = start.intValue(); i < start + data.size(); i += limit.intValue()) {
            int sublistEndRange;
            int n = sublistEndRange = resultListStart + limit > data.size() ? data.size() : resultListStart + limit;
            if (i == start) {
                searchResults = new CountedResult(extendedSearchResults.getTotal(), data.subList(resultListStart, sublistEndRange));
            } else {
                PrefetchingPageKey pageKey = new PrefetchingPageKey(searchId, i / limit, sortBy, sortDirection);
                this.prefetchingCache.put((Object)pageKey, (Object)new CountedResult(extendedSearchResults.getTotal(), data.subList(resultListStart, sublistEndRange)));
            }
            resultListStart += limit.intValue();
        }
        return searchResults;
    }

    private List<DistinctionDto> getDistinctionsFromSearchIdOrView(String searchId, long viewId) throws JsonProcessingException {
        List distinctions = this.searchFormCache.getDistinctionsFromCache(searchId).stream().map(arg_0 -> ((DistinctionMapper)this.distinctionMapper).toDistinctionDto(arg_0)).collect(Collectors.toList());
        return distinctions.isEmpty() ? DistinctionUtil.getDistinctions((String)String.valueOf(viewId)) : distinctions;
    }

    private List<MenuItem> generateMenu(String user, String viewId, AdvanceVariableForm[] form, int count, boolean activitiesSearch, String searchId, String externalSortProperty, SortDirection externalSortDirection) {
        ActivitySearchQuery query = activitiesSearch ? new ActivitySearchQuery(user, form, externalSortProperty, externalSortDirection) : new ProcessSearchQuery(user, form, externalSortProperty, externalSortDirection);
        SearchResultActionSection.SearchType type = activitiesSearch ? SearchResultActionSection.SearchType.ACTIVITY : SearchResultActionSection.SearchType.PROCESS;
        SearchResultActionSection section = new SearchResultActionSection(viewId, type, (SearchQuery)query, count);
        this.sectionHolder.save((Section)section, searchId);
        this.sectionHolder.save((Section)section);
        return this.webFragmentsManager.getMenu("system.search.result.menu").applyConditions((Section)section).getItems();
    }

    @ResponseBody
    @RequestMapping(value={"{searchId}"}, method={RequestMethod.PUT})
    public RestResult updateSearchCriteria(HttpServletRequest request, @PathVariable String searchId, @RequestBody SearchFormCachedItem searchFormCachedItem) throws MissingSearchCriteriaException {
        SearchFormCachedItem previousSearchFormCachedItem = this.searchFormCache.getValueFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        this.searchFormCache.cacheSearchForm(request.getSession(false), searchId, new SearchFormCachedItem(searchFormCachedItem.encodedSearchForm(), searchFormCachedItem.distinctions(), previousSearchFormCachedItem.searchResultActions()));
        this.sequentialActivityCache.invalidate(request.getSession(false).getId());
        return new RestResult(true);
    }

    @RequestMapping(value={"{searchId}/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI export(HttpServletRequest request, @RequestBody List<SearchResultsRowExportDto> searchResults, @PathVariable String searchId, @PathVariable String extension) {
        return this.getRedirectUri(request, searchResults);
    }

    @RequestMapping(value={"{searchId}/export/{extension}"})
    @ResponseBody
    public void export(HttpServletResponse response, @PathVariable String searchId, @PathVariable String extension, @RequestParam(required=false) boolean arrayResultsInOneRow, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException {
        Stream<AdvanceProcessSearchResultsRow> searchResultsDtoStream;
        String userName = SessionUtils.getLoggedUserName();
        SearchFormModelDto searchFormModel = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        List<AdvanceSearchResultColumnDto> searchResultsColumns = this.searchModelToColumnMapper.map(searchFormModel);
        if (id == null) {
            Stream searchResults = this.advanceProcessSearchService.streamSearch(searchFormModel, userName, Integer.valueOf(0), Integer.valueOf(SpreadsheetVersion.EXCEL2007.getMaxRows() - 1), sortBy, sortDirection, true, arrayResultsInOneRow);
            searchResultsDtoStream = this.advanceProcessSearchResultConverter.convert(searchResults);
        } else {
            List<AdvanceProcessSearchResultsRow> cachedResults = this.getCachedResults(null, id, searchResultsColumns);
            searchResultsDtoStream = cachedResults.stream();
            if (!arrayResultsInOneRow) {
                Stream searchResultsStream = this.advanceProcessSearchService.streamSearch(searchFormModel, userName, Integer.valueOf(0), Integer.valueOf(SpreadsheetVersion.EXCEL2007.getMaxRows() - 1), sortBy, sortDirection, true, arrayResultsInOneRow);
                Stream allSearchResultsStream = this.advanceProcessSearchResultConverter.convert(searchResultsStream);
                searchResultsDtoStream = allSearchResultsStream.filter(searchResult -> cachedResults.stream().anyMatch(cachedResult -> this.isSearchResultInCachedResults((AdvanceProcessSearchResultsRow)cachedResult, (AdvanceProcessSearchResultsRow)searchResult)));
            }
        }
        this.doExport(response, extension, searchResultsColumns, searchResultsDtoStream, this.messageHelper.getMessage("Wyniki_wyszukiwania"));
    }

    @RequestMapping(value={"{searchId}/view/{viewId}/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportFromView(HttpServletRequest request, @RequestBody List<SearchResultsRowExportDto> searchResults, @PathVariable String searchId, @PathVariable Long viewId, @PathVariable String extension) {
        return this.getRedirectUri(request, searchResults);
    }

    @RequestMapping(value={"{searchId}/view/{viewId}/export/{extension}"})
    @ResponseBody
    public void exportFromView(HttpServletResponse response, @PathVariable String searchId, @PathVariable Long viewId, @PathVariable String extension, @RequestParam(required=false) boolean arrayResultsInOneRow, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException, NoPermissionToProcessException, NoPermissionException, ViewDoesNotExistException {
        Stream<AdvanceProcessSearchResultsRow> searchResultsDtoStream;
        String userName = SessionUtils.getLoggedUserName();
        SearchFormModelDto searchFormModel = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        List<AdvanceSearchResultColumnDto> searchResultsColumns = this.searchModelToColumnMapper.map(searchFormModel);
        if (id == null) {
            Stream searchResultsStream = this.advanceProcessSearchService.streamSearchView(searchFormModel, viewId, userName, Integer.valueOf(0), Integer.valueOf(SpreadsheetVersion.EXCEL2007.getMaxRows() - 1), sortBy, sortDirection, true, arrayResultsInOneRow);
            Stream convertedSearchResultStream = this.advanceProcessSearchResultConverter.convert(searchResultsStream);
            searchResultsDtoStream = this.exportDtoToSearchResultsRowMapper.getExportResultsWithSanitizedVariables(viewId, convertedSearchResultStream, searchResultsColumns);
        } else {
            List<AdvanceProcessSearchResultsRow> cachedResults = this.getCachedResults(viewId, id, searchResultsColumns);
            searchResultsDtoStream = cachedResults.stream();
            if (!arrayResultsInOneRow) {
                Stream searchResultsStream = this.advanceProcessSearchService.streamSearchView(searchFormModel, viewId, userName, Integer.valueOf(0), Integer.valueOf(SpreadsheetVersion.EXCEL2007.getMaxRows() - 1), sortBy, sortDirection, true, false);
                Stream convertedSearchResultStream = this.advanceProcessSearchResultConverter.convert(searchResultsStream);
                Stream<AdvanceProcessSearchResultsRow> sanitizedSearchResultsStream = this.exportDtoToSearchResultsRowMapper.getExportResultsWithSanitizedVariables(viewId, convertedSearchResultStream, searchResultsColumns);
                searchResultsDtoStream = sanitizedSearchResultsStream.filter(searchResult -> cachedResults.stream().anyMatch(cachedResult -> this.isSearchResultInCachedResults((AdvanceProcessSearchResultsRow)cachedResult, (AdvanceProcessSearchResultsRow)searchResult)));
            }
        }
        ViewDto view = this.viewService.getView(viewId);
        String exportTitle = String.format("%s: %s", this.messageHelper.getMessage("Nazwa_widoku"), view.getTranslatedName());
        this.doExport(response, extension, searchResultsColumns, searchResultsDtoStream, exportTitle);
    }

    @RequestMapping(value={"/view/{viewId}/export/{extension}"})
    @ResponseBody
    public void exportFromView(HttpServletResponse response, @PathVariable Long viewId, @PathVariable String extension, @RequestParam(required=false) boolean arrayResultsInOneRow, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException, NoPermissionToProcessException, NoPermissionException, ViewDoesNotExistException {
        String userName = SessionUtils.getLoggedUserName();
        SearchFormModelDto searchFormModel = this.getSearchFormModel(viewId);
        List<AdvanceSearchResultColumnDto> searchResultsColumns = this.searchModelToColumnMapper.map(searchFormModel);
        Stream searchResultsStream = this.advanceProcessSearchService.streamSearchView(searchFormModel, viewId, userName, Integer.valueOf(0), Integer.valueOf(SpreadsheetVersion.EXCEL2007.getMaxRows() - 1), sortBy, sortDirection, true, arrayResultsInOneRow);
        Stream convertedSearchResultStream = this.advanceProcessSearchResultConverter.convert(searchResultsStream);
        Stream<AdvanceProcessSearchResultsRow> searchResultsDtoStream = this.exportDtoToSearchResultsRowMapper.getExportResultsWithSanitizedVariables(viewId, convertedSearchResultStream, searchResultsColumns);
        ViewDto view = this.viewService.getView(viewId);
        String exportTitle = String.format("%s: %s", this.messageHelper.getMessage("Nazwa_widoku"), view.getTranslatedName());
        this.doExport(response, extension, searchResultsColumns, searchResultsDtoStream, exportTitle);
    }

    private SearchFormModelDto getSearchFormModel(long viewId) throws ViewDoesNotExistException, JsonProcessingException {
        ViewDto userSearchView = this.viewService.getUserSearchView(String.valueOf(viewId));
        String viewSearchFormModel = userSearchView.getSearchFormModel();
        if (viewSearchFormModel != null) {
            return this.searchFormBuilder.buildSearchFormModelWithTypeInfo(viewSearchFormModel);
        }
        List searchVariablesForView = this.advanceProcessSearchDBHelper.getSearchVariablesForView(Long.valueOf(viewId));
        return this.viewVariablesToSearchModelMapper.map(searchVariablesForView);
    }

    private void doExport(HttpServletResponse response, String extension, List<AdvanceSearchResultColumnDto> searchResultsColumns, Stream<AdvanceProcessSearchResultsRow> searchResults, String exportTitle) throws IOException {
        ArrayList columns = new ArrayList();
        searchResultsColumns.stream().filter(column -> !column.getId().equals("documentExtraColumn")).forEach(column -> {
            StreamExportColumn exportColumn = StreamExportColumn.builder().name(column.getColumnHeader()).type(column.getVariableType()).valueMapper(row -> row.getValues().stream().filter(value -> value.getColumnId().equals(column.getId())).findFirst().get().getValue()).build();
            columns.add(exportColumn);
        });
        StreamExportModel model = StreamExportModel.builder().title(exportTitle).columns(columns).dataStream(searchResults).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        boolean checkTextAsNumber = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CHECK_TEXT_AS_NUMBER_IN_ADVANCE_SEARCH_EXPORT);
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream(), checkTextAsNumber);
    }

    private URI getRedirectUri(HttpServletRequest request, List<SearchResultsRowExportDto> searchResultsExportDto) {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        List searchResults = searchResultsExportDto.stream().map(searchResult -> this.exportDtoToSearchResultsRowMapper.map((SearchResultsRowExportDto)searchResult)).collect(Collectors.toList());
        this.exportCache.put(id, searchResults);
        String fullRequestUri = request.getQueryString() != null ? String.format("%s?%s&id=%s", request.getRequestURI(), request.getQueryString(), id) : String.format("%s?id=%s", request.getRequestURI(), id);
        return URI.create(fullRequestUri);
    }

    private List<AdvanceProcessSearchResultsRow> getCachedResults(Long viewId, UUID id, List<AdvanceSearchResultColumnDto> columns) {
        List<AdvanceProcessSearchResultsRow> resultsToExport = this.exportCache.get(id);
        this.exportCache.remove(id);
        return this.exportDtoToSearchResultsRowMapper.getExportResultsWithSanitizedVariables(viewId, resultsToExport, columns);
    }

    @RequestMapping(value={"/cache/{searchId}"}, method={RequestMethod.POST})
    @ResponseBody
    public long cacheFoundProcesses(@PathVariable String searchId) {
        SearchFormModelDto searchFormModel = this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelper.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        String userName = SessionUtils.getLoggedUserName();
        int limit = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_MAX_RESULT_WINDOW).intValue();
        CountedResult searchResults = this.advanceProcessSearchService.search(searchFormModel, userName, Integer.valueOf(0), Integer.valueOf(limit), "processId", SortDirection.ASC, false);
        long count = searchResults.getTotal();
        AdvanceProcessSearchResults searchResultsDto = this.advanceProcessSearchResultConverter.convert(searchResults);
        this.searchResultMetaCache.cache(searchId, searchResultsDto.getData().stream().map(row -> new SearchResultMeta(row.getProcessId(), row.getActivityId())).collect(Collectors.toSet()));
        return count;
    }

    @RequestMapping(value={"processes/abort/{searchId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse abortAllFoundProcesses(@PathVariable String searchId, @RequestParam(required=false) Long viewId) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ABORT_PROCESSES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        Map<String, Object> auditParams = this.buildProcessesOperationAuditParams(viewId, null, operationSource);
        try {
            Set<String> cachedProcesses = this.searchResultMetaCache.getCachedProcesses(searchId);
            auditParams.put("amount", cachedProcesses.size());
            long abortedProcessesCount = this.advanceProcessSearchGroupOperationsHelper.abortProcesses(cachedProcesses, userName, operationSource);
            String message = this.buildBulkOperationMessage(cachedProcesses.size(), abortedProcessesCount, "Liczba_anulowanych_procesow", "Nie_mozna_anulowac");
            auditBuilder.params(auditParams).success(true).build().log();
            this.searchResultMetaCache.removeFromCache(searchId);
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.params(auditParams).success(false).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"processes/abort/selected"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse abortSelectedProcesses(@RequestParam(required=false) Long viewId, @RequestBody List<String> processes) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ABORT_PROCESSES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        auditBuilder.params(this.buildProcessesOperationAuditParams(viewId, Long.valueOf(processes.size()), operationSource));
        try {
            long abortedProcessesCount = this.advanceProcessSearchGroupOperationsHelper.abortProcesses(new HashSet<String>(processes), userName, operationSource);
            String message = this.buildBulkOperationMessage(processes.size(), abortedProcessesCount, "Liczba_anulowanych_procesow", "Nie_mozna_anulowac");
            auditBuilder.success(true).build().log();
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.success(false).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"processes/delete/{searchId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse deleteAllFoundProcesses(@PathVariable String searchId, @RequestParam(required=false) Long viewId) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESSES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        Map<String, Object> auditParams = this.buildProcessesOperationAuditParams(viewId, null, operationSource);
        try {
            Set<String> cachedProcesses = this.searchResultMetaCache.getCachedProcesses(searchId);
            auditParams.put("amount", cachedProcesses.size());
            long deletedProcessesCount = this.advanceProcessSearchGroupOperationsHelper.deleteProcesses(cachedProcesses, userName, operationSource);
            String message = this.buildBulkOperationMessage(cachedProcesses.size(), deletedProcessesCount, "Liczba_usunietych_procesow", "Nie_mozna_usunac");
            if (deletedProcessesCount != (long)cachedProcesses.size()) {
                auditBuilder.success(false).params(auditParams).build().log();
            } else {
                auditBuilder.success(true).params(auditParams).build().log();
            }
            this.searchResultMetaCache.removeFromCache(searchId);
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.params(auditParams).success(false).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"processes/delete/selected"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse deleteSelectedProcesses(@RequestParam(required=false) Long viewId, @RequestBody List<String> processes) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESSES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        auditBuilder.params(this.buildProcessesOperationAuditParams(viewId, Long.valueOf(processes.size()), operationSource));
        try {
            long deletedProcessesCount = this.advanceProcessSearchGroupOperationsHelper.deleteProcesses(new HashSet<String>(processes), userName, operationSource);
            String message = this.buildBulkOperationMessage(processes.size(), deletedProcessesCount, "Liczba_usunietych_procesow", "Nie_mozna_usunac");
            if (deletedProcessesCount != (long)processes.size()) {
                auditBuilder.success(false).build().log();
            } else {
                auditBuilder.success(true).build().log();
            }
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.success(false).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"activities/suspend/{searchId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse suspendAllFoundActivities(@PathVariable String searchId, @RequestParam(required=false) Long viewId) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_SUSPEND_ACTIVITIES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        Map<String, Object> auditParams = this.buildProcessesOperationAuditParams(viewId, null, operationSource);
        try {
            Set<SearchResultMeta> cachedSearchMetas = this.searchResultMetaCache.getCachedSearchMeta(searchId);
            auditParams.put("amount", cachedSearchMetas.size());
            long suspendedActivitiesCount = this.advanceProcessSearchGroupOperationsHelper.suspendActivities(cachedSearchMetas, userName, operationSource);
            String message = this.buildBulkOperationMessage(cachedSearchMetas.size(), suspendedActivitiesCount, "Liczba_zawieszonych_zadan", "Nie_mozna_zawiesic");
            if (suspendedActivitiesCount != (long)cachedSearchMetas.size()) {
                auditBuilder.success(false).params(auditParams).build().log();
            } else {
                auditBuilder.success(true).params(auditParams).build().log();
            }
            this.searchResultMetaCache.removeFromCache(searchId);
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.success(false).params(auditParams).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"activities/suspend/selected"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse suspendSelectedActivities(@RequestParam(required=false) Long viewId, @RequestBody List<SearchResultMeta> searchResultMetas) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_SUSPEND_ACTIVITIES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        auditBuilder.params(this.buildProcessesOperationAuditParams(viewId, Long.valueOf(searchResultMetas.size()), operationSource));
        try {
            long suspendedActivitiesCount = this.advanceProcessSearchGroupOperationsHelper.suspendActivities(new HashSet<SearchResultMeta>(searchResultMetas), userName, operationSource);
            String message = this.buildBulkOperationMessage(searchResultMetas.size(), suspendedActivitiesCount, "Liczba_zawieszonych_zadan", "Nie_mozna_zawiesic");
            if (suspendedActivitiesCount != (long)searchResultMetas.size()) {
                auditBuilder.success(false).build().log();
            } else {
                auditBuilder.success(true).build().log();
            }
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.success(false).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"activities/resume/{searchId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse resumeAllFoundActivities(@PathVariable String searchId, @RequestParam(required=false) Long viewId) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_RESUME_ACTIVITIES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        Map<String, Object> auditParams = this.buildProcessesOperationAuditParams(viewId, null, operationSource);
        try {
            Set<SearchResultMeta> cachedSearchMetas = this.searchResultMetaCache.getCachedSearchMeta(searchId);
            auditParams.put("amount", cachedSearchMetas.size());
            long resumedActivitiesCount = this.advanceProcessSearchGroupOperationsHelper.resumeActivities(cachedSearchMetas, userName, operationSource);
            String message = this.buildBulkOperationMessage(cachedSearchMetas.size(), resumedActivitiesCount, "Liczba_przywroconych_zadan", "Nie_mozna_przywrocic");
            this.searchResultMetaCache.removeFromCache(searchId);
            if (resumedActivitiesCount != (long)cachedSearchMetas.size()) {
                auditBuilder.success(false).params(auditParams).build().log();
            } else {
                auditBuilder.success(true).params(auditParams).build().log();
            }
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.success(false).params(auditParams).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"activities/resume/selected"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse resumeSelectedActivities(@RequestParam(required=false) Long viewId, @RequestBody List<SearchResultMeta> searchResultMetas) {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_RESUME_ACTIVITIES).started(new Date()).username(userName);
        String operationSource = viewId != null ? this.viewService.getView(viewId).getName() : "";
        auditBuilder.params(this.buildProcessesOperationAuditParams(viewId, Long.valueOf(searchResultMetas.size()), operationSource));
        try {
            long resumedActivitiesCount = this.advanceProcessSearchGroupOperationsHelper.resumeActivities(new HashSet<SearchResultMeta>(searchResultMetas), userName, operationSource);
            String message = this.buildBulkOperationMessage(searchResultMetas.size(), resumedActivitiesCount, "Liczba_przywroconych_zadan", "Nie_mozna_przywrocic");
            if (resumedActivitiesCount != (long)searchResultMetas.size()) {
                auditBuilder.success(false).build().log();
            } else {
                auditBuilder.success(true).build().log();
            }
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ServiceException e) {
            auditBuilder.success(false).build().log();
            throw e;
        }
    }

    @RequestMapping(value={"activities/accept/{searchId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse acceptAllFoundActivities(@PathVariable String searchId, @RequestParam(required=false) String actionName, @RequestParam(required=false) Long viewId) throws AcceptanceException {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES).started(new Date()).username(userName);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("acceptButtonActionName", actionName);
        auditParams.put("acceptFromAllPages", "TRUE");
        auditParams.put("viewId", viewId);
        try {
            ArrayList<SearchResultMeta> cachedSearchMetas = new ArrayList<SearchResultMeta>(this.searchResultMetaCache.getCachedSearchMeta(searchId));
            SearchResultMeta firstRow = (SearchResultMeta)cachedSearchMetas.get(0);
            String processActivityId = firstRow.getProcessId() + ";" + firstRow.getActivityId();
            auditParams.put("processActivityIds", processActivityId);
            long acceptedActivitiesCount = this.advanceProcessSearchGroupOperationsHelper.acceptActivities(new ArrayList<SearchResultMeta>(cachedSearchMetas), userName, actionName, true);
            auditParams.put("numberOfAcceptedTasks", acceptedActivitiesCount);
            String message = this.buildBulkOperationMessage(cachedSearchMetas.size(), acceptedActivitiesCount, "Liczba_zaakceptowanych_zadan", "Nie_mozna_zaakceptowac");
            auditBuilder.params(auditParams).success(true).build().log();
            this.searchResultMetaCache.removeFromCache(searchId);
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            auditBuilder.params(auditParams).success(false).build().log();
            throw new AcceptanceException(this.messageHelper.getMessage("Wystapil_blad_podczas_grupowej_akceptacji_zadan", new Object[]{e}));
        }
    }

    @RequestMapping(value={"activities/accept/selected"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResponse acceptSelectedFoundActivities(@RequestParam(required=false) String actionName, @RequestBody List<SearchResultMeta> searchResultMetas, @RequestParam(required=false) Long viewId) throws AcceptanceException {
        String userName = SessionUtils.getLoggedUserName();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES).started(new Date()).username(userName);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("acceptButtonActionName", actionName);
        auditParams.put("acceptFromAllPages", "FALSE");
        auditParams.put("viewId", viewId);
        try {
            SearchResultMeta firstRow = searchResultMetas.get(0);
            String processActivityId = firstRow.getProcessId() + ";" + firstRow.getActivityId();
            auditParams.put("processActivityIds", processActivityId);
            long acceptedActivitiesCount = this.advanceProcessSearchGroupOperationsHelper.acceptActivities(new ArrayList<SearchResultMeta>(searchResultMetas), userName, actionName, true);
            auditParams.put("numberOfAcceptedTasks", acceptedActivitiesCount);
            String message = this.buildBulkOperationMessage(searchResultMetas.size(), acceptedActivitiesCount, "Liczba_zaakceptowanych_zadan", "Nie_mozna_zaakceptowac");
            auditBuilder.params(auditParams).success(true).build().log();
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            auditBuilder.params(auditParams).success(false).build().log();
            throw new AcceptanceException(this.messageHelper.getMessage("Wystapil_blad_podczas_grupowej_akceptacji_zadan", new Object[]{e}));
        }
    }

    @RequestMapping(value={"/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public void audit(@RequestParam(required=false) String searchId, @RequestParam(required=false) String viewId, @RequestParam Boolean success, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") Date startDate, @RequestParam(required=false) boolean gadget) {
        ManualAuditBuilder manualAuditBuilder = ManualAuditBuilder.getInstance().username(SessionUtils.getLoggedUserNameOrUnknown()).success(success.booleanValue()).started(startDate);
        if (StringUtils.isNotBlank((CharSequence)viewId)) {
            manualAuditBuilder.type(AuditTypes.AUDIT_RUN_VIEW);
            manualAuditBuilder.params((Map)ImmutableMap.of((Object)"viewId", (Object)viewId));
        } else {
            manualAuditBuilder.type(AuditTypes.AUDIT_SEARCH_PROCESSES_OR_ACTIVITIES);
            if (success.booleanValue()) {
                SearchFormModelDto searchFormModelDto = this.searchFormCache.getSearchFormFromCache(searchId).get();
                boolean isActivitySearch = this.advanceProcessSearchHelper.isActivitySearch(searchFormModelDto);
                manualAuditBuilder.params((Map)ImmutableMap.of((Object)"isActivitySearch", (Object)isActivitySearch));
            }
        }
        if (!gadget) {
            manualAuditBuilder.build().log();
        }
    }

    @GetMapping(value={"form/cache"})
    @ResponseBody
    public SearchFormCachedItem getSearchForm(@RequestParam String searchId, HttpSession httpSession) {
        Optional<SearchFormCachedItem> searchFormCachedItem = this.searchFormCache.getValueFromCache(httpSession, searchId);
        return searchFormCachedItem.get();
    }

    @PostMapping(value={"form/cache"})
    @ResponseBody
    public SearchFormCacheResult cacheSearchForm(@RequestParam String searchId, @RequestParam boolean overrideCache, @RequestBody SearchFormCachedItem searchFormCachedItem, HttpSession httpSession) {
        try {
            if (overrideCache) {
                this.searchFormCache.cacheSearchForm(httpSession, searchId, searchFormCachedItem);
            }
            String auditStartDate = this.getFormattedDate(new Date());
            return new SearchFormCacheResult(auditStartDate, true);
        }
        catch (Exception e) {
            return new SearchFormCacheResult(this.getFormattedDate(new Date()), false);
        }
    }

    @RequestMapping(value={"{searchId}/distinctions"})
    @ResponseBody
    public List<DistinctionBase64> getCachedDistinctions(@PathVariable String searchId) {
        return this.searchFormCache.getDistinctionsFromCache(searchId);
    }

    @RequestMapping(value={"{searchId}/searchResultActions"})
    @ResponseBody
    public SearchResultActions getCachedSearchResultActions(@PathVariable String searchId) {
        return this.searchFormCache.getSearchResultActionsFromCache(searchId);
    }

    private String getFormattedDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }

    private boolean isSearchResultInCachedResults(AdvanceProcessSearchResultsRow cachedResult, AdvanceProcessSearchResultsRow searchResult) {
        return cachedResult.getProcessId().equals(searchResult.getProcessId()) && Objects.equals(cachedResult.getActivityId(), searchResult.getActivityId());
    }

    private Map<String, Object> buildProcessesOperationAuditParams(Long viewId, Long amount, String operationSource) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("operation_source", operationSource);
        auditParams.put("is_group_operation", "Tak");
        auditParams.put("viewId", ObjectUtils.defaultIfNull((Object)viewId, (Object)""));
        auditParams.put("amount", amount);
        return auditParams;
    }

    private String buildBulkOperationMessage(int total, long successful, String successPartKey, String failurePartKey) {
        long unsuccessfulCount = (long)total - successful;
        String message = this.messageHelper.getMessage(successPartKey) + ": " + successful;
        if (unsuccessfulCount > 0L) {
            message = message + " " + this.messageHelper.getMessage(failurePartKey) + ": " + unsuccessfulCount;
        }
        return message;
    }

    @ExceptionHandler(value={MissingSearchCriteriaException.class, ViewDoesNotExistException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Throwable t) {
        log.info(t.getMessage());
        return new RestResult(false, t.getMessage());
    }

    @ExceptionHandler(value={NoPermissionToProcessException.class, NoPermissionException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoPermissionToProcessException(Throwable t) {
        return new RestResult(false, t.getMessage());
    }

    @ExceptionHandler(value={SearchCriteriaNotCachedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResponse handleSearchCriteriaNotCachedException(SearchCriteriaNotCachedException e) {
        log.info(e.getMessage());
        return new RestResponse(e.getMessage(), ResponseMessageLevel.INFO);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResponse handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    @ExceptionHandler(value={AcceptanceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResponse handleAcceptanceExceptionException(AcceptanceException e) {
        log.info(e.getMessage());
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    private static final class PrefetchingPageKey {
        private final String searchId;
        private final int page;
        private final String sortBy;
        private final SortDirection sortDirection;

        @ConstructorProperties(value={"searchId", "page", "sortBy", "sortDirection"})
        public PrefetchingPageKey(String searchId, int page, String sortBy, SortDirection sortDirection) {
            this.searchId = searchId;
            this.page = page;
            this.sortBy = sortBy;
            this.sortDirection = sortDirection;
        }

        public String getSearchId() {
            return this.searchId;
        }

        public int getPage() {
            return this.page;
        }

        public String getSortBy() {
            return this.sortBy;
        }

        public SortDirection getSortDirection() {
            return this.sortDirection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrefetchingPageKey)) {
                return false;
            }
            PrefetchingPageKey other = (PrefetchingPageKey)o;
            if (this.getPage() != other.getPage()) {
                return false;
            }
            String this$searchId = this.getSearchId();
            String other$searchId = other.getSearchId();
            if (this$searchId == null ? other$searchId != null : !this$searchId.equals(other$searchId)) {
                return false;
            }
            String this$sortBy = this.getSortBy();
            String other$sortBy = other.getSortBy();
            if (this$sortBy == null ? other$sortBy != null : !this$sortBy.equals(other$sortBy)) {
                return false;
            }
            SortDirection this$sortDirection = this.getSortDirection();
            SortDirection other$sortDirection = other.getSortDirection();
            return !(this$sortDirection == null ? other$sortDirection != null : !this$sortDirection.equals(other$sortDirection));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPage();
            String $searchId = this.getSearchId();
            result = result * 59 + ($searchId == null ? 43 : $searchId.hashCode());
            String $sortBy = this.getSortBy();
            result = result * 59 + ($sortBy == null ? 43 : $sortBy.hashCode());
            SortDirection $sortDirection = this.getSortDirection();
            result = result * 59 + ($sortDirection == null ? 43 : $sortDirection.hashCode());
            return result;
        }

        public String toString() {
            return "AdvanceProcessSearchController.PrefetchingPageKey(searchId=" + this.getSearchId() + ", page=" + this.getPage() + ", sortBy=" + this.getSortBy() + ", sortDirection=" + this.getSortDirection() + ")";
        }
    }

    private record SearchFormCacheResult(String auditStartDate, boolean renderResults) {
    }
}

