/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.form.dto.history.HistoryDto;
import com.suncode.pwfl.form.service.HistoryService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processes/{processId}/history"})
@Api(tags={"processes"})
public class ProcessHistoryController {
    private static final Logger log = LoggerFactory.getLogger(ProcessHistoryController.class);
    private final HistoryService historyService;
    private final MessageHelperBean messageHelper;
    private final ExportService exportService;

    @ApiOperation(value="Downloading process history", notes="Retrieves process history for process")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping
    @ResponseBody
    public ResponseEntity<List<HistoryDto>> get(@ApiParam(value="Id of the process", required=true) @PathVariable String processId, @ApiParam(value="Rights key of the process") @RequestParam(required=false) String rightKey, @ApiParam(value="Specify whether to show system tasks", defaultValue="true") @RequestParam(required=false, defaultValue="true") boolean showSystemTasks) {
        if (SimulationUtils.isInSimulation()) {
            List historyEntries = this.historyService.getForProcess(processId, showSystemTasks);
            return new ResponseEntity((Object)historyEntries, (HttpStatusCode)HttpStatus.OK);
        }
        AuthorizationHelper authorizationHelper = (AuthorizationHelper)SpringContext.getBean(AuthorizationHelper.class);
        return authorizationHelper.ensureProcessAccess(processId, rightKey, () -> this.historyService.getForProcess(processId, showSystemTasks));
    }

    @ApiOperation(value="Exporting process history", notes="Exports process history for process with given processId")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping(value={"export/{extension}"})
    @ResponseBody
    public void exportProcessHistory(HttpServletResponse response, @ApiParam(value="Id of the process", required=true) @PathVariable String processId, @ApiParam(value="Extension", required=true) @PathVariable ExportExtension extension, @ApiParam(value="Sort by column") @RequestParam(required=false, defaultValue="startDate") String sortBy, @ApiParam(value="Direction of the sorting") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @ApiParam(value="Rights key of the process") @RequestParam(required=false) String rightKey, @ApiParam(value="Specify whether to show system tasks", defaultValue="true") @RequestParam(required=false, defaultValue="true") boolean showSystemTasks) throws IOException {
        List rawHistory;
        if (SimulationUtils.isInSimulation()) {
            rawHistory = Objects.requireNonNull(this.historyService.getForProcess(processId, showSystemTasks));
        } else {
            AuthorizationHelper authorizationHelper = (AuthorizationHelper)SpringContext.getBean(AuthorizationHelper.class);
            ResponseEntity<List> authorizedRawHistory = authorizationHelper.ensureProcessAccess(processId, rightKey, () -> this.historyService.getForProcess(processId, showSystemTasks));
            rawHistory = Objects.requireNonNull((List)authorizedRawHistory.getBody());
        }
        List<HistoryDto> history = rawHistory.stream().sorted(DtoComparator.of(HistoryDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        List<ExportColumn> columns = List.of(this.buildExportColumn(this.messageHelper.getMessage("Nazwa_zadania"), history, HistoryDto::getActivityName), this.buildExportColumn(this.messageHelper.getMessage("Data_rozpoczecia"), history, HistoryDto::getStartDate), this.buildExportColumn(this.messageHelper.getMessage("Data_zakonczenia"), history, HistoryDto::getFinishDate), this.buildExportColumn(this.messageHelper.getMessage("Wykonawca"), history, HistoryDto::getPerformer), this.buildExportColumn(this.messageHelper.getMessage("Status_zadania"), history, HistoryDto::getStatus));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Historia_procesu")).columns(columns).build();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extension.getExtension()));
        this.exportService.export(model, extension, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<HistoryDto> data, Function<HistoryDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ConstructorProperties(value={"historyService", "messageHelper", "exportService"})
    @Autowired
    public ProcessHistoryController(HistoryService historyService, MessageHelperBean messageHelper, ExportService exportService) {
        this.historyService = historyService;
        this.messageHelper = messageHelper;
        this.exportService = exportService;
    }
}

