/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.translations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.configuration.dto.translations.TranslationType;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.CustomTranslationProvider;
import com.suncode.pwfl.translation.CustomTranslationService;
import com.suncode.pwfl.translation.ImportCustomTranslationsService;
import com.suncode.pwfl.translation.ImportTranslationsResult;
import com.suncode.pwfl.translation.dto.CustomModifiedTranslationDto;
import com.suncode.pwfl.translation.dto.CustomTranslationDto;
import com.suncode.pwfl.util.exception.LocalizedServiceException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/i18n/types/custom", "/i18n/types/CUSTOM"})
@Api(tags={"translations"})
public class CustomTranslationsController {
    private static final Logger log = LoggerFactory.getLogger(CustomTranslationsController.class);
    private final AuthorizationHelper authorizationHelper;
    private final CustomTranslationProvider translationProvider;
    private final CustomTranslationService translationService;
    private final ExportService exportService;
    private final ImportCustomTranslationsService importTranslationsService;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"locales"})
    public List<String> getTypeLocales() {
        return this.translationService.getLocales();
    }

    @ResponseBody
    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"locales/{locale}/translations/custom"})
    public List<CustomTranslationDto> getModifiedTranslations(@PathVariable String locale) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.translationProvider.getCustomTranslations(Locale.forLanguageTag(locale));
    }

    @ResponseBody
    @ApiOperation(value="", hidden=true)
    @PutMapping(value={"locales/{locale}/translations/custom"})
    public void updateTranslations(@PathVariable String locale, @RequestBody List<CustomModifiedTranslationDto> modifiedTranslations) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.translationService.updateTranslations(modifiedTranslations, Locale.forLanguageTag(locale));
    }

    @ApiOperation(value="", hidden=true)
    @DeleteMapping(value={"locales/{locale}/translations/custom"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetAllTranslations(@PathVariable String locale) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.translationService.resetTranslations(Locale.forLanguageTag(locale));
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"export/excel"})
    @ResponseBody
    public void exportCustomTranslationsToExcel(HttpServletResponse response, @RequestBody List<CustomTranslationDto> translationsToExport) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List locales = this.translationService.getLocales();
        ArrayList allCustomTranslations = new ArrayList();
        for (Object locale : locales) {
            allCustomTranslations.addAll(this.translationProvider.getCustomTranslations(Locale.forLanguageTag((String)locale)));
        }
        ArrayList<ExportColumn> columns = new ArrayList<ExportColumn>(Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zrodlo")).data(translationsToExport).by(customTranslation -> "custom-messages").build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Klucz")).data(translationsToExport).by(CustomTranslationDto::getKey).build()));
        for (String locale : locales) {
            columns.add(ExportColumnBuilder.create().name(String.format("%s_%s", this.messageHelper.getMessage("Wartosc"), locale)).data(translationsToExport).by(translationToExport -> this.getTranslatedValueForLocale(allCustomTranslations, (CustomTranslationDto)translationToExport, locale)).build());
        }
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Tlumaczenia_niestandardowe")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.EXCEL;
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=export_custom-translations.%s", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="Exporting custom translations to JSON.", notes="The body contains a JSON array containing translations to export.\n- **key** - the key of the custom translation for which you want to retrieve the translated values")
    @ApiResponses(value={@ApiResponse(code=200, message="Exported translations (JSON array)"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=403, message="Unauthorized")})
    @PostMapping(value={"export/json"})
    @ResponseBody
    public void exportCustomTranslationsToJson(HttpServletResponse response, @ApiParam(value="A JSON array containing translations to export", required=true) @RequestBody List<CustomTranslationDto> translationsToExport) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List locales = this.translationService.getLocales();
        ArrayList<CustomTranslationDto> allCustomTranslations = new ArrayList<CustomTranslationDto>();
        for (String locale : locales) {
            allCustomTranslations.addAll(this.translationProvider.getCustomTranslations(Locale.forLanguageTag(locale)));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<ObjectNode> translationNodes = new ArrayList<ObjectNode>();
        for (CustomTranslationDto translation : translationsToExport) {
            ObjectNode translationNode = objectMapper.createObjectNode();
            translationNode.put("source", "custom-messages");
            translationNode.put("key", translation.getKey());
            for (String locale : locales) {
                translationNode.put("value_" + locale, this.getTranslatedValueForLocale(allCustomTranslations, translation, locale));
            }
            translationNodes.add(translationNode);
        }
        String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(translationNodes);
        response.setContentType("application/json");
        response.setHeader("Content-Disposition", "attachment; filename=export_custom-translations.json");
        response.getOutputStream().write(json.getBytes());
        response.getOutputStream().flush();
    }

    private String getTranslatedValueForLocale(List<CustomTranslationDto> customTranslations, CustomTranslationDto translationToExport, String locale) {
        return customTranslations.stream().filter(customTranslation -> customTranslation.getKey().equals(translationToExport.getKey()) && customTranslation.getLocale().equalsIgnoreCase(locale)).map(CustomTranslationDto::getValue).findFirst().orElse("");
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"import/excel"})
    @ResponseBody
    public ImportTranslationsResult importCustomTranslationsFromExcel(HttpServletRequest request, @RequestBody byte[] excelFileData) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_TRANSLATIONS);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("fileFormat", "Excel");
        auditParams.put("translationType", TranslationType.CUSTOM.name());
        try {
            ImportTranslationsResult result = this.importTranslationsService.importTranslationsFromExcel(excelFileData);
            auditParams.put("addedCount", result.getAddedCount());
            auditParams.put("modifiedCount", result.getModifiedCount());
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return result;
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"import/json"})
    @ResponseBody
    public ImportTranslationsResult importCustomTranslationsFromJson(HttpServletRequest request, @RequestBody JsonNode jsonData) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_TRANSLATIONS);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("fileFormat", "JSON");
        auditParams.put("translationType", TranslationType.CUSTOM.name());
        try {
            ImportTranslationsResult result = this.importTranslationsService.importTranslationsFromJson(jsonData);
            auditParams.put("addedCount", result.getAddedCount());
            auditParams.put("modifiedCount", result.getModifiedCount());
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return result;
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestExceptions(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={LocalizedServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleLocalizedServiceException(LocalizedServiceException e) {
        log.info(e.getLocalizedMessage());
        return new RestResult(false, e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"authorizationHelper", "translationProvider", "translationService", "exportService", "importTranslationsService", "messageHelper"})
    @Autowired
    public CustomTranslationsController(AuthorizationHelper authorizationHelper, CustomTranslationProvider translationProvider, CustomTranslationService translationService, ExportService exportService, ImportCustomTranslationsService importTranslationsService, MessageHelperBean messageHelper) {
        this.authorizationHelper = authorizationHelper;
        this.translationProvider = translationProvider;
        this.translationService = translationService;
        this.exportService = exportService;
        this.importTranslationsService = importTranslationsService;
        this.messageHelper = messageHelper;
    }
}

