/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks.dto;

import com.plusmpm.database.scheduledTasks.ScheduledTaskHistory;
import com.suncode.pwfl.administration.scheduledtask.file.ScheduledTaskResultFile;
import com.suncode.pwfl.customfile.dao.CustomFileEntity;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.HistoryFileDto;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ScheduledTaskHistoryDto {
    private Long id;
    private String startDate;
    private String finishDate;
    private Boolean success;
    private String result;
    private List<HistoryFileDto> resultFiles;

    public ScheduledTaskHistoryDto(ScheduledTaskHistory historyEntity, List<ScheduledTaskResultFile> resultFiles) {
        this.id = historyEntity.getId();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.startDate = dateFormatter.format(historyEntity.getStartDate());
        Date finishDate = historyEntity.getFinishDate();
        this.finishDate = finishDate != null ? dateFormatter.format(finishDate) : null;
        this.success = historyEntity.isSuccess();
        this.result = historyEntity.getResult();
        this.resultFiles = resultFiles.stream().map(ScheduledTaskResultFile::getFile).sorted(Comparator.comparing(CustomFileEntity::getCreationDate)).map(HistoryFileDto::new).collect(Collectors.toList());
    }

    public Long getId() {
        return this.id;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getFinishDate() {
        return this.finishDate;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getResult() {
        return this.result;
    }

    public List<HistoryFileDto> getResultFiles() {
        return this.resultFiles;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(String finishDate) {
        this.finishDate = finishDate;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setResultFiles(List<HistoryFileDto> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public ScheduledTaskHistoryDto() {
    }

    @ConstructorProperties(value={"id", "startDate", "finishDate", "success", "result", "resultFiles"})
    public ScheduledTaskHistoryDto(Long id, String startDate, String finishDate, Boolean success, String result, List<HistoryFileDto> resultFiles) {
        this.id = id;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.success = success;
        this.result = result;
        this.resultFiles = resultFiles;
    }
}

