/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.favourites;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.plugin.dashboard.web.support.GadgetControllerSupport;
import com.suncode.pwfl.favourites.FavouriteElement;
import com.suncode.pwfl.favourites.FavouriteHandler;
import com.suncode.pwfl.favourites.FavouritesRegistry;
import com.suncode.pwfl.favourites.FavouritesService;
import com.suncode.pwfl.favourites.FavouritesSet;
import com.suncode.pwfl.favourites.view.FavouritesRenderer;
import com.suncode.pwfl.web.dto.favourites.FavouritesRowDto;
import com.suncode.pwfl.web.dto.favourites.FavouritesSetDto;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/favourites"})
public class FavouritesController
extends GadgetControllerSupport {
    @Autowired
    private FavouritesService favouritesService;
    @Autowired
    private FavouritesRegistry registry;

    @RequestMapping(value={"/gadget/favourites"})
    public ResponseEntity<?> getFavourites(@RequestParam Long favouritesSetId) {
        try {
            FavouritesSet favouritesSet = this.getFavouritesSet(favouritesSetId);
            List<FavouritesRowDto> favouritesDtoList = favouritesSet.getElements().stream().map(this::convertToDto).filter(Objects::nonNull).collect(Collectors.toList());
            FavouritesSetDto favouritesSetDto = FavouritesSetDto.builder().id(favouritesSetId).name(this.getTranslatedName(favouritesSet.getName())).favourites(favouritesDtoList).build();
            return new ResponseEntity((Object)favouritesSetDto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/gadget/favourites/count"})
    public ResponseEntity<?> getCount(@RequestParam Long favouriteElementId) {
        FavouriteElement favouriteElement = this.favouritesService.getFavourite(favouriteElementId);
        if (favouriteElement == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.getCount(favouriteElement), (HttpStatusCode)HttpStatus.OK);
    }

    private FavouritesSet getFavouritesSet(Long set) {
        FavouritesSet favouritesSet = this.favouritesService.getFavourites(set);
        if (favouritesSet == null) {
            throw new IllegalArgumentException("Favourite set with id [" + set + "] does not exists");
        }
        return favouritesSet;
    }

    private FavouritesRenderer getRenderer(FavouriteElement favourite) {
        FavouriteHandler handler = this.registry.getHandler(favourite.getType());
        if (handler == null) {
            return null;
        }
        FavouritesRenderer renderer = handler.getRenderer(favourite);
        if (renderer == null || !renderer.shouldRender()) {
            return null;
        }
        return renderer;
    }

    private FavouritesRowDto convertToDto(FavouriteElement favourite) {
        FavouritesRenderer favouritesRenderer = this.getRenderer(favourite);
        if (favouritesRenderer == null) {
            return null;
        }
        try {
            return new FavouritesRowDto(favourite, favouritesRenderer);
        }
        catch (Exception e) {
            this.logger.warn("Could not render favourite row [id:{} name:{}]. Nested Exception is", new Object[]{favourite.getId(), favourite.getName(), e});
            return null;
        }
    }

    private String getCount(FavouriteElement favouriteElement) {
        FavouritesRenderer favouritesRenderer = this.getRenderer(favouriteElement);
        if (favouritesRenderer == null) {
            return null;
        }
        try {
            return favouritesRenderer.renderCount();
        }
        catch (Exception e) {
            this.logger.warn("Could not render favourite count [id:{} name:{}]. Nested Exception is", new Object[]{favouriteElement.getId(), favouriteElement.getName(), e});
            return null;
        }
    }

    private String getTranslatedName(String name) {
        I18NCustom custom = new I18NCustom(LocaleContextHolder.getLocale());
        return custom.getStringSilent(name);
    }
}

