/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.documents.fulltextsearch;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.FullTextSearch.Document;
import com.plusmpm.util.FullTextSearch.SearchFiles;
import com.plusmpm.util.FullTextSearch.meta.SearchMeta;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.documents.DocumentsSearchResultFileDto;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.controller.api.documents.fulltextsearch.DocumentFullTextSearchDto;
import com.suncode.pwfl.web.util.SessionUtils;
import io.swagger.annotations.Api;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documents/search/fullText"})
@Api(hidden=true)
public class DocumentsFullTextSearchController {
    private static final Logger log = LoggerFactory.getLogger(DocumentsFullTextSearchController.class);
    private final DBManagement dbManagement = new DBManagement();
    private final DocumentClassService documentClassService;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;

    @PostMapping
    public CountedResult<DocumentsSearchResultFileDto> fullTextResult(@RequestBody DocumentFullTextSearchDto documentFullTextSearchDto) {
        DocumentsSearchResultFileDto foundDocument;
        String userName = SessionUtils.getLoggedUserName();
        HashSet contentSearchResults = new HashSet();
        HashSet indexSearchResults = new HashSet();
        if (StringUtils.isEmpty((CharSequence)documentFullTextSearchDto.getPhrase())) {
            return Paginator.forAll(new ArrayList()).viewPageByOffset(documentFullTextSearchDto.getStart(), documentFullTextSearchDto.getLimit());
        }
        String sourcePhrase = documentFullTextSearchDto.getPhrase();
        String phrase = this.fixQuotes(sourcePhrase);
        SearchMeta meta = new SearchMeta();
        meta.setPhrase(phrase);
        meta.setShowContent(documentFullTextSearchDto.getShowContent().booleanValue());
        List userDocumentClasses = this.documentClassService.getDocumentClassesForUser(userName, false);
        ArrayList directories = new ArrayList();
        if (CollectionUtils.isNotEmpty(documentFullTextSearchDto.getSelectedClasses())) {
            documentFullTextSearchDto.getSelectedClasses().forEach(selectedClass -> {
                File documentClassPath;
                DocumentClass docClass = (DocumentClass)this.documentClassService.get((Serializable)selectedClass);
                if (userDocumentClasses.stream().anyMatch(userDocClass -> docClass.getId().equals(userDocClass.getId())) && (documentClassPath = new File(docClass.getIndexPath())).exists() && Objects.requireNonNull(documentClassPath.listFiles()).length > 0) {
                    directories.add(docClass.getIndexPath());
                }
            });
        }
        if (!directories.isEmpty()) {
            try {
                contentSearchResults.addAll(SearchFiles.Search(directories, (String)"content", (SearchMeta)meta));
                indexSearchResults.addAll(SearchFiles.Search(directories, (String)"index", (SearchMeta)meta));
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            throw new IllegalArgumentException(MessageHelper.getMessage((String)"Nie_wybrano_zadnej_klasy_dokumentow_lub_w_wybranych_klasach_nie_ma_indeksow"));
        }
        ArrayList<DocumentsSearchResultFileDto> results = new ArrayList<DocumentsSearchResultFileDto>();
        HashMap<Long, String> conditionQueryCache = new HashMap<Long, String>();
        HashMap<String, Boolean> modifyRightCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> deleteRightCache = new HashMap<String, Boolean>();
        if (!contentSearchResults.isEmpty()) {
            for (Document document : contentSearchResults) {
                foundDocument = this.prepareFullTextSearchResults(document, true, userName, conditionQueryCache, modifyRightCache, deleteRightCache);
                if (foundDocument == null) continue;
                results.add(foundDocument);
            }
        }
        if (!indexSearchResults.isEmpty()) {
            for (Document document : indexSearchResults) {
                if (contentSearchResults.contains(document) || (foundDocument = this.prepareFullTextSearchResults(document, false, userName, conditionQueryCache, modifyRightCache, deleteRightCache)) == null) continue;
                results.add(foundDocument);
            }
        }
        results.sort((Comparator<DocumentsSearchResultFileDto>)DtoComparator.of(DocumentsSearchResultFileDto.class, (String)documentFullTextSearchDto.getSortBy(), (SortDirection)documentFullTextSearchDto.getSortDirection()).withIgnoreCase(true));
        return Paginator.forAll(results).viewPageByOffset(documentFullTextSearchDto.getStart(), documentFullTextSearchDto.getLimit());
    }

    @GetMapping(value={"export/{extension}"})
    public void exportDocumentsFromClass(HttpServletResponse response, DocumentFullTextSearchDto documentFullTextSearchDto, @PathVariable String extension) throws IOException {
        documentFullTextSearchDto.setLimit(Integer.MAX_VALUE);
        documentFullTextSearchDto.setStart(0);
        List documents = this.fullTextResult(documentFullTextSearchDto).getData();
        LinkedList<ExportColumn> columns = new LinkedList<ExportColumn>();
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Klasa_dokumentu"), documents, DocumentsSearchResultFileDto::docClassName));
        if (Boolean.TRUE.equals(documentFullTextSearchDto.getShowContent())) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Tresc"), documents, DocumentsSearchResultFileDto::extract));
        }
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Trafnosc"), documents, doc -> String.format("%.1f", doc.score())));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Dokumenty")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<DocumentsSearchResultFileDto> data, Function<DocumentsSearchResultFileDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private String fixQuotes(String phrase) {
        int countQ = StringUtils.countMatches((CharSequence)phrase, (CharSequence)"\"");
        if (countQ == 1 && (phrase.indexOf("\"") == 0 || phrase.charAt(phrase.indexOf("\"") - 1) != '\\')) {
            return phrase.replace("\"", "\\\"");
        }
        return phrase;
    }

    private DocumentsSearchResultFileDto prepareFullTextSearchResults(Document document, boolean isContentSearch, String username, Map<Long, String> conditionQueryCache, Map<String, Boolean> modifyRightCache, Map<String, Boolean> deleteRightCache) {
        DocumentsSearchResultFileDto result = null;
        DocumentClass documentClassEntity = (DocumentClass)this.documentClassService.get((Serializable)Long.valueOf(document.getTypeId()));
        String conditionQuery = this.getConditionQuery(username, conditionQueryCache, documentClassEntity.getId());
        DocumentData documentData = this.dbManagement.GetDocument(document.getTypeId(), document.getDocumentId(), conditionQuery);
        if (documentData != null) {
            String className = this.documentClassService.getDocumentClassTranslation(documentClassEntity.getId(), TranslatedFieldType.NAME);
            float score = document.getScore() * 100.0f;
            Boolean hasModifyRight = this.getModifyRight(username, modifyRightCache, document);
            Boolean hasDeleteRight = this.getDeleteRight(username, deleteRightCache, document);
            String extract = this.getExtract(document, isContentSearch, documentData);
            result = new DocumentsSearchResultFileDto(Long.valueOf(documentData.getLDocumentId()), documentClassEntity.getId(), className, Long.valueOf(documentData.getLFileId()), Float.valueOf(score), extract, hasModifyRight.booleanValue(), hasDeleteRight.booleanValue());
        }
        return result;
    }

    @Nullable
    private String getExtract(Document document, boolean isContentSearch, DocumentData documentData) {
        String extract = isContentSearch ? document.getContent() : documentData.getAlIndecies().stream().filter(documentIndexes -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{documentIndexes.getValue()})).map(documentIndexes -> this.documentClassService.getDocumentClassIndexTranslation(Long.valueOf(documentIndexes.getId()), TranslatedFieldType.NAME) + " : " + documentIndexes.getValue()).collect(Collectors.joining(", "));
        try {
            extract = new String(extract.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return extract;
    }

    private String getConditionQuery(String username, Map<Long, String> conditionQueryCache, Long docClassEntityId) {
        String conditionQuery;
        if (!conditionQueryCache.containsKey(docClassEntityId)) {
            conditionQuery = Authorization.GetDocClassConditionProtection((String)" ", (String)username, (String)String.valueOf(docClassEntityId));
            conditionQueryCache.put(docClassEntityId, conditionQuery);
        } else {
            conditionQuery = conditionQueryCache.get(docClassEntityId);
        }
        return conditionQuery;
    }

    private Boolean getModifyRight(String username, Map<String, Boolean> modifyRightCache, Document document) {
        Boolean hasModifyRight;
        String documentType = document.getTypeId();
        if (!modifyRightCache.containsKey(documentType)) {
            hasModifyRight = this.hasModifyRight(document, username);
            modifyRightCache.put(documentType, hasModifyRight);
        } else {
            hasModifyRight = modifyRightCache.get(documentType);
        }
        return hasModifyRight;
    }

    private Boolean getDeleteRight(String username, Map<String, Boolean> deleteRightCache, Document document) {
        Boolean hasDeleteRight;
        String documentType = document.getTypeId();
        if (!deleteRightCache.containsKey(documentType)) {
            hasDeleteRight = this.hasDeleteRight(document, username);
            deleteRightCache.put(documentType, hasDeleteRight);
        } else {
            hasDeleteRight = deleteRightCache.get(documentType);
        }
        return hasDeleteRight;
    }

    private boolean hasDeleteRight(Document document, String username) {
        String rightType = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)document.getTypeId()).delete().build();
        return Authorization.CheckRight((String)rightType, (String)username, (boolean)false) == 0;
    }

    private boolean hasModifyRight(Document document, String username) {
        String rightType = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)document.getTypeId()).modify().build();
        return Authorization.CheckRight((String)rightType, (String)username, (boolean)false) == 0;
    }

    @ConstructorProperties(value={"documentClassService", "exportService", "messageHelper"})
    @Autowired
    public DocumentsFullTextSearchController(DocumentClassService documentClassService, ExportService exportService, MessageHelperBean messageHelper) {
        this.documentClassService = documentClassService;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
    }
}

