/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.documents.advices;

import com.suncode.pwfl.archive.exception.DocumentClassNotFoundException;
import com.suncode.pwfl.archive.exception.DocumentNotFoundException;
import com.suncode.pwfl.archive.exception.InvalidIndexValueException;
import com.suncode.pwfl.archive.exception.WfFileVersionNotFoundException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(basePackages={"com.suncode.pwfl.web.controller.api.documents"})
@Api(hidden=true)
public class SearchControllersAdvice {
    private static final Logger log = LoggerFactory.getLogger(SearchControllersAdvice.class);
    private final MessageHelperBean messageHelper;

    @ExceptionHandler(value={NotFullRightsException.class, NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={ServiceException.class, InvalidIndexValueException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={DocumentNotFoundException.class, DocumentClassNotFoundException.class, WfFileVersionNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFound(Exception e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"messageHelper"})
    @Autowired
    public SearchControllersAdvice(MessageHelperBean messageHelper) {
        this.messageHelper = messageHelper;
    }
}

