/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.distinction;

import com.plusmpm.database.AdvanceSearchVariableDto;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.distinction.DistinctionMapper;
import com.suncode.pwfl.distinction.VariableDistinguishService;
import com.suncode.pwfl.distinction.VariableDistinguishTable;
import com.suncode.pwfl.distinction.dto.DistinctionBase64;
import com.suncode.pwfl.distinction.dto.DistinctionDto;
import com.suncode.pwfl.distinction.exception.DistinctionNotFoundException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.support.ParametrizedRuntimeException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.exception.VariableDistinguishNotFoundException;
import com.suncode.pwfl.view.service.advancedSearchVariables.AdvanceSearchVariableQueryService;
import com.suncode.pwfl.view.service.viewRights.ViewRightsService;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.JsonMessage;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/distinction"})
@Api(hidden=true)
class DistinctionController {
    private static final Logger log = LoggerFactory.getLogger(DistinctionController.class);
    private final MessageHelperBean messageHelper;
    private final VariableDistinguishService variableDistinguishService;
    private final DistinctionMapper distinctionMapper;
    private final ViewRightsService viewRightsService;
    private final AdvanceSearchVariableQueryService advanceSearchVariableQueryService;

    @PostMapping(value={"add"})
    JsonMessage addDistinction(HttpServletRequest request, @RequestBody DistinctionBase64 data) {
        Map<String, Object> auditParams = this.getAuditParams(data);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_VARIABLE_DISTINGUISH).params(auditParams);
        if (!this.viewRightsService.hasRightsToView(data.getViewId())) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        try {
            long variableId = this.variableDistinguishService.saveDistinction(this.distinctionMapper.toDistinction(data));
            auditParams.put("variableDistinguishId", variableId);
            auditBuilder.params(auditParams);
            auditBuilder.buildSuccess(request);
            return new JsonMessage();
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @PutMapping(value={"replace"})
    JsonMessage replaceDistinctions(HttpServletRequest request, @RequestParam long viewId, @RequestBody List<DistinctionBase64> distinctions) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_MULTIPLE_VARIABLE_DISTINGUISH).params(Map.of("viewId", viewId, "distinctionCount", distinctions.size()));
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(viewId))) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        try {
            List variableDistinguishTables = distinctions.stream().map(arg_0 -> ((DistinctionMapper)this.distinctionMapper).toDistinction(arg_0)).collect(Collectors.toList());
            this.variableDistinguishService.replaceDistinctionsForView(viewId, variableDistinguishTables);
            auditBuilder.buildSuccess(request);
            return new JsonMessage();
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @DeleteMapping(value={"all"})
    JsonMessage removeDistinctions(HttpServletRequest request, @RequestParam long viewId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_ALL_VARIABLE_DISTINGUISH).params(Map.of("viewId", viewId));
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(viewId))) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        try {
            this.variableDistinguishService.deleteAllVariableDistinguishForView(viewId);
            auditBuilder.buildSuccess(request);
            return new JsonMessage();
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @GetMapping(value={"/{distinctionId}"})
    DistinctionDto getDistinction(@PathVariable long distinctionId) {
        VariableDistinguishTable variableDistinguish = this.variableDistinguishService.getVariableDistinguish(distinctionId);
        DistinctionDto distinction = this.distinctionMapper.toDistinctionDto(variableDistinguish, this.advanceSearchVariableQueryService.findAdvanceSearchVariableForView(Long.valueOf(Long.parseLong(variableDistinguish.getViewId())), variableDistinguish.getVariableId()).getTranslatedName());
        if (!this.viewRightsService.hasRightsToView(distinction.getViewId())) {
            throw new NotFullRightsException();
        }
        return distinction;
    }

    @PostMapping(value={"change/{distinctionId}"})
    JsonMessage changeDistinction(HttpServletRequest request, @PathVariable long distinctionId, @RequestBody DistinctionBase64 data) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("variableDistinguishId", distinctionId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_VARIABLE_DISTINGUISH).params(auditParams);
        if (!this.viewRightsService.hasRightsToView(data.getViewId())) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        VariableDistinguishTable distinction = this.variableDistinguishService.getVariableDistinguish(distinctionId);
        if (distinction == null) {
            auditBuilder.buildFailure(request);
            throw new VariableDistinguishNotFoundException(this.messageHelper.getMessage("Wyroznienie_zmiennej_nie_istnieje"));
        }
        AdvanceSearchVariableDto currentVariable = this.advanceSearchVariableQueryService.findAdvanceSearchVariableForView(data.getViewId(), distinction.getVariableId());
        AdvanceSearchVariableDto changedVariable = this.advanceSearchVariableQueryService.findAdvanceSearchVariableForView(data.getViewId(), data.getVariableId());
        auditParams.put("viewId", data.getViewId());
        auditParams.put("variableName", currentVariable.getTranslatedName() + ";" + changedVariable.getTranslatedName());
        auditParams.put("variableType", StringUtils.defaultString((String)distinction.getVariableViewType().getAlias()) + ";" + StringUtils.defaultString((String)data.getDisplayType()));
        auditParams.put("variableFormat", StringUtils.defaultString((String)distinction.getVariableFormat().getAlias()) + ";" + StringUtils.defaultString((String)data.getDisplayFormat()));
        auditParams.put("variableColor", distinction.getColor() + ";" + data.getColor());
        auditParams.put("variableBackgroundColor", distinction.getBackgroundColor() + ";" + data.getBackgroundColor());
        auditBuilder.params(auditParams);
        try {
            this.variableDistinguishService.updateDistinction(this.distinctionMapper.toDistinction(data), distinction.getId().longValue());
            auditBuilder.buildSuccess(request);
            return new JsonMessage();
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @DeleteMapping(value={"/{distinctionId}"})
    void deleteDistinction(@PathVariable long distinctionId) {
        VariableDistinguishTable distinction = this.variableDistinguishService.getVariableDistinguish(distinctionId);
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(Long.parseLong(distinction.getViewId())))) {
            throw new NotFullRightsException();
        }
        this.variableDistinguishService.deleteVariableDistinguish(distinction.getId().longValue());
    }

    private Map<String, Object> getAuditParams(DistinctionBase64 data) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("viewId", data.getViewId());
        auditParams.put("variableName", data.getVariableName());
        auditParams.put("variableType", StringUtils.defaultString((String)data.getDisplayType()));
        auditParams.put("variableFormat", StringUtils.defaultString((String)data.getDisplayFormat()));
        auditParams.put("variableColor", data.getColor());
        auditParams.put("variableBackgroundColor", data.getBackgroundColor());
        return auditParams;
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    JsonMessage handleServiceException(ServiceException e) {
        log.info(e.getMessage(), (Throwable)e);
        return new JsonMessage(false, e.getMessage());
    }

    @ExceptionHandler(value={ParametrizedRuntimeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    JsonMessage handleParametrizedRuntimeException(ParametrizedRuntimeException e) {
        log.info(this.messageHelper.getMessage(e.getMessageKey(), e.getParameters()), (Throwable)e);
        return new JsonMessage(false, this.messageHelper.getMessage(e.getMessageKey(), e.getParameters()));
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={DistinctionNotFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    JsonMessage handleDistinctionNotFoundExceptionException(DistinctionNotFoundException e) {
        log.info(this.messageHelper.getMessage(e.getMessageKey(), e.getParameters()), (Throwable)e);
        return new JsonMessage(false, this.messageHelper.getMessage(e.getMessageKey(), e.getParameters()));
    }

    @ConstructorProperties(value={"messageHelper", "variableDistinguishService", "distinctionMapper", "viewRightsService", "advanceSearchVariableQueryService"})
    @Autowired
    public DistinctionController(MessageHelperBean messageHelper, VariableDistinguishService variableDistinguishService, DistinctionMapper distinctionMapper, ViewRightsService viewRightsService, AdvanceSearchVariableQueryService advanceSearchVariableQueryService) {
        this.messageHelper = messageHelper;
        this.variableDistinguishService = variableDistinguishService;
        this.distinctionMapper = distinctionMapper;
        this.viewRightsService = viewRightsService;
        this.advanceSearchVariableQueryService = advanceSearchVariableQueryService;
    }
}

