/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.dashboards;

import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.SystemDashboardService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DashboardAuditController {
    private final DashboardService dashboardService;
    private final SystemDashboardService systemDashboardService;
    private final UserService userService;

    @RequestMapping(value={"/dashboard/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public void auditDashboard(@RequestParam String dashboardId, @RequestParam(required=false) boolean system, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") Date started) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Dashboard dashboard = system ? this.systemDashboardService.getSystemDashboardForUser(dashboardId, user) : this.dashboardService.getDashboard(Long.valueOf(dashboardId));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dashboard.audit.dashboardname", dashboard.getName());
        params.put("dashboard.audit.numberofgadgets", dashboard.getGadgets().length);
        this.audit(started, new Date(), AuditTypes.AUDIT_DASHBOARD_LOADED, user.getUserName(), true, params);
    }

    @RequestMapping(value={"/gadget/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public void auditGadget(@RequestParam String gadgetId, @RequestParam(required=false) boolean system, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") Date started) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Gadget gadget = system ? (Gadget)this.systemDashboardService.findGadgetForUser(user, gadgetId).get() : this.dashboardService.getGadget(Long.valueOf(gadgetId));
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("gadget.audit.gadgetname", gadget.getName());
        params.put("gadget.audit.gadgetdescription", gadget.getDescription());
        params.put("dashboard.audit.dashboardname", gadget.getDashboard().getName());
        if (!gadget.getProperties().isEmpty()) {
            params.put("gadget.audit.gadgetproperties", "");
            gadget.getProperties().forEach((k, v) -> params.put((String)k, v.getValue() != null ? v.getValue().toString() : ""));
        }
        this.audit(started, new Date(), AuditTypes.AUDIT_GADGET_LOADING, user.getUserName(), true, params);
    }

    private void audit(Date started, Date stopped, AuditTypes type, String userName, boolean success, Map<String, Object> params) {
        ManualAuditBuilder.getInstance().type(type).username(userName).success(success).params(params).started(started).stopped(stopped).build().log();
    }

    @ConstructorProperties(value={"dashboardService", "systemDashboardService", "userService"})
    @Autowired
    public DashboardAuditController(DashboardService dashboardService, SystemDashboardService systemDashboardService, UserService userService) {
        this.dashboardService = dashboardService;
        this.systemDashboardService = systemDashboardService;
        this.userService = userService;
    }
}

