/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.customfile;

import com.suncode.pwfl.customfile.CustomFile;
import com.suncode.pwfl.customfile.CustomFileService;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.io.DownloadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"customfiles"})
public class CustomFileController {
    @Autowired
    private CustomFileService customFileService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public DownloadResource downloadCustomFile(@RequestParam Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        CustomFile customFile = this.customFileService.getFile(id);
        return new DownloadResource(customFile.getFileName(), customFile.getFileSize(), customFile.openInputStream());
    }
}

