/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates.fetchers;

import com.suncode.pwfl.certificates.exceptions.CertificateScanException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherBase;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherSimple;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateFetcherIMAP4
extends CertificateFetcherBase {
    private static final Logger log = LoggerFactory.getLogger(CertificateFetcherIMAP4.class);

    public CertificateFetcherIMAP4(String host, int port) {
        super(host, port);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Certificate[] tryFetch(int timeout) {
        try {
            CertificateFetcherSimple fetcher = new CertificateFetcherSimple(this.host, this.port);
            return fetcher.tryFetch(timeout);
        }
        catch (ServiceException fetcher) {
            Certificate[] certificateArray;
            Socket socket = null;
            SSLSocket sslSocket = null;
            try {
                SSLSocketFactory ssf = this.getInsecureSocketFactory();
                socket = new Socket();
                socket.connect(new InetSocketAddress(this.host, this.port), timeout);
                socket.setSoTimeout(timeout);
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                reader.readLine();
                writer.write("A0 STARTTLS");
                writer.newLine();
                writer.flush();
                reader.readLine();
                sslSocket = (SSLSocket)ssf.createSocket(socket, this.host, this.port, true);
                sslSocket.startHandshake();
                certificateArray = sslSocket.getSession().getPeerCertificates();
            }
            catch (KeyManagementException e) {
                try {
                    throw new CertificateScanException("Could not create SSL socket", (Throwable)e);
                    catch (NoSuchAlgorithmException e2) {
                        throw new CertificateScanException("Unknown secure algorithm", (Throwable)e2);
                    }
                    catch (SocketTimeoutException e3) {
                        throw new CertificateScanException("Target host is unreachable", (Throwable)e3);
                    }
                    catch (IOException e4) {
                        throw new CertificateScanException("Error occurred during estabilishing connection", (Throwable)e4);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sslSocket);
                    IOUtils.closeQuietly(socket);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Socket)sslSocket);
            IOUtils.closeQuietly((Socket)socket);
            return certificateArray;
        }
    }
}

