/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.ProcessCalendar;
import com.suncode.pwfl.calendar.process.ProcessCalendarShare;
import com.suncode.pwfl.calendar.process.api.ProcessCalendarService;
import com.suncode.pwfl.calendar.process.api.ProcessCalendarShareService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.calendar.ProcessCalendarShareDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/process/{calendarId}/share"})
@Api(hidden=true)
public class ProcessCalendarShareController {
    private final ProcessCalendarShareService processCalendarShareService;
    private final CalendarMapper calendarMapper;
    private final UserService userService;
    private final ProcessCalendarService processCalendarService;

    @GetMapping
    public CountedResult<ProcessCalendarShareDto> getProcessCalendarShares(@PathVariable long calendarId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        List<ProcessCalendarShareDto> processCalendarShares = this.processCalendarShareService.getProcessCalendarSharesForCalendar(calendarId).stream().map(this.calendarMapper::toProcessCalendarShareDto).toList();
        return Paginator.forAll(processCalendarShares).viewPageByOffset(start, limit);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public long addProcessCalendarShare(@PathVariable long calendarId, @RequestBody ProcessCalendarShareDto processCalendarShareDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_PROCESS_CALENDAR_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ProcessCalendarShare processCalendarShare = this.calendarMapper.toProcessCalendarShare(processCalendarShareDto);
            processCalendarShare.setCalendarId(calendarId);
            auditParamsBuilder.params(this.paramsFromProcessCalendarShare(processCalendarShare, user));
            long shareId = this.processCalendarShareService.addProcessCalendarShare(processCalendarShare, user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return shareId;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{shareId}"})
    public RestResult deleteProcessCalendarShare(@PathVariable long calendarId, @PathVariable long shareId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)shareId).param("calendarId", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS_CALENDAR_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ProcessCalendar processCalendar = (ProcessCalendar)this.processCalendarService.getCalendar(Long.valueOf(calendarId), user);
            auditParamsBuilder.param("calendarName", (Object)processCalendar.getName());
            this.processCalendarShareService.deleteProcessCalendarShare(Long.valueOf(shareId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    private Map<String, Object> paramsFromProcessCalendarShare(ProcessCalendarShare processCalendarShare, User user) {
        ProcessCalendar processCalendar = (ProcessCalendar)this.processCalendarService.getCalendar(Long.valueOf(processCalendarShare.getCalendarId()), user);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("calendarId", (Object)processCalendarShare.getCalendarId()).param("calendarName", (Object)processCalendar.getName()).param("userName", (Object)processCalendarShare.getUserName()).param("groupName", (Object)processCalendarShare.getGroupName());
        return auditParamsBuilder.build();
    }

    @ConstructorProperties(value={"processCalendarShareService", "calendarMapper", "userService", "processCalendarService"})
    @Autowired
    public ProcessCalendarShareController(ProcessCalendarShareService processCalendarShareService, CalendarMapper calendarMapper, UserService userService, ProcessCalendarService processCalendarService) {
        this.processCalendarShareService = processCalendarShareService;
        this.calendarMapper = calendarMapper;
        this.userService = userService;
        this.processCalendarService = processCalendarService;
    }
}

