/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.calendar.external.ExternalCalendarShare;
import com.suncode.pwfl.calendar.external.api.ExternalCalendarShareService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.calendar.ExternalCalendarShareDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/external/{calendarId}/share"})
@Api(hidden=true)
public class ExternalCalendarShareController {
    private final ExternalCalendarShareService externalCalendarShareService;
    private final CalendarMapper calendarMapper;
    private final UserService userService;

    @GetMapping
    public CountedResult<ExternalCalendarShareDto> getExternalCalendarShares(@PathVariable long calendarId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        List<ExternalCalendarShareDto> externalCalendarShare = this.externalCalendarShareService.getExternalCalendarSharesForCalendar(calendarId).stream().map(this.calendarMapper::toExternalCalendarShareDto).toList();
        return Paginator.forAll(externalCalendarShare).viewPageByOffset(start, limit);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public long addExternalCalendarShare(@PathVariable long calendarId, @RequestBody ExternalCalendarShareDto externalCalendarShareDto) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        ExternalCalendarShare externalCalendarShare = this.calendarMapper.toExternalCalendarShare(externalCalendarShareDto);
        externalCalendarShare.setCalendarId(calendarId);
        return this.externalCalendarShareService.addExternalCalendarShare(externalCalendarShare, user);
    }

    @DeleteMapping(value={"{shareId}"})
    public RestResult deleteExternalCalendarShare(@PathVariable long calendarId, @PathVariable long shareId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        this.externalCalendarShareService.deleteExternalCalendarShare(Long.valueOf(shareId), user);
        return new RestResult(true);
    }

    @ConstructorProperties(value={"externalCalendarShareService", "calendarMapper", "userService"})
    @Autowired
    public ExternalCalendarShareController(ExternalCalendarShareService externalCalendarShareService, CalendarMapper calendarMapper, UserService userService) {
        this.externalCalendarShareService = externalCalendarShareService;
        this.calendarMapper = calendarMapper;
        this.userService = userService;
    }
}

