/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.calendarSet.CalendarSetService;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarSet;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarSetId;
import com.suncode.pwfl.calendar.calendarSet.domain.share.CalendarSetShare;
import com.suncode.pwfl.calendar.calendarSet.domain.share.CalendarSetShareId;
import com.suncode.pwfl.calendar.calendarSet.domain.share.Group;
import com.suncode.pwfl.calendar.calendarSet.domain.share.ShareTarget;
import com.suncode.pwfl.calendar.calendarSet.share.CalendarSetShareService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.calendar.calendarSet.CalendarSetShareDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarSetMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/set/{calendarSetId}/share"})
@Api(hidden=true)
public class CalendarSetShareController {
    private static final Logger log = LoggerFactory.getLogger(CalendarSetShareController.class);
    private final CalendarSetShareService calendarSetShareService;
    private final CalendarSetMapper calendarSetMapper;
    private final UserService userService;
    private final CalendarSetService calendarSetService;

    @GetMapping
    public CountedResult<CalendarSetShareDto> getCalendarSetShares(@PathVariable long calendarSetId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        List<CalendarSetShareDto> shares = this.calendarSetShareService.getSharesForCalendarSet(new CalendarSetId(calendarSetId), user).stream().map(this.calendarSetMapper::toDto).toList();
        return Paginator.forAll(shares).viewPageByOffset(start, limit);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarSetShareDto createCalendarSetShare(@PathVariable long calendarSetId, @RequestBody CalendarSetShareDto calendarSetShareDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_CALENDAR_SET_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            Group shareTarget = StringUtils.isNotBlank((CharSequence)calendarSetShareDto.groupName()) ? new Group(calendarSetShareDto.groupName()) : new com.suncode.pwfl.calendar.calendarSet.domain.share.User(calendarSetShareDto.userName());
            CalendarSetShare share = new CalendarSetShare(new CalendarSetId(calendarSetId), (ShareTarget)shareTarget);
            auditParamsBuilder.params(this.paramsFromCalendarSetShare(share, user));
            CalendarSetShare addedShare = this.calendarSetShareService.createCalendarSetShare(share, user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarSetMapper.toDto(addedShare);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{shareId}"})
    public RestResult deleteCalendarSetShare(@PathVariable long shareId, @PathVariable long calendarSetId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("CALENDAR_SHARE_ID", (Object)shareId).param("CALENDAR_SET_ID", (Object)calendarSetId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_SET_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            CalendarSet calendarSet = this.calendarSetService.getCalendarSetForUser(new CalendarSetId(calendarSetId), user);
            auditParamsBuilder.param("CALENDAR_SET_NAME", (Object)calendarSet.name().name());
            this.calendarSetShareService.deleteCalendarSetShare(new CalendarSetShareId(shareId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    private Map<String, Object> paramsFromCalendarSetShare(CalendarSetShare calendarSetShare, User user) {
        CalendarSet calendarSet = this.calendarSetService.getCalendarSetForUser(calendarSetShare.calendarSetId(), user);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("CALENDAR_SET_ID", (Object)calendarSetShare.calendarSetId().id()).param("CALENDAR_SET_NAME", (Object)calendarSet.name().name());
        ShareTarget shareTarget = calendarSetShare.shareTarget();
        if (shareTarget instanceof com.suncode.pwfl.calendar.calendarSet.domain.share.User) {
            com.suncode.pwfl.calendar.calendarSet.domain.share.User shareUser = (com.suncode.pwfl.calendar.calendarSet.domain.share.User)shareTarget;
            auditParamsBuilder.param("CALENDAR_SHARE_USERNAME", (Object)shareUser.userId());
        }
        if ((shareTarget = calendarSetShare.shareTarget()) instanceof Group) {
            Group group = (Group)shareTarget;
            auditParamsBuilder.param("CALENDAR_SHARE_GROUPNAME", (Object)group.groupId());
        }
        return auditParamsBuilder.build();
    }

    @ConstructorProperties(value={"calendarSetShareService", "calendarSetMapper", "userService", "calendarSetService"})
    @Autowired
    public CalendarSetShareController(CalendarSetShareService calendarSetShareService, CalendarSetMapper calendarSetMapper, UserService userService, CalendarSetService calendarSetService) {
        this.calendarSetShareService = calendarSetShareService;
        this.calendarSetMapper = calendarSetMapper;
        this.userService = userService;
        this.calendarSetService = calendarSetService;
    }
}

