/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.CalendarType;
import com.suncode.pwfl.calendar.calendarSet.CalendarSetService;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarId;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarSet;
import com.suncode.pwfl.calendar.calendarSet.domain.CalendarSetId;
import com.suncode.pwfl.calendar.calendarSet.domain.Calendars;
import com.suncode.pwfl.calendar.calendarSet.domain.ShareLinkId;
import com.suncode.pwfl.web.dto.calendar.calendarSet.CalendarSetDto;
import com.suncode.pwfl.web.dto.calendar.calendarSet.UpsertCalendarSetDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarSetMapper;
import io.swagger.annotations.Api;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fortuna.ical4j.data.CalendarOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"calendar/set"})
@Api(hidden=true)
public class CalendarSetController {
    private static final Logger log = LoggerFactory.getLogger(CalendarSetController.class);
    private final CalendarSetService calendarSetService;
    private final CalendarSetMapper calendarSetMapper;
    private final UserService userService;

    @GetMapping
    public List<CalendarSetDto> getCalendarSetsForUser() {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        return this.calendarSetService.getCalendarSetsForUser(user).stream().map(calendarSet -> this.calendarSetMapper.toDto((CalendarSet)calendarSet, user)).toList();
    }

    @PostMapping
    public CalendarSetDto createCalendarSet(@RequestBody UpsertCalendarSetDto upsertCalendarSetDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_CALENDAR_SET);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            CalendarSet calendarSet = this.calendarSetMapper.toDomain(upsertCalendarSetDto, user);
            auditParamsBuilder.params(this.paramsFromCalendarSet(calendarSet, user));
            CalendarSet addedCalendarSet = this.calendarSetService.createCalendarSet(calendarSet);
            auditParamsBuilder.params(this.paramsFromCalendarSet(addedCalendarSet, user));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarSetMapper.toDto(addedCalendarSet, user);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PostMapping(value={"{id}"})
    public CalendarSetDto updateCalendarSet(@PathVariable Long id, @RequestBody UpsertCalendarSetDto upsertCalendarSetDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("CALENDAR_SET_ID", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_CALENDAR_SET);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            CalendarSet calendarSet = this.calendarSetMapper.toDomain(upsertCalendarSetDto, user);
            auditParamsBuilder.params(this.paramsFromCalendarSet(calendarSet, user));
            CalendarSet oldCalendarSet = this.calendarSetService.getCalendarSetForUser(new CalendarSetId(id.longValue()), user);
            CalendarSet updatedCalendarSet = this.calendarSetService.updateCalendarSet(new CalendarSetId(id.longValue()), user, calendarSet);
            auditParamsBuilder.params(this.paramsFromCalendarSet(oldCalendarSet, updatedCalendarSet, user));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarSetMapper.toDto(updatedCalendarSet, user);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteCalendarSet(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_SET).params(new AuditParamsBuilder().param("CALENDAR_SET_ID", (Object)id).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.calendarSetService.deleteCalendarSet(new CalendarSetId(id.longValue()), user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarSetId}/{calendarType}/{calendarId}"})
    public RestResult deleteCalendarFromSet(@PathVariable Long calendarId, @PathVariable CalendarType calendarType, @PathVariable Long calendarSetId, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_FROM_CALENDAR_SET);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("CALENDAR_SET_ID", (Object)calendarSetId);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            Calendar calendar = this.calendarSetMapper.getCalendar(new CalendarId(calendarId.longValue(), calendarType), user);
            auditParamsBuilder.param("CALENDAR_NAME", (Object)String.format("%s (%s-%s)", calendar.getName(), calendarType, calendarId));
            this.calendarSetService.deleteCalendarFromSet(new CalendarId(calendarId.longValue(), calendarType), new CalendarSetId(calendarSetId.longValue()), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @Nullable
    @GetMapping(value={"{calendarSetId}/share/link"})
    public String getCalendarSetShareLink(@PathVariable Long calendarSetId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        CalendarSet calendarSet = this.calendarSetService.getCalendarSetForUser(new CalendarSetId(calendarSetId.longValue()), user);
        return calendarSet.shareLinkId().map(this::buildShareCalendarSetUrl).orElse(null);
    }

    @GetMapping(value={"{calendarSetId}/share/link/generate"})
    public String generateCalendarSetShareLink(@PathVariable Long calendarSetId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("CALENDAR_SET_ID", (Object)calendarSetId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_GENERATE_CALENDAR_SET_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            CalendarSet calendarSet = this.calendarSetService.getCalendarSetForUser(new CalendarSetId(calendarSetId.longValue()), user);
            auditParamsBuilder.param("CALENDAR_SET_NAME", (Object)calendarSet.name().name());
            ShareLinkId shareLinkId = this.calendarSetService.generateCalendarSetShareLink(new CalendarSetId(calendarSetId.longValue()), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.buildShareCalendarSetUrl(shareLinkId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarSetId}/share/link"})
    public RestResult deleteCalendarSetShareLink(@PathVariable Long calendarSetId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("CALENDAR_SET_ID", (Object)calendarSetId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_SET_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            CalendarSet calendarSet = this.calendarSetService.getCalendarSetForUser(new CalendarSetId(calendarSetId.longValue()), user);
            auditParamsBuilder.param("CALENDAR_SET_NAME", (Object)calendarSet.name().name());
            this.calendarSetService.deleteCalendarSetShareLink(new CalendarSetId(calendarSetId.longValue()), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"share/link/{shareLinkId}"})
    public ResponseEntity<byte[]> getCalendarSetIcalResource(@PathVariable String shareLinkId) {
        net.fortuna.ical4j.model.Calendar icalCalendar = this.calendarSetService.buildIcalCalendar(new ShareLinkId(shareLinkId));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            outputter.output(icalCalendar, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error("Error on creating ICS file for resource " + shareLinkId, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        byte[] icalBytes = byteArrayOutputStream.toByteArray();
        String fileFormat = ".ics";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"text/calendar"));
        headers.setContentDispositionFormData("attachment", shareLinkId + ".ics");
        return new ResponseEntity((Object)icalBytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private String buildShareCalendarSetUrl(ShareLinkId shareLinkId) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/api/calendar/set/share/link/{shareLinkId}").buildAndExpand(new Object[]{shareLinkId.shareLinkId()}).toUriString();
    }

    private Map<String, Object> paramsFromCalendarSet(CalendarSet calendarSet, User user) {
        return new AuditParamsBuilder().param("CALENDAR_SET_NAME", (Object)calendarSet.name().name()).param("CALENDAR_SET_CALENDARS", (Object)this.getCalendarsString(calendarSet.calendars(), user)).build();
    }

    private Map<String, Object> paramsFromCalendarSet(CalendarSet oldCalendarSet, CalendarSet newCalendarSet, User user) {
        return new AuditParamsBuilder().param("CALENDAR_SET_NAME", (Object)String.format("%s > %s", oldCalendarSet.name().name(), newCalendarSet.name().name())).param("CALENDAR_SET_CALENDARS", (Object)String.format("%s > %s", this.getCalendarsString(oldCalendarSet.calendars(), user), this.getCalendarsString(newCalendarSet.calendars(), user))).build();
    }

    private String getCalendarsString(Calendars calendars, User user) {
        return calendars.calendars().stream().map(calendarId -> {
            String calendarName = this.calendarSetMapper.getCalendar((CalendarId)calendarId, user).getName();
            return String.format("%s (%s-%s)", calendarName, calendarId.calendarType().name(), calendarId.id());
        }).collect(Collectors.joining(","));
    }

    @ConstructorProperties(value={"calendarSetService", "calendarSetMapper", "userService"})
    @Autowired
    public CalendarSetController(CalendarSetService calendarSetService, CalendarSetMapper calendarSetMapper, UserService userService) {
        this.calendarSetService = calendarSetService;
        this.calendarSetMapper = calendarSetMapper;
        this.userService = userService;
    }
}

