/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.archive.DocumentClassProtectionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupAlreadyExistException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.database.DatabaseType;
import com.suncode.pwfl.database.NativeSqlUtils;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.notification.NotificationDefService;
import com.suncode.pwfl.report.ReportService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.view.service.viewProtection.ViewProtectionService;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.workflow.activity.ActivityRedirectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"groups"})
@Api(value="Groups", tags={"groups"}, description="Actions on groups")
public class UserGroupController {
    private static final Logger log = LoggerFactory.getLogger(UserGroupController.class);
    private final UserGroupFinder groupFinder;
    private final UserFinder userFinder;
    private final UserService userService;
    private final ActivityRedirectionService activityRedirectionService;
    private final AuthorizationHelper authorizationHelper;
    private final TransactionWrapper transactionWrapper;
    private final ExportService exportService;
    private final ReportService reportService;
    private final ViewProtectionService viewProtectionService;
    private final NotificationDefService notificationDefService;
    private final MessageHelperBean messageHelper;
    private final DocumentClassProtectionService documentClassProtectionService;

    @ApiOperation(value="Downloading a list of groups", notes="The answer contains an object storing the total number of results in the total field, and a list of groups in the data field")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    @ResponseBody
    @GetMapping(value={"query"})
    public CountedResult<UserGroup> getGroupsByQuery(@ApiParam(value="A phrase, on the basis of which the results will be filtered. Filtering applies to the group name", required=false) @RequestParam(required=false) String query, @ApiParam(value="The offset in the result set", required=false) @RequestParam(required=false) Integer start, @ApiParam(value="The maximum number of returned results", required=false) @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by field", required=false) @RequestParam(required=false) String sortBy) {
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            dc.add(Restrictions.ilike((String)"name", (String)query, (MatchMode)MatchMode.START));
        }
        long total = this.groupFinder.count(dc);
        try {
            if (StringUtils.isNotBlank((CharSequence)sortBy)) {
                SortDto[] sorters = this.parseJson(sortBy);
                this.addOrders(sorters, dc);
            }
        }
        catch (Exception e) {
            log.error("Couldn't add order to group list - error while parsing json.");
        }
        dc.setProjection(null);
        List groups = this.groupFinder.findByCriteria(dc, start, limit);
        return new CountedResult(total, groups);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"isGroupInRedirections"})
    public boolean isGroupInRedirections(@RequestParam String group) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List redirections = this.activityRedirectionService.getRedirectionsToGroup(group);
        return redirections.size() > 0;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"query/extended"})
    public CountedResult<GroupDto> queryExtended(@RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String descriptionQuery, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        long count = this.groupFinder.count(this.createCriteria(nameQuery, descriptionQuery));
        DetachedCriteria criteria = this.createCriteria(nameQuery, descriptionQuery);
        return new CountedResult(count, this.fetchGroups(start, limit, sortBy, sortDirection, criteria));
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"query/extended/ilike"})
    public CountedResult<GroupDto> queryExtendedIlike(@RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String descriptionQuery, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        long count = this.groupFinder.count(this.createIlikeCriteria(nameQuery, descriptionQuery));
        DetachedCriteria criteria = this.createIlikeCriteria(nameQuery, descriptionQuery);
        return new CountedResult(count, this.fetchGroups(start, limit, sortBy, sortDirection, criteria));
    }

    @ApiOperation(value="(Admin) Adding a new group", notes="Adds a new group")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PostMapping
    public JsonMessage create(HttpServletRequest request, @ApiParam(value="The executed query changes group description. The query is a JSON object with the following fields: \n          - **name** - name of the group \n          - **description** - description of the group", required=true) @RequestBody GroupDto groupDto) {
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_GROUP).params((Map)ImmutableMap.of((Object)"groupName", (Object)groupDto.getName(), (Object)"groupDescr", (Object)groupDto.getDescription()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        UserGroup group = new UserGroup(groupDto.getName());
        group.setDescription(groupDto.getDescription());
        try {
            this.userService.createGroup(group);
        }
        catch (GroupAlreadyExistException e) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            return new JsonMessage(false, this.messageHelper.getMessage("Taka_grupa_juz_istnieje"));
        }
        request.setAttribute("audit", (Object)builder.buildSuccess());
        return new JsonMessage();
    }

    @ApiOperation(value="(Admin) Deleting group", notes="Deletes group with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @DeleteMapping(value={"{groupId}"})
    public JsonMessage deleteGroup(HttpServletRequest request, @ApiParam(value="Id of the group", required=true) @PathVariable Long groupId) {
        UserGroup group = this.userService.getGroup(groupId, new String[0]);
        String groupName = group.getName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_GROUP).params((Map)ImmutableMap.of((Object)"groupId", (Object)groupName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        JsonMessage result = (JsonMessage)this.transactionWrapper.doInSharkTransaction(sharkSession -> (JsonMessage)this.transactionWrapper.doInHibernateTransaction(session -> {
            try {
                boolean userInOnlyOneGroup = this.userFinder.findByGroup(groupName).stream().anyMatch(user -> user.getGroups().size() <= 1);
                if (userInOnlyOneGroup) {
                    request.setAttribute("audit", (Object)builder.buildFailure());
                    return new JsonMessage(false, this.messageHelper.getMessage("group.delete.warning.user_only_in_this_group"));
                }
                this.userService.deleteGroup(groupName);
                Authorization.deleteRight((Session)session, (String)"System", (String)groupName, (boolean)true, (String[])new String[0]);
                this.reportService.deleteReportSharesForShareResourceId(groupName, true);
                this.viewProtectionService.deleteViewProtectionsForResource(groupName, true);
                this.notificationDefService.deleteNotificationRecipientsByResourceId(groupName, "group");
                this.documentClassProtectionService.deleteDocumentClassProtectionForResource(groupName, true);
                return new JsonMessage();
            }
            catch (Exception ex) {
                request.setAttribute("audit", (Object)builder.buildFailure());
                throw new RuntimeException(ex);
            }
        }));
        if (result.isSuccess()) {
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        return result;
    }

    @ApiOperation(value="(Admin) Changing a group description", notes="Changes the group description")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PutMapping
    public JsonMessage update(HttpServletRequest request, @ApiParam(value="The executed query changes group description. The query is a JSON object with the following fields: \n          - **id** - id of the group \n          - **name** - name of the group \n          - **description** - new description of the group", required=true) @RequestBody GroupDto groupDto) {
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_GROUP).params((Map)ImmutableMap.of((Object)"groupName", (Object)groupDto.getName(), (Object)"groupDescr", (Object)groupDto.getDescription()));
        JsonMessage result = (JsonMessage)this.transactionWrapper.doInHibernateTransaction(session -> {
            try {
                UserGroup group = this.userService.getGroup(groupDto.getId(), new String[0]);
                String oldDescription = group.getDescription() == null ? "" : group.getDescription();
                String groupDescriptionChange = oldDescription + " > " + groupDto.getDescription();
                builder.params((Map)ImmutableMap.of((Object)"groupName", (Object)groupDto.getName(), (Object)"groupDescr", (Object)groupDescriptionChange));
                this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
                group.setName(groupDto.getName());
                group.setDescription(groupDto.getDescription());
                this.userService.updateGroup(group);
                return new JsonMessage();
            }
            catch (Exception ex) {
                request.setAttribute("audit", (Object)builder.buildFailure());
                throw new RuntimeException(ex);
            }
        });
        request.setAttribute("audit", (Object)builder.buildSuccess());
        return result;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"users/importFromGroup"})
    public void importFromGroupToGroup(HttpServletRequest request, @RequestParam Long baseGroupId, Long targetGroupId) {
        String baseGroupName = ((UserGroup)this.groupFinder.get((Serializable)baseGroupId)).getName();
        String targetGroupName = ((UserGroup)this.groupFinder.get((Serializable)targetGroupId)).getName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_USERS_FROM_GROUP_TO_GROUP).params((Map)ImmutableMap.of((Object)"baseGroupName", (Object)baseGroupName, (Object)"targetGroupName", (Object)targetGroupName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        TransactionWrapper.get().doInHibernateTransaction(addUserSession -> {
            try {
                for (User user : ((UserGroup)this.groupFinder.get((Serializable)baseGroupId)).getUsers()) {
                    this.userService.addUserToGroup(user.getUserName(), targetGroupName);
                }
            }
            catch (Exception ex) {
                request.setAttribute("audit", (Object)builder.buildFailure());
                throw new RuntimeException(ex);
            }
        });
        request.setAttribute("audit", (Object)builder.buildSuccess());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"export/{extension}"})
    public void export(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String descriptionQuery, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DetachedCriteria criteria = this.createCriteria(nameQuery, descriptionQuery);
        List<GroupDto> groups = this.fetchGroups(0, Integer.MAX_VALUE, sortBy, sortDirection, criteria);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(groups).by(GroupDto::getName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis")).data(groups).by(GroupDto::getDescription).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Grupy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"user"})
    public List<GroupDto> getGroupsForUser(@RequestParam Long userId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.userService.getUser(userId, new String[]{"groups"}).getGroups().stream().map(GroupDto::fromDomain).sorted(Comparator.comparing(GroupDto::getName, CollatorInstance.get())).collect(Collectors.toList());
    }

    private SortDto[] parseJson(String sortBy) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        return (SortDto[])objectMapper.readValue(sortBy, SortDto[].class);
    }

    private void addOrders(SortDto[] sorters, DetachedCriteria dc) {
        for (SortDto sorter : sorters) {
            if (sorter.getDirection().equalsIgnoreCase("DESC")) {
                dc.addOrder(Order.desc((String)sorter.getProperty()));
                continue;
            }
            dc.addOrder(Order.asc((String)sorter.getProperty()));
        }
    }

    private List<GroupDto> fetchGroups(Integer start, Integer limit, String sortBy, SortDirection sortDirection, DetachedCriteria criteria) {
        criteria.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        return this.groupFinder.findByCriteria(criteria, start, limit).stream().map(GroupDto::fromDomain).collect(Collectors.toList());
    }

    private DetachedCriteria createIlikeCriteria(String nameQuery, String descriptionQuery) {
        DetachedCriteria criteria = DetachedCriteria.forClass(UserGroup.class);
        Conjunction and = Restrictions.conjunction();
        if (StringUtils.isNotBlank((CharSequence)nameQuery)) {
            String preparedNameQuery = this.prepareValue(nameQuery);
            and.add(Restrictions.ilike((String)"name", (String)preparedNameQuery, (MatchMode)MatchMode.ANYWHERE));
        }
        if (StringUtils.isNotBlank((CharSequence)descriptionQuery)) {
            String preparedDescriptionQuery = this.prepareValue(descriptionQuery);
            and.add(Restrictions.ilike((String)"description", (String)preparedDescriptionQuery, (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.add((Criterion)and);
        return criteria;
    }

    private DetachedCriteria createCriteria(String nameQuery, String descriptionQuery) {
        DetachedCriteria criteria = DetachedCriteria.forClass(UserGroup.class);
        DBUtils.filtersFrom((Map)ImmutableMap.of((Object)"name", (Object)this.prepareValue(nameQuery), (Object)"description", (Object)this.prepareValue(descriptionQuery))).forEach(filter -> criteria.add(filter.buildCriterion()));
        return criteria;
    }

    private String prepareValue(String value) {
        String trimmed = value.trim();
        if (NativeSqlUtils.getDatabaseType() == DatabaseType.MSSQL) {
            trimmed = trimmed.replace("[", "[[]");
        }
        return trimmed;
    }

    @ConstructorProperties(value={"groupFinder", "userFinder", "userService", "activityRedirectionService", "authorizationHelper", "transactionWrapper", "exportService", "reportService", "viewProtectionService", "notificationDefService", "messageHelper", "documentClassProtectionService"})
    @Autowired
    public UserGroupController(UserGroupFinder groupFinder, UserFinder userFinder, UserService userService, ActivityRedirectionService activityRedirectionService, AuthorizationHelper authorizationHelper, TransactionWrapper transactionWrapper, ExportService exportService, ReportService reportService, ViewProtectionService viewProtectionService, NotificationDefService notificationDefService, MessageHelperBean messageHelper, DocumentClassProtectionService documentClassProtectionService) {
        this.groupFinder = groupFinder;
        this.userFinder = userFinder;
        this.userService = userService;
        this.activityRedirectionService = activityRedirectionService;
        this.authorizationHelper = authorizationHelper;
        this.transactionWrapper = transactionWrapper;
        this.exportService = exportService;
        this.reportService = reportService;
        this.viewProtectionService = viewProtectionService;
        this.notificationDefService = notificationDefService;
        this.messageHelper = messageHelper;
        this.documentClassProtectionService = documentClassProtectionService;
    }
}

