/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.systemMessages;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.pwfl.administration.systemMessage.SystemMessage;
import com.suncode.pwfl.administration.systemMessage.SystemMessageNotFoundException;
import com.suncode.pwfl.administration.systemMessage.SystemMessageReadHistoryService;
import com.suncode.pwfl.administration.systemMessage.SystemMessageService;
import com.suncode.pwfl.administration.systemMessage.SystemMessageType;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.administration.systemMessages.SystemMessageDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.SystemMessageMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/systemMessage"})
@Api(tags={"system messages"})
public class SystemMessageController {
    private static final Logger log = LoggerFactory.getLogger(SystemMessageController.class);
    private final SystemMessageService systemMessageService;
    private final SystemMessageReadHistoryService systemMessageReadHistoryService;
    private final AuthorizationHelper authorizationHelper;
    private final SystemMessageMapper systemMessageMapper;
    private final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value="(Admin) Downloading list of system messages", notes="Retrieves a list of all system messages")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping
    public CountedResult<SystemMessageDto> getSystemMessages(@ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", defaultValue="id") @RequestParam(required=false, defaultValue="id") String orderBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        CountedResult systemMessages = this.systemMessageService.getSystemMessages(start, limit, orderBy, orderDirection);
        List<SystemMessageDto> dtos = systemMessages.getData().stream().map(this.systemMessageMapper::toDto).toList();
        return new CountedResult(systemMessages.getTotal(), dtos);
    }

    @ApiOperation(value="(Admin) Adding new system message", notes="Adds new system message")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PostMapping
    public void addSystemMessage(@ApiParam(value="The executed query saves document view for logged-in user. The query is a JSON object with the following fields \n  - **message** - message (required) \n  - **startDate** - start date (example \"2024-06-12T08:46:00\")\n  - **finishDate** - finish date\n  - **groupId** - group if (null if for all users)\n  - **enabled** - is active\n  - **afterLogin** - show only after login", required=true) @RequestBody SystemMessageDto systemMessageDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_SYSTEM_MESSAGE);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage systemMessage = this.systemMessageMapper.toEntity(systemMessageDto);
            auditBuilder.params(this.getAuditParams(systemMessage));
            this.systemMessageService.save((Object)systemMessage);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Editing system message", notes="Edits system message")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PatchMapping(value={"/update/{id}"})
    public SystemMessageDto updateSystemMessage(@ApiParam(value="id of the system message", required=true) @PathVariable Long id, @ApiParam(value="The executed query changes document view for logged-in user. The query is a JSON object with the following fields \n  - **message** - message (required) \n  - **startDate** - start date (example \"2024-06-12T08:46:00\")\n  - **finishDate** - finish date\n  - **groupId** - group if (null if for all users)\n  - **enabled** - is active\n  - **afterLogin** - show only after login", required=true) @RequestBody SystemMessageDto systemMessageDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_SYSTEM_MESSAGE);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage oldSystemMessage = this.systemMessageService.get(id);
            SystemMessage updatedSystemMessage = this.systemMessageMapper.toEntity(systemMessageDto);
            this.systemMessageService.updateSystemMessage(id, updatedSystemMessage);
            auditBuilder.params(this.getUpdateMessageParams(oldSystemMessage, updatedSystemMessage));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return this.systemMessageMapper.toDto(updatedSystemMessage);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Deleting system message", notes="Deletes system message with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @DeleteMapping(value={"/{id}"})
    public void deleteMessage(@ApiParam(value="Id of the system message", required=true) @PathVariable long id, HttpServletRequest request) throws SystemMessageNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_SYSTEM_MESSAGE).params((Map)ImmutableMap.of((Object)"SYSTEM_MESSAGE_ID", (Object)id));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage systemMessage = this.systemMessageService.get(Long.valueOf(id));
            this.systemMessageService.delete((Object)systemMessage);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PatchMapping(value={"/{id}"})
    private ResponseEntity<?> updateMessageStatus(@PathVariable long id, @RequestParam boolean enabled, HttpServletRequest request) throws SystemMessageNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHANGE_STATUS_SYSTEM_MESSAGE).params((Map)ImmutableMap.of((Object)"SYSTEM_MESSAGE_ID", (Object)id, (Object)"SYSTEM_MESSAGE_ENABLED", (Object)enabled));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage systemMessage = this.systemMessageService.get(Long.valueOf(id));
            systemMessage.setEnabled(enabled);
            this.systemMessageService.update((Object)systemMessage);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PostMapping(value={"/{messageId}/read"})
    public ResponseEntity<?> markMessageAsRead(@PathVariable long messageId, @RequestParam(required=false) boolean lastMessage, HttpServletRequest request) throws SystemMessageNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_READ_SYSTEM_MESSAGE);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("SYSTEM_MESSAGE_ID", messageId);
        auditBuilder.params(params);
        try {
            SystemMessage systemMessage = this.systemMessageService.get(Long.valueOf(messageId));
            params.put("SYSTEM_MESSAGE", systemMessage.getMessage());
            auditBuilder.params(params);
            this.systemMessageReadHistoryService.markAsRead(systemMessage, UserContext.current().getUser().getUserName());
            if (lastMessage) {
                request.getSession().removeAttribute("showSystemMessages");
            }
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PostMapping(value={"/sanitize"})
    public ResponseEntity<?> sanitizeMessage(@RequestBody String message, @RequestParam SystemMessageType messageType) {
        return new ResponseEntity((Object)this.systemMessageService.sanitizeMessage(message, messageType), (HttpStatusCode)HttpStatus.OK);
    }

    private Map<String, Object> getUpdateMessageParams(SystemMessage oldSystemMessage, SystemMessage newSystemMessage) {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<String> oldGroups = oldSystemMessage.getGroups().stream().map(UserGroup::getName).toList();
        List<String> newGroups = newSystemMessage.getGroups().stream().map(UserGroup::getName).toList();
        return new AuditParamsBuilder().param("SYSTEM_MESSAGE_ID", (Object)oldSystemMessage.getId()).param("SYSTEM_MESSAGE", (Object)this.formatChange(oldSystemMessage.getMessage(), newSystemMessage.getMessage())).param("SYSTEM_MESSAGE_START_DATE", (Object)this.formatChange(oldSystemMessage.getStartDate() != null ? dateTimeFormatter.format(oldSystemMessage.getStartDate()) : "", newSystemMessage.getStartDate() != null ? dateTimeFormatter.format(newSystemMessage.getStartDate()) : "")).param("SYSTEM_MESSAGE_FINISH_DATE", (Object)this.formatChange(oldSystemMessage.getFinishDate() != null ? dateTimeFormatter.format(oldSystemMessage.getFinishDate()) : "", newSystemMessage.getFinishDate() != null ? dateTimeFormatter.format(newSystemMessage.getFinishDate()) : "")).param("SYSTEM_MESSAGE_GROUP", (Object)this.formatChange(oldGroups, newGroups)).param("SYSTEM_MESSAGE_ENABLED", (Object)this.formatChange(oldSystemMessage.isEnabled(), newSystemMessage.isEnabled())).param("SYSTEM_MESSAGE_AFTER_LOGIN", (Object)this.formatChange(oldSystemMessage.isAfterLogin(), newSystemMessage.isAfterLogin())).build();
    }

    private String formatChange(Object oldValue, Object newValue) {
        return String.format("%s > %s", Objects.toString(oldValue, ""), Objects.toString(newValue, ""));
    }

    @ExceptionHandler(value={SystemMessageNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private Map<String, Object> getAuditParams(SystemMessage systemMessage) {
        List<String> groups = systemMessage.getGroups().stream().map(UserGroup::getName).toList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("SYSTEM_MESSAGE", Objects.toString(systemMessage.getMessage(), ""));
        params.put("SYSTEM_MESSAGE_START_DATE", systemMessage.getStartDate() != null ? this.dateTimeFormatter.format(systemMessage.getStartDate()) : "");
        params.put("SYSTEM_MESSAGE_FINISH_DATE", systemMessage.getFinishDate() != null ? this.dateTimeFormatter.format(systemMessage.getFinishDate()) : "");
        params.put("SYSTEM_MESSAGE_GROUP", groups);
        params.put("SYSTEM_MESSAGE_ENABLED", systemMessage.isEnabled());
        params.put("SYSTEM_MESSAGE_AFTER_LOGIN", systemMessage.isAfterLogin());
        return params;
    }

    @ConstructorProperties(value={"systemMessageService", "systemMessageReadHistoryService", "authorizationHelper", "systemMessageMapper"})
    @Autowired
    public SystemMessageController(SystemMessageService systemMessageService, SystemMessageReadHistoryService systemMessageReadHistoryService, AuthorizationHelper authorizationHelper, SystemMessageMapper systemMessageMapper) {
        this.systemMessageService = systemMessageService;
        this.systemMessageReadHistoryService = systemMessageReadHistoryService;
        this.authorizationHelper = authorizationHelper;
        this.systemMessageMapper = systemMessageMapper;
    }
}

