/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.permissions;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import com.suncode.pwfl.administration.permissions.PermissionTreeNode;
import com.suncode.pwfl.administration.permissions.PermissionType;
import com.suncode.pwfl.administration.permissions.Permissions;
import com.suncode.pwfl.administration.permissions.PermissionsService;
import com.suncode.pwfl.administration.permissions.ResourceId;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.administration.permissions.PermissionsDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.PermissionsMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"permissions"})
@Api(hidden=true)
public class PermissionsController {
    private static final Logger log = LoggerFactory.getLogger(PermissionsController.class);
    private final AuthorizationHelper authorizationHelper;
    private final PermissionsService permissionsService;
    private final PermissionsMapper permissionsMapper;
    private final MessageHelperBean messageHelper;
    private final ExportService exportService;
    private final SystemPropertiesBean systemProperties;
    private final Experimental experimental;
    private final Map<UUID, List<PermissionsDto>> exportCache = new HashMap<UUID, List<PermissionsDto>>();

    @GetMapping
    public CountedResult<PermissionsDto> getPermissions(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="resourceName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<PermissionsDto> permissionsDtos = this.permissionsService.getPermissions().stream().map(this.permissionsMapper::toPermissionDto).sorted((Comparator<PermissionsDto>)DtoComparator.of(PermissionsDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).toList();
        return Paginator.forAll(permissionsDtos).viewPageByOffset(start, limit);
    }

    @GetMapping(value={"for/resource"})
    public List<PermissionType> getPermissionTypesForResourceId(@RequestParam String resourceName, @RequestParam boolean isGroup) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.permissionsService.getPermissionTypesForResourceId(new ResourceId(resourceName, isGroup));
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public RestResult addPermissions(@RequestBody UpsertPermissionsDto upsertPermissionsDto, HttpServletRequest request) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_PERMISSIONS);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        try {
            auditParamsBuilder.params(this.paramsFromUpsertPermissionsDto(upsertPermissionsDto));
            this.permissionsService.addPermissions(upsertPermissionsDto.resourceId, upsertPermissionsDto.permissionTypes);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true, this.messageHelper.getMessage("Uprawnienia_zostaly_dodane"));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping
    @ResponseStatus(value=HttpStatus.OK)
    public RestResult editPermissions(@RequestBody UpsertPermissionsDto upsertPermissionsDto, HttpServletRequest request) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_PERMISSIONS);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        try {
            List existingPermissionTypes = this.permissionsService.getPermissionTypesForResourceId(upsertPermissionsDto.resourceId);
            UpsertPermissionsDto oldUpsertPermissionsDto = new UpsertPermissionsDto(upsertPermissionsDto.resourceId, existingPermissionTypes);
            auditParamsBuilder.params(this.paramsFromUpsertPermissionsDto(oldUpsertPermissionsDto, upsertPermissionsDto));
            this.permissionsService.editPermissions(upsertPermissionsDto.resourceId, upsertPermissionsDto.permissionTypes);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true, this.messageHelper.getMessage("Uprawnienia_zostaly_zmienione"));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping
    public RestResult deletePermission(@RequestParam String resourceName, @RequestParam boolean isGroup, @RequestParam boolean deletePartialPermissions, HttpServletRequest request) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PERMISSIONS).params(new AuditParamsBuilder().param("resourceName", (Object)resourceName).param("isGroup", (Object)isGroup).param("partialPermissions", (Object)this.getBooleanTranslation(deletePartialPermissions)).build());
        try {
            boolean result = this.permissionsService.deletePermission(new ResourceId(resourceName, isGroup), deletePartialPermissions);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return result ? new RestResult(true, this.messageHelper.getMessage("Uprawnienie_zostalo_usuniete")) : new RestResult(false, this.messageHelper.getMessage("Uprawnienie_nie_zostalo_usuniete"));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"parameter/showStatistics"})
    public Boolean getShowStatistics() {
        return this.systemProperties.getBoolean(DefinedSystemParameter.SHOW_STATISTICS);
    }

    @ResponseBody
    @RequestMapping(value={"parameter/optionalUserAccountRight"})
    public Boolean getOptionalUserAccountRight() {
        return this.systemProperties.getBoolean(DefinedSystemParameter.OPTIONAL_USER_ACCOUNT_RIGHT);
    }

    @ResponseBody
    @RequestMapping(value={"parameter/optionalViewsRight"})
    public Boolean getOptionalViewsRight() {
        return this.systemProperties.getBoolean(DefinedSystemParameter.OPTIONAL_VIEWS_RIGHT);
    }

    @GetMapping(value={"export/{extension}"})
    public void export(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="resourceName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException {
        List<PermissionsDto> permissionsDtos;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (id != null) {
            permissionsDtos = this.exportCache.get(id);
            this.exportCache.remove(id);
        } else {
            permissionsDtos = this.permissionsService.getPermissions().stream().map(this.permissionsMapper::toPermissionDto).sorted((Comparator<PermissionsDto>)DtoComparator.of(PermissionsDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).toList();
        }
        LinkedList<ExportColumn> columns = new LinkedList<ExportColumn>();
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Nazwa_uzytkownika_grupy"), permissionsDtos, PermissionsDto::resourceName));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Grupa"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.isGroup())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("System"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.system())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Administracja"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.admin())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Archiwum"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.archive())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Klasy_dokumentow"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.docClasses())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Zestawy_dokumentow"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.link())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Obieg_dokumentow"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.workflow())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Tworzenie_procesow"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.createProcess())));
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Wyszukiwanie_procesow"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.searchProcess())));
        if (this.systemProperties.getBoolean(DefinedSystemParameter.SHOW_STATISTICS).booleanValue()) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Statystyki"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.stats())));
        }
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("History"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.history())));
        if (this.experimental.hasFeature(ExperimentalFeature.NEW_CALENDAR)) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Kalendarz"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.calendar())));
        }
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Raporty"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.reports())));
        if (this.systemProperties.getBoolean(DefinedSystemParameter.OPTIONAL_USER_ACCOUNT_RIGHT).booleanValue()) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Konto_uzytkownika"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.userAccount())));
        }
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Moduly"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.plugins())));
        if (this.systemProperties.getBoolean(DefinedSystemParameter.OPTIONAL_VIEWS_RIGHT).booleanValue()) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Widoki"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.views())));
        }
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Ukryj_pulpit_systemowy"), permissionsDtos, permissionsDto -> this.getBooleanTranslation(permissionsDto.hideSystemDashboard())));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Zarzadzanie_uprawnieniami")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"export/{extension}"})
    @ResponseBody
    public URI exportFilteredPermissions(HttpServletRequest request, @RequestBody List<PermissionsDto> permissionsDtos, @PathVariable String extension) {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, permissionsDtos);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    @GetMapping(value={"/tree"})
    public List<PermissionTreeNode> getPermissionsTree() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.permissionsService.getTree();
    }

    private ExportColumn buildExportColumn(String name, List<PermissionsDto> data, Function<PermissionsDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private String getBooleanTranslation(boolean value) {
        return value ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie");
    }

    private Map<String, Object> paramsFromUpsertPermissionsDto(UpsertPermissionsDto upsertPermissionsDto) {
        Permissions permissions = this.resolvePermissionsFromPermissionType(upsertPermissionsDto);
        return new AuditParamsBuilder().param("resourceName", (Object)permissions.getResourceId().resourceName()).param("isGroup", (Object)permissions.getResourceId().isGroup()).param("system", (Object)this.getBooleanTranslation(permissions.isSystem())).param("admin", (Object)this.getBooleanTranslation(permissions.isAdmin())).param("archive", (Object)this.getBooleanTranslation(permissions.isArchive())).param("docClasses", (Object)this.getBooleanTranslation(permissions.isDocClasses())).param("link", (Object)this.getBooleanTranslation(permissions.isLink())).param("workflow", (Object)this.getBooleanTranslation(permissions.isWorkflow())).param("createProcess", (Object)this.getBooleanTranslation(permissions.isCreateProcess())).param("searchProcess", (Object)this.getBooleanTranslation(permissions.isSearchProcess())).param("stats", (Object)this.getBooleanTranslation(permissions.isStats())).param("calendar", (Object)this.getBooleanTranslation(permissions.isCalendar())).param("userAccount", (Object)this.getBooleanTranslation(permissions.isUserAccount())).param("reports", (Object)this.getBooleanTranslation(permissions.isReports())).param("views", (Object)this.getBooleanTranslation(permissions.isViews())).param("plugins", (Object)this.getBooleanTranslation(permissions.isPlugins())).param("history", (Object)this.getBooleanTranslation(permissions.isHistory())).param("hideSystemDashboard", (Object)this.getBooleanTranslation(permissions.isHideSystemDashboard())).build();
    }

    private Map<String, Object> paramsFromUpsertPermissionsDto(UpsertPermissionsDto oldUpsertPermissionsDto, UpsertPermissionsDto newUpsertPermissionsDto) {
        Permissions oldPermissions = this.resolvePermissionsFromPermissionType(oldUpsertPermissionsDto);
        Permissions newPermissions = this.resolvePermissionsFromPermissionType(newUpsertPermissionsDto);
        return new AuditParamsBuilder().param("resourceName", (Object)oldPermissions.getResourceId().resourceName(), (Object)newPermissions.getResourceId().resourceName()).param("isGroup", (Object)oldPermissions.getResourceId().isGroup(), (Object)newPermissions.getResourceId().isGroup()).param("system", (Object)this.getBooleanTranslation(oldPermissions.isSystem()), (Object)this.getBooleanTranslation(newPermissions.isSystem())).param("admin", (Object)this.getBooleanTranslation(oldPermissions.isAdmin()), (Object)this.getBooleanTranslation(newPermissions.isAdmin())).param("archive", (Object)this.getBooleanTranslation(oldPermissions.isArchive()), (Object)this.getBooleanTranslation(newPermissions.isArchive())).param("docClasses", (Object)this.getBooleanTranslation(oldPermissions.isDocClasses()), (Object)this.getBooleanTranslation(newPermissions.isDocClasses())).param("link", (Object)this.getBooleanTranslation(oldPermissions.isLink()), (Object)this.getBooleanTranslation(newPermissions.isLink())).param("workflow", (Object)this.getBooleanTranslation(oldPermissions.isWorkflow()), (Object)this.getBooleanTranslation(newPermissions.isWorkflow())).param("createProcess", (Object)this.getBooleanTranslation(oldPermissions.isCreateProcess()), (Object)this.getBooleanTranslation(newPermissions.isCreateProcess())).param("searchProcess", (Object)this.getBooleanTranslation(oldPermissions.isSearchProcess()), (Object)this.getBooleanTranslation(newPermissions.isSearchProcess())).param("stats", (Object)this.getBooleanTranslation(oldPermissions.isStats()), (Object)this.getBooleanTranslation(newPermissions.isStats())).param("calendar", (Object)this.getBooleanTranslation(oldPermissions.isCalendar()), (Object)this.getBooleanTranslation(newPermissions.isCalendar())).param("userAccount", (Object)this.getBooleanTranslation(oldPermissions.isUserAccount()), (Object)this.getBooleanTranslation(newPermissions.isUserAccount())).param("reports", (Object)this.getBooleanTranslation(oldPermissions.isReports()), (Object)this.getBooleanTranslation(newPermissions.isReports())).param("views", (Object)this.getBooleanTranslation(oldPermissions.isViews()), (Object)this.getBooleanTranslation(newPermissions.isViews())).param("plugins", (Object)this.getBooleanTranslation(oldPermissions.isPlugins()), (Object)this.getBooleanTranslation(newPermissions.isPlugins())).param("history", (Object)this.getBooleanTranslation(oldPermissions.isHistory()), (Object)this.getBooleanTranslation(newPermissions.isHistory())).param("hideSystemDashboard", (Object)this.getBooleanTranslation(oldPermissions.isHideSystemDashboard()), (Object)this.getBooleanTranslation(newPermissions.isHideSystemDashboard())).build();
    }

    private Permissions resolvePermissionsFromPermissionType(UpsertPermissionsDto upsertPermissionsDto) {
        Permissions permissions = new Permissions(upsertPermissionsDto.resourceId.resourceName(), upsertPermissionsDto.resourceId.isGroup());
        for (PermissionType permissionType : upsertPermissionsDto.permissionTypes()) {
            this.permissionsService.setPermissionBasedOnType(permissions, permissionType);
        }
        return permissions;
    }

    @ConstructorProperties(value={"authorizationHelper", "permissionsService", "permissionsMapper", "messageHelper", "exportService", "systemProperties", "experimental"})
    public PermissionsController(AuthorizationHelper authorizationHelper, PermissionsService permissionsService, PermissionsMapper permissionsMapper, MessageHelperBean messageHelper, ExportService exportService, SystemPropertiesBean systemProperties, Experimental experimental) {
        this.authorizationHelper = authorizationHelper;
        this.permissionsService = permissionsService;
        this.permissionsMapper = permissionsMapper;
        this.messageHelper = messageHelper;
        this.exportService = exportService;
        this.systemProperties = systemProperties;
        this.experimental = experimental;
    }

    private record UpsertPermissionsDto(ResourceId resourceId, List<PermissionType> permissionTypes) {
    }
}

