/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.authentication.oauth2.googleApi;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthentication;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthenticationService;
import com.suncode.pwfl.administration.system.SystemPropertiesHelper;
import com.suncode.pwfl.google.drive.GoogleDriveApiClient;
import com.suncode.pwfl.google.drive.GoogleDriveInternalService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(hidden=true)
@RestController
@RequestMapping(value={"googleOauth2"})
public class OAuth2GoogleApiController {
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Collections.singletonList("https://www.googleapis.com/auth/drive");
    private final GoogleDriveApiClient googleDriveApiClient;
    private final GoogleDriveInternalService googleDriveInternalService;
    private final SystemPropertiesHelper systemPropertiesHelper;
    private final GoogleApiAuthenticationService googleApiAuthenticationService;
    private final MessageHelperBean messageHelper;

    @GetMapping(value={"/callback"})
    public ResponseEntity<String> callback(@RequestParam(required=false) String code, @RequestParam(required=false) String error, @CookieValue(value="google_api_auth_id") String googleApiAuthId) throws Exception {
        if (error != null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)("B\u0142\u0105d OAuth: " + error));
        }
        if (code == null) {
            return ResponseEntity.badRequest().body((Object)"Brak parametru code");
        }
        Optional configurationOptional = this.googleApiAuthenticationService.findDefaultConfiguration(new String[0]);
        if (configurationOptional.isPresent()) {
            GoogleClientSecrets clientSecrets = this.googleDriveApiClient.getOauthClintSecrets((GoogleApiAuthentication)configurationOptional.get());
            String oauthRedirectUri = this.systemPropertiesHelper.prepareHttpLinkParameter() + "/api/googleOauth2/callback";
            GoogleTokenResponse tokenResponse = new GoogleAuthorizationCodeTokenRequest((HttpTransport)new NetHttpTransport(), JSON_FACTORY, clientSecrets.getDetails().getClientId(), clientSecrets.getDetails().getClientSecret(), code, oauthRedirectUri).execute();
            String refreshToken = tokenResponse.getRefreshToken();
            this.googleDriveInternalService.saveRefreshToken(refreshToken, googleApiAuthId);
            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)new NetHttpTransport(), JSON_FACTORY, clientSecrets, SCOPES).setAccessType("offline").build();
            Credential credential = flow.createAndStoreCredential((TokenResponse)tokenResponse, "user");
            credential.setRefreshToken(refreshToken);
            this.googleDriveApiClient.initDriveApiClient(credential);
            return ResponseEntity.ok().contentType(new MediaType("text", "plain", StandardCharsets.UTF_8)).body((Object)this.messageHelper.getMessage("GOOGLE_API_OAUTH_SUCCESS_AUTH"));
        }
        return null;
    }

    @ConstructorProperties(value={"googleDriveApiClient", "googleDriveInternalService", "systemPropertiesHelper", "googleApiAuthenticationService", "messageHelper"})
    @Autowired
    public OAuth2GoogleApiController(GoogleDriveApiClient googleDriveApiClient, GoogleDriveInternalService googleDriveInternalService, SystemPropertiesHelper systemPropertiesHelper, GoogleApiAuthenticationService googleApiAuthenticationService, MessageHelperBean messageHelper) {
        this.googleDriveApiClient = googleDriveApiClient;
        this.googleDriveInternalService = googleDriveInternalService;
        this.systemPropertiesHelper = systemPropertiesHelper;
        this.googleApiAuthenticationService = googleApiAuthenticationService;
        this.messageHelper = messageHelper;
    }
}

