/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.authentication.googleApi;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthentication;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthenticationException;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthenticationService;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiConnectionResult;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.web.dto.administration.authentication.googleApi.GoogleApiAuthenticationDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authenticationManagement/googleApi"})
@Api(hidden=true)
public class GoogleApiAuthenticationController {
    private static final Logger log = LoggerFactory.getLogger(GoogleApiAuthenticationController.class);
    private final GoogleApiAuthenticationService googleApiAuthenticationService;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping
    private List<GoogleApiAuthenticationDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.googleApiAuthenticationService.getAll(new String[0]).stream().map(GoogleApiAuthenticationDto::new).sorted((Comparator<GoogleApiAuthenticationDto>)DtoComparator.of(GoogleApiAuthenticationDto.class, (String)"name", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"})
    private GoogleApiAuthenticationDto getById(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        GoogleApiAuthentication config = (GoogleApiAuthentication)this.googleApiAuthenticationService.get((Serializable)((Object)id));
        return new GoogleApiAuthenticationDto(config);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"getOauthUrl"})
    private String getOauthUrl(@RequestBody GoogleApiAuthenticationDto configurationDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        GoogleApiAuthentication configuration = configurationDto.toEntity();
        return this.googleApiAuthenticationService.getOauthUrl(configuration);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"connect"})
    private GoogleApiConnectionResult connect(@RequestBody GoogleApiAuthenticationDto configurationDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        GoogleApiAuthentication configuration = configurationDto.toEntity();
        return this.googleApiAuthenticationService.connect(configuration);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"test"})
    private GoogleApiConnectionResult testConnection(@RequestBody GoogleApiAuthenticationDto configurationDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        GoogleApiAuthentication configuration = configurationDto.toEntity();
        return this.googleApiAuthenticationService.testConnection(configuration);
    }

    @PostMapping
    private GoogleApiAuthenticationDto create(@RequestBody GoogleApiAuthenticationDto newConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_GOOGLE_API_AUTHENTICATION).params(this.getAuditParams(newConfigurationDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            GoogleApiAuthentication newConfiguration = newConfigurationDto.toEntity();
            this.googleApiAuthenticationService.save((Object)newConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new GoogleApiAuthenticationDto(newConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @PatchMapping
    private GoogleApiAuthenticationDto update(@RequestBody GoogleApiAuthenticationDto configurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_GOOGLE_API_AUTHENTICATION);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", Objects.toString(configurationDto.getId(), ""));
        auditBuilder.params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            GoogleApiAuthentication oldConfiguration = (GoogleApiAuthentication)this.googleApiAuthenticationService.get((Serializable)((Object)configurationDto.getId()));
            GoogleApiAuthentication newConfiguration = configurationDto.toEntity();
            params.putAll(this.getUpdateAuditParams(oldConfiguration, newConfiguration));
            auditBuilder.params(params);
            this.googleApiAuthenticationService.update((Object)newConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new GoogleApiAuthenticationDto(newConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"/{id}"})
    private void delete(@PathVariable String id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_GOOGLE_API_AUTHENTICATION).params((Map)ImmutableMap.of((Object)"id", (Object)id));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            GoogleApiAuthentication config = (GoogleApiAuthentication)this.googleApiAuthenticationService.get((Serializable)((Object)id));
            this.googleApiAuthenticationService.delete((Object)config);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ExceptionHandler(value={GoogleApiAuthenticationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResult handleConfigurationException(GoogleApiAuthenticationException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private Map<String, Object> getAuditParams(GoogleApiAuthenticationDto configDto) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", Objects.toString(configDto.getId(), ""));
        params.put("name", Objects.toString(configDto.getName(), ""));
        return params;
    }

    private Map<String, Object> getUpdateAuditParams(GoogleApiAuthentication oldConfiguration, GoogleApiAuthentication newConfiguration) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", this.getChangeString(oldConfiguration, newConfiguration, GoogleApiAuthentication::getName));
        return params;
    }

    private String getChangeString(GoogleApiAuthentication oldConfiguration, GoogleApiAuthentication newConfiguration, Function<GoogleApiAuthentication, Object> valueFunction) {
        String oldValue = Objects.toString(valueFunction.apply(oldConfiguration), "");
        String newValue = Objects.toString(valueFunction.apply(newConfiguration), "");
        return String.format("%s;%s", oldValue, newValue);
    }

    @ConstructorProperties(value={"googleApiAuthenticationService", "authorizationHelper"})
    @Autowired
    public GoogleApiAuthenticationController(GoogleApiAuthenticationService googleApiAuthenticationService, AuthorizationHelper authorizationHelper) {
        this.googleApiAuthenticationService = googleApiAuthenticationService;
        this.authorizationHelper = authorizationHelper;
    }
}

