/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.application.onedrive;

import com.suncode.pwfl.administration.application.onedrive.OneDriveApplication;
import com.suncode.pwfl.administration.application.onedrive.OneDriveApplicationException;
import com.suncode.pwfl.administration.application.onedrive.OneDriveApplicationService;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthentication;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthenticationService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.web.dto.administration.application.onedrive.EditOneDriveApplicationDto;
import com.suncode.pwfl.web.dto.administration.application.onedrive.NewOneDriveApplicationDto;
import com.suncode.pwfl.web.dto.administration.application.onedrive.OneDriveApplicationDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/applicationManagement/onedrive"})
public class OneDriveApplicationController {
    private static final Logger log = LoggerFactory.getLogger(OneDriveApplicationController.class);
    private final OneDriveApplicationService oneDriveApplicationService;
    private final MicrosoftGraphApiAuthenticationService microsoftGraphApiAuthenticationService;
    private final AuthorizationHelper authorizationHelper;
    private final TransactionWrapper transactionWrapper;
    private final MessageHelperBean messageHelperBean;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    private List<OneDriveApplicationDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return (List)this.transactionWrapper.doInHibernateTransaction(session -> this.oneDriveApplicationService.getAll(new String[]{"authentication"}).stream().map(OneDriveApplicationDto::new).sorted(Comparator.comparing(applicationDto -> StringUtils.lowerCase((String)applicationDto.getName()))).collect(Collectors.toList()));
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    private OneDriveApplicationDto getById(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return (OneDriveApplicationDto)this.transactionWrapper.doInHibernateTransaction(session -> {
            OneDriveApplication config = (OneDriveApplication)this.oneDriveApplicationService.get((Serializable)((Object)id), new String[]{"authentication"});
            return new OneDriveApplicationDto(config);
        });
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    private OneDriveApplicationDto create(@RequestBody NewOneDriveApplicationDto newApplicationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_ONE_DRIVE_APPLICATION).params(new AuditParamsBuilder().param("id", (Object)newApplicationDto.getId()).param("name", (Object)newApplicationDto.getName()).param("defaultConfiguration", (Object)newApplicationDto.isDefaultConfiguration()).param("authenticationId", (Object)newApplicationDto.getAuthenticationId()).param("directoryName", (Object)newApplicationDto.getDirectoryName()).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            OneDriveApplicationDto createdApplicationDto = (OneDriveApplicationDto)this.transactionWrapper.doInHibernateTransaction(session -> {
                OneDriveApplication newApplication = new OneDriveApplication();
                this.applyToEntity(newApplication, newApplicationDto);
                this.oneDriveApplicationService.save((Object)newApplication);
                return new OneDriveApplicationDto(newApplication);
            });
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return createdApplicationDto;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    private OneDriveApplicationDto update(@PathVariable String id, @RequestBody EditOneDriveApplicationDto applicationDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_ONE_DRIVE_APPLICATION).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            OneDriveApplicationDto updatedApplicationDto = (OneDriveApplicationDto)this.transactionWrapper.doInHibernateTransaction(session -> {
                OneDriveApplication application = (OneDriveApplication)this.oneDriveApplicationService.get((Serializable)((Object)id), new String[]{"authentication"});
                auditParamsBuilder.param("name", (Object)this.paramChange(application.getName(), applicationDto.getName())).param("defaultConfiguration", (Object)this.paramChange(application.getDefaultConfiguration(), applicationDto.isDefaultConfiguration())).param("authenticationId", (Object)this.paramChange(application.getAuthentication().getId(), applicationDto.getAuthenticationId())).param("directoryName", (Object)this.paramChange(application.getDirectoryName(), applicationDto.getDirectoryName()));
                auditBuilder.params(auditParamsBuilder.build());
                this.applyToEntity(application, applicationDto);
                this.oneDriveApplicationService.update((Object)application);
                return new OneDriveApplicationDto(application);
            });
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return updatedApplicationDto;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    private void delete(@PathVariable String id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_ONE_DRIVE_APPLICATION).params(new AuditParamsBuilder().param("id", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.transactionWrapper.doInHibernateTransaction(session -> {
                OneDriveApplication config = (OneDriveApplication)this.oneDriveApplicationService.get((Serializable)((Object)id));
                this.oneDriveApplicationService.delete((Object)config);
            });
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ExceptionHandler(value={OneDriveApplicationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleConfigurationException(OneDriveApplicationException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private void applyToEntity(OneDriveApplication entity, NewOneDriveApplicationDto dto) {
        MicrosoftGraphApiAuthentication authentication = Optional.ofNullable((MicrosoftGraphApiAuthentication)this.microsoftGraphApiAuthenticationService.get((Serializable)((Object)dto.getAuthenticationId()))).orElseThrow(() -> new OneDriveApplicationException(this.messageHelperBean.getMessage("Nie_znaleziono_konfiguracji_Microsoft_Graph_API", new Object[]{dto.getAuthenticationId()})));
        entity.setId(dto.getId());
        entity.setName(dto.getName());
        entity.setDefaultConfiguration(Boolean.valueOf(dto.isDefaultConfiguration()));
        entity.setDirectoryName(dto.getDirectoryName());
        entity.setAuthentication(authentication);
    }

    private void applyToEntity(OneDriveApplication entity, EditOneDriveApplicationDto dto) {
        MicrosoftGraphApiAuthentication authentication = Optional.ofNullable((MicrosoftGraphApiAuthentication)this.microsoftGraphApiAuthenticationService.get((Serializable)((Object)dto.getAuthenticationId()))).orElseThrow(() -> new OneDriveApplicationException(this.messageHelperBean.getMessage("Nie_znaleziono_konfiguracji_Microsoft_Graph_API", new Object[]{dto.getAuthenticationId()})));
        entity.setName(dto.getName());
        entity.setDefaultConfiguration(Boolean.valueOf(dto.isDefaultConfiguration()));
        entity.setDirectoryName(dto.getDirectoryName());
        entity.setAuthentication(authentication);
    }

    private String paramChange(Object oldValue, Object newValue) {
        return String.format("%s;%s", Objects.toString(oldValue, ""), Objects.toString(newValue, ""));
    }

    @ConstructorProperties(value={"oneDriveApplicationService", "microsoftGraphApiAuthenticationService", "authorizationHelper", "transactionWrapper", "messageHelperBean"})
    @Autowired
    public OneDriveApplicationController(OneDriveApplicationService oneDriveApplicationService, MicrosoftGraphApiAuthenticationService microsoftGraphApiAuthenticationService, AuthorizationHelper authorizationHelper, TransactionWrapper transactionWrapper, MessageHelperBean messageHelperBean) {
        this.oneDriveApplicationService = oneDriveApplicationService;
        this.microsoftGraphApiAuthenticationService = microsoftGraphApiAuthenticationService;
        this.authorizationHelper = authorizationHelper;
        this.transactionWrapper = transactionWrapper;
        this.messageHelperBean = messageHelperBean;
    }
}

