/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api;

import com.suncode.pwfl.web.dto.support.ComboBoxListResult;
import com.suncode.pwfl.web.ui.DivanteColor;
import com.suncode.pwfl.web.ui.DivanteIcon;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ui"})
public class UiController {
    @ResponseBody
    @RequestMapping(value={"icons"})
    public List<String> getIcons() {
        return Stream.of(DivanteIcon.values()).map(DivanteIcon::getCode).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"colors"})
    public List<String> getColors() {
        return Stream.of(DivanteColor.values()).map(DivanteColor::getCode).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"/icons/combobox"}, method={RequestMethod.GET})
    public ComboBoxListResult getIconsForComboBox() {
        ComboBoxListResult icons = new ComboBoxListResult();
        List values = Arrays.stream(DivanteIcon.values()).sorted(Comparator.comparing(Enum::toString)).collect(Collectors.toList());
        for (DivanteIcon icon : values) {
            icons.addEntry(icon.getCode(), icon.name());
        }
        return icons;
    }

    @ResponseBody
    @RequestMapping(value={"/colors/combobox"}, method={RequestMethod.GET})
    public ComboBoxListResult getColorsForComboBox() {
        ComboBoxListResult colors = new ComboBoxListResult();
        List values = Arrays.stream(DivanteColor.values()).sorted(Comparator.comparing(Enum::toString)).collect(Collectors.toList());
        for (DivanteColor color : values) {
            colors.addEntry(color.getCode(), color.name());
        }
        return colors;
    }
}

