/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api;

import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.AuthenticatorRegistry;
import com.suncode.pwfl.security.CustomRedirectInfo;
import com.suncode.pwfl.security.RedirectEvent;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"})
public class HeartbeatController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/heartbeat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Void> heartbeat(@RequestParam Status status, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (status == Status.IDLE) {
            long elapsed;
            Long last = (Long)session.getAttribute("com.suncode.pwfl.web.controller.api.HeartbeatController.LAST");
            if (last != null && (elapsed = (System.currentTimeMillis() - last) / 1000L) >= (long)session.getMaxInactiveInterval()) {
                AuthenticatorRegistry authenticatorRegistry;
                Authenticator authenticator;
                CustomRedirectInfo customAutoLogOutReditect;
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("User [{}] last heartbeat was send at [{}]. Invalidating user session due to session timeout ({} [s])", new Object[]{SessionUtils.getLoggedUserName(), new Date(last), session.getMaxInactiveInterval()});
                }
                String ssoProvider = (String)session.getAttribute("ssoProvider");
                session.invalidate();
                request.setAttribute("auditSuccess", (Object)true);
                HttpHeaders headers = new HttpHeaders();
                if (StringUtils.isNotBlank((CharSequence)ssoProvider) && !ssoProvider.equals("plusworkflow") && (customAutoLogOutReditect = (CustomRedirectInfo)(authenticator = (authenticatorRegistry = (AuthenticatorRegistry)SpringContext.getBean(AuthenticatorRegistry.class)).getAuthenticator(ssoProvider)).getRedirections().get(RedirectEvent.AUTOMATIC_LOGOUT)) != null) {
                    switch (customAutoLogOutReditect.getRedirectType()) {
                        case REDIRECT_TO_URL: {
                            String location = customAutoLogOutReditect.getValue();
                            headers.add("location", (String)(location.startsWith("/") ? location : "/" + location));
                            break;
                        }
                        case REDIRECT_TO_PAGE_WITH_HTML: {
                            throw new NotImplementedException("Custom redirect type REDIRECT_TO_PAGE_WITH_HTML not implemented for heartbeat logout.");
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                return new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
            }
        } else {
            session.setAttribute("com.suncode.pwfl.web.controller.api.HeartbeatController.LAST", (Object)System.currentTimeMillis());
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    static enum Status {
        IDLE,
        ACTIVE;

    }
}

