/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api;

import com.suncode.pwfl.web.dto.LoggerInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logger"}, produces={"application/json"})
@Api(value="Server Loggers", description="The servlets in this API allow you to log messages to the server using Logger from the log4j library", tags={"server loggers"})
public class ExternalLogger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"/error"})
    @ResponseBody
    @ApiOperation(value="Error messages", notes="Servlet lets you log error messages on the server using Logger from the log4j library")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public void error(@ApiParam(value="The query contains a JSON object containing logging parameters", required=true) @RequestBody LoggerInfo loggerInfo) {
        this.logger.error(loggerInfo.toString());
    }

    @PostMapping(value={"/warn"})
    @ResponseBody
    @ApiOperation(value="Warning messages", notes="Servlet lets you log warning messages on the server using Logger from the log4j library")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public void warn(@ApiParam(value="The query contains a JSON object containing logging parameters", required=true) @RequestBody LoggerInfo loggerInfo) {
        this.logger.warn(loggerInfo.toString());
    }

    @PostMapping(value={"/info"})
    @ResponseBody
    @ApiOperation(value="Information messages", notes="Servlet lets you log info messages on the server using Logger from the log4j library")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public void info(@ApiParam(value="The query contains a JSON object containing logging parameters", required=true) @RequestBody LoggerInfo loggerInfo) {
        this.logger.info(loggerInfo.toString());
    }

    @PostMapping(value={"/debug"})
    @ResponseBody
    @ApiOperation(value="Information messages", notes="Servlet lets you log debug messages on the server using Logger from the log4j library")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public void debug(@ApiParam(value="The query contains a JSON object containing logging parameters", required=true) @RequestBody LoggerInfo loggerInfo) {
        this.logger.info(loggerInfo.toString());
    }

    @PostMapping(value={"/trace"})
    @ResponseBody
    @ApiOperation(value="Information messages", notes="Servlet lets you log trace messages on the server using Logger from the log4j library")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public void trace(@ApiParam(value="The query contains a JSON object containing logging parameters", required=true) @RequestBody LoggerInfo loggerInfo) {
        this.logger.trace(loggerInfo.toString());
    }
}

