/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertDocClassIndexFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UpsertDocClassIndexFormatter.class);
    private final String docclassIdKey = "docclassId";
    private final String nameKey = "indexName";
    private final String descriptionKey = "indexDescription";
    private final String typeKey = "indexType";
    private final String valuesKey = "indexValue";
    private final String listType = "list";
    private final String stringType = "string";
    private final String regexKey = "indexPattern";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String changedType;
            String docclassId = map.get("docclassId");
            String name = map.get("indexName");
            String description = map.get("indexDescription");
            String type = map.get("indexType");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            DocumentClass documentClass = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)Long.valueOf(docclassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), this.getCustomName(documentClass.getName()));
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), docclassId);
            }
            formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_NAME.toString(), this.getCustomName(name));
            formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_DESCR.toString(), this.getCustomName(description));
            formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_TYPE.toString(), this.translateIndexType(type, locale));
            String string = changedType = type != null && type.split(";").length > 1 ? type.split(";")[1] : type;
            if (StringUtils.equalsIgnoreCase((String)changedType, (String)"list")) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_VALUES.toString(), map.get("indexValue"));
            }
            if (StringUtils.equalsIgnoreCase((String)changedType, (String)"list") || StringUtils.equalsIgnoreCase((String)changedType, (String)"string")) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_REGEX.toString(), map.get("indexPattern"));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

