/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditDocumentIndexesFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(EditDocumentIndexesFormatter.class);
    private final String documentClassIdKey = "docclassId";
    private final String fileIdKey = "fileId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String fileIdId = map.get("fileId");
            String documentClassId = map.get("docclassId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)documentClassId)) {
                DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
                DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
                if (documentClass != null) {
                    formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
                } else {
                    formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), documentClassId);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)fileIdId)) {
                formattedMap.put(AuditParamsNames.FILE_ID.toString(), fileIdId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

