/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.language.LanguageUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class DeleteOrAbortProcessFormatter
extends Formatter {
    private static String IS_GROUP_OPERATION = "is_group_operation";
    private static String OPERATION_SOURCE = "operation_source";
    private static String PROCESS_NAME = "process_name";
    private static String PROCESS_DEF_ID = "processDefId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        String operationSource;
        String isGroupOperation = map.get(IS_GROUP_OPERATION);
        if (StringUtils.isNotBlank((CharSequence)isGroupOperation)) {
            map.put(IS_GROUP_OPERATION, MessageHelper.getMessage((String)isGroupOperation));
        }
        if ((operationSource = map.get(OPERATION_SOURCE)) != null) {
            if (operationSource.isEmpty()) {
                map.put(OPERATION_SOURCE, MessageHelper.getMessage((String)"Wyszukiwanie"));
            } else if (operationSource.equals("administracja_pakiety")) {
                map.put(OPERATION_SOURCE, MessageHelper.getMessage((String)operationSource));
            } else {
                map.put(OPERATION_SOURCE, MessageHelper.getMessage((String)"Widok") + " " + operationSource);
            }
        }
        String processDefId = map.get(PROCESS_DEF_ID);
        String processName = map.get(PROCESS_NAME);
        if (StringUtils.isNotBlank((CharSequence)processDefId) && StringUtils.isNotBlank((CharSequence)processName)) {
            I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
            String translatedProcessName = LanguageUtils.getProcessName((I18Nxpdl)xpdl, (String)processName, (String)processDefId);
            map.put(PROCESS_NAME, translatedProcessName);
            map.remove(PROCESS_DEF_ID);
        }
        return (LinkedHashMap)map;
    }
}

