/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class DeleteLinkProtectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(DeleteLinkProtectionFormatter.class);
    private final String userIdKey = "userId";
    private final String isGroupKey = "isGroup";
    private final String linkIdKey = "linkId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userId");
            String isGroup = map.get("isGroup");
            String linkId = map.get("linkId");
            if (StringUtils.isBlank((CharSequence)isGroup)) {
                isGroup = "FALSE";
            }
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName(userId));
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            Link link = ((LinkService)SpringContext.getBean(LinkService.class)).getLink(Long.valueOf(linkId), new String[0]);
            if (link != null) {
                formattedMap.put(AuditParamsNames.LINK_NAME.toString(), link.getName());
            } else {
                formattedMap.put(AuditParamsNames.LINK_ID.toString(), linkId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

