/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ChangeReplacementVariableTypeFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ChangeReplacementVariableTypeFormatter.class);
    private final String processDefIdKey = "processDefId";
    private final String replacementTypeKey = "replacementType";
    private final String oldReplacementTypeKey = "oldReplacementType";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processDefId = map.get("processDefId");
            I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            String oldReplacement = map.get("oldReplacementType");
            String newReplacement = map.get("replacementType");
            if (!oldReplacement.isEmpty()) {
                oldReplacement = MessageHelper.getMessage((String)("changeuser.replacement.type." + oldReplacement.toLowerCase()));
            }
            newReplacement = MessageHelper.getMessage((String)("changeuser.replacement.type." + newReplacement.toLowerCase()));
            String formattedReplacementType = String.format("%s > %s", oldReplacement, newReplacement);
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId, xpdl));
            formattedMap.put(AuditParamsNames.REPLACEMENT_TYPE.toString(), formattedReplacementType);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

