/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelUserCalendarEventsFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(CancelUserCalendarEventsFormatter.class);
    private final String resourceIdKey = "resourceId";
    private final String fromDateTimeKey = "fromDateTime";
    private final String toDateTimeKey = "toDateTime";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String resourceId = map.get("resourceId");
            String fromDateTime = map.get("fromDateTime");
            String toDateTime = map.get("toDateTime");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)resourceId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_ID.name(), this.formatTextValueChange(resourceId));
            }
            if (StringUtils.isNotBlank((CharSequence)fromDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_FROM_DATETIME.name(), this.formatTextValueChange(fromDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)toDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_TO_DATETIME.name(), this.formatTextValueChange(toDateTime));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

